/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.event.FactModelEvent;
import zeus.generator.event.FactModelListener;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.FactModel;
import zeus.util.Misc;
import zeus.util.OrderedHashtable;

public class GroupManager
extends FactModel
implements ActionListener,
FactModelListener {
    protected static int group_count = 0;
    protected DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
    protected String selectedGroup;
    protected Hashtable table = new Hashtable();
    protected OrderedHashtable backup = new OrderedHashtable();

    public GroupManager(OntologyDb ontologyDb, AttributeModel attributeModel, boolean bl, int n, Fact[] factArray) {
        super(ontologyDb, attributeModel, bl, n, factArray);
    }

    public DefaultComboBoxModel getComboBoxModel() {
        return this.comboModel;
    }

    public void resetManager(Hashtable hashtable, Fact[] factArray) {
        this.resetManager(hashtable);
        for (int i = 0; i < factArray.length; ++i) {
            this.backup.put(factArray[i].getId(), factArray[i]);
        }
    }

    public void resetManager(Hashtable hashtable) {
        this.backup.clear();
        this.selectedGroup = null;
        this.table = hashtable;
        if (this.comboModel.getSize() > 0) {
            this.comboModel.removeAllElements();
        }
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.comboModel.addElement(string);
            if (this.selectedGroup != null) continue;
            this.selectedGroup = string;
        }
        if (this.selectedGroup != null) {
            this.comboModel.setSelectedItem(this.selectedGroup);
        }
    }

    public Hashtable getManagerData() {
        if (this.selectedGroup != null) {
            Fact[] factArray = super.getData();
            this.table.put(this.selectedGroup, this.factVector(factArray));
        }
        return this.table;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector;
        String string = (String)this.comboModel.getSelectedItem();
        if (this.selectedGroup != null) {
            Fact[] factArray = super.getData();
            this.table.put(this.selectedGroup, this.factVector(factArray));
        }
        if ((vector = (Vector)this.table.get(string)) == null && this.selectedGroup != null) {
            vector = (Vector)this.table.get(this.selectedGroup);
            this.table.remove(this.selectedGroup);
            this.table.put(string, vector);
            String string2 = this.selectedGroup;
            this.selectedGroup = null;
            this.comboModel.removeElement(string2);
            this.comboModel.addElement(string);
            this.comboModel.setSelectedItem(string);
            this.fireNameChanged(this.comboModel, string2, string);
        } else if (vector != null) {
            super.reset(this.factArray(vector));
        }
        this.selectedGroup = string;
    }

    public void factModelChanged(FactModelEvent factModelEvent) {
        Fact fact = factModelEvent.getFact();
        switch (factModelEvent.getEventType()) {
            case 0: {
                Enumeration enumeration = this.table.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector = (Vector)enumeration.nextElement();
                    vector.addElement(new Fact(fact));
                }
                this.backup.put(fact.getId(), fact);
                Fact[] factArray = new Fact[]{new Fact(fact)};
                super.addRows(factArray);
                break;
            }
            case 1: {
                Enumeration enumeration = this.table.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector = (Vector)enumeration.nextElement();
                    for (int i = 0; i < vector.size(); ++i) {
                        Fact fact2 = (Fact)vector.elementAt(i);
                        if (!fact.getId().equals(fact2.getId())) continue;
                        vector.removeElementAt(i--);
                    }
                }
                this.backup.remove(fact.getId());
                Fact[] factArray = new Fact[]{fact};
                super.removeRows(factArray);
                break;
            }
            case 2: {
                String string;
                String string2;
                int n;
                String[] stringArray;
                int n2;
                String string3 = factModelEvent.getPreviousId();
                String string4 = factModelEvent.getCurrentId();
                Enumeration enumeration = this.table.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector = (Vector)enumeration.nextElement();
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        Fact fact3 = (Fact)vector.elementAt(n2);
                        if (string3.equals(fact3.getId())) {
                            fact3.setId(fact.ID());
                        }
                        stringArray = fact3.listAttributes();
                        for (n = 0; n < stringArray.length; ++n) {
                            string2 = fact3.getValue(stringArray[n]);
                            string = Misc.substitute(string2, string3, string4);
                            if (string.equals(string2)) continue;
                            fact3.setValue(stringArray[n], string);
                        }
                    }
                }
                Fact[] factArray = super.getData();
                for (n2 = 0; n2 < factArray.length; ++n2) {
                    if (factArray[n2].getId().equals(string3)) {
                        factArray[n2].setId(fact.ID());
                    }
                    stringArray = factArray[n2].listAttributes();
                    for (n = 0; n < stringArray.length; ++n) {
                        string2 = factArray[n2].getValue(stringArray[n]);
                        string = Misc.substitute(string2, string3, string4);
                        if (string.equals(string2)) continue;
                        factArray[n2].setValue(stringArray[n], string);
                    }
                }
                this.backup.reKey(string3, string4, fact);
                super.reset(factArray);
                this.fireNameChanged(fact, string3, string4);
            }
        }
    }

    protected Fact[] factArray(Vector vector) {
        Fact[] factArray = new Fact[vector.size()];
        for (int i = 0; i < factArray.length; ++i) {
            factArray[i] = (Fact)vector.elementAt(i);
        }
        return factArray;
    }

    protected Vector factVector(Fact[] factArray) {
        Vector<Fact> vector = new Vector<Fact>();
        for (int i = 0; i < factArray.length; ++i) {
            vector.addElement(factArray[i]);
        }
        return vector;
    }

    public void newGroup() {
        String string = "group" + group_count++;
        while (this.table.containsKey(string)) {
            string = "group" + group_count++;
        }
        Vector<Fact> vector = new Vector<Fact>();
        Enumeration enumeration = this.backup.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new Fact((Fact)enumeration.nextElement()));
        }
        this.table.put(string, vector);
        this.comboModel.addElement(string);
        this.comboModel.setSelectedItem(string);
        this.fireChanged();
    }

    public void deleteGroup() {
        if (this.selectedGroup == null) {
            return;
        }
        if (this.comboModel.getSize() <= 1) {
            JOptionPane.showMessageDialog(null, "Cannot delete group.\nAt least one group must exist.", "Error", 0);
            return;
        }
        String string = this.selectedGroup;
        this.selectedGroup = null;
        this.comboModel.removeElement(string);
        this.table.remove(string);
        this.comboModel.setSelectedItem(this.comboModel.getElementAt(0));
        this.fireChanged();
    }

    public void copyGroup() {
        if (this.selectedGroup == null) {
            return;
        }
        Fact[] factArray = super.getData();
        Vector<Fact> vector = new Vector<Fact>();
        for (int i = 0; i < factArray.length; ++i) {
            vector.addElement(new Fact(factArray[i]));
        }
        String string = "group" + group_count++;
        while (this.table.containsKey(string)) {
            string = "group" + group_count++;
        }
        this.table.put(string, vector);
        this.comboModel.addElement(string);
        this.comboModel.setSelectedItem(string);
        this.fireChanged();
    }
}

