/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.util.BasicFactModel;
import zeus.gui.editors.ValidatingModel;
import zeus.util.Misc;

public class ConstraintsModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel,
RenameListener {
    static final int CONSTRAINT = 0;
    protected static final String[] columnNames = new String[]{"Constraint"};
    protected EventListenerList changeListeners = new EventListenerList();
    protected Vector data = new Vector();
    protected Vector validityInfo = new Vector();
    protected BasicFactModel preconditionsModel;
    protected BasicFactModel postconditionsModel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ConstraintsModel(BasicFactModel basicFactModel, BasicFactModel basicFactModel2, LogicalFn[] logicalFnArray) {
        this.preconditionsModel = basicFactModel;
        this.postconditionsModel = basicFactModel2;
        basicFactModel.addChangeListener(this);
        basicFactModel2.addChangeListener(this);
        basicFactModel.addRenameListener(this);
        basicFactModel2.addRenameListener(this);
        this.reset(logicalFnArray);
    }

    public void reset(LogicalFn[] logicalFnArray) {
        int n = this.data.size();
        this.data.removeAllElements();
        this.validityInfo.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        Vector vector = this.getConditions();
        for (int i = 0; i < logicalFnArray.length; ++i) {
            this.data.addElement(logicalFnArray[i].toString());
            this.validityInfo.addElement(this.isValid(logicalFnArray[i], vector));
        }
        this.fireTableRowsInserted(0, logicalFnArray.length - 1);
    }

    public LogicalFn[] getData() {
        Vector vector = new Vector();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.validityInfo.elementAt(i).equals(Boolean.TRUE)) continue;
            vector.addElement(this.data.elementAt(i));
        }
        LogicalFn[] logicalFnArray = new LogicalFn[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            logicalFnArray[i] = (LogicalFn)ZeusParser.Expression((String)vector.elementAt(i));
        }
        return logicalFnArray;
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.data.removeElementAt(nArray[i] - i);
            this.validityInfo.removeElementAt(nArray[i] - i);
            this.fireTableRowsDeleted(nArray[i] - i, nArray[i] - i);
        }
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    public void addNewRow() {
        this.data.addElement("true");
        Vector vector = this.getConditions();
        this.validityInfo.addElement(this.isValid("true", vector));
        int n = this.data.size();
        this.fireTableRowsInserted(n - 1, n - 1);
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    protected Vector getConditions() {
        int n;
        Vector<String> vector = new Vector<String>();
        Fact[] factArray = this.preconditionsModel.getData();
        for (n = 0; n < factArray.length; ++n) {
            vector.addElement(factArray[n].getId());
        }
        factArray = this.postconditionsModel.getData();
        for (n = 0; n < factArray.length; ++n) {
            vector.addElement(factArray[n].getId());
        }
        return vector;
    }

    protected Boolean isValid(LogicalFn logicalFn, Vector vector) {
        Vector vector2 = logicalFn.variables();
        for (int i = 0; i < vector2.size(); ++i) {
            if (vector.contains(vector2.elementAt(i).toString())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean isValid(String string, Vector vector) {
        ValueFunction valueFunction = ZeusParser.Expression(string);
        if (valueFunction != null && valueFunction instanceof LogicalFn) {
            return this.isValid((LogicalFn)valueFunction, vector);
        }
        return new Boolean(false);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo.elementAt(n).equals(Boolean.TRUE);
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.data.elementAt(n);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        String string = (String)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                String string2 = (String)object;
                if (string2.equals(string)) {
                    return;
                }
                this.data.setElementAt(string2, n);
                Vector vector = this.getConditions();
                this.validityInfo.setElementAt(this.isValid(string2, vector), n);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.preconditionsModel || changeEvent.getSource() == this.postconditionsModel) {
            Vector vector = this.getConditions();
            for (int i = 0; i < this.data.size(); ++i) {
                String string = (String)this.data.elementAt(i);
                this.validityInfo.setElementAt(this.isValid(string, vector), i);
            }
            this.fireTableDataChanged();
        }
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string = (String)renameEvent.getOriginal();
        String string2 = (String)renameEvent.getCurrent();
        for (int i = 0; i < this.data.size(); ++i) {
            String string3 = (String)this.data.elementAt(i);
            this.data.setElementAt(Misc.substitute(string3, string, string2), i);
        }
        this.fireTableDataChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ConstraintsModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ConstraintsModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? ConstraintsModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

