/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import zeus.concepts.OntologyDb;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ElseFn;
import zeus.concepts.fn.NumericFn;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.task.TaskEditor;
import zeus.generator.util.AttributeDialog;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.AttributeSelector;
import zeus.generator.util.AttributeTable;
import zeus.generator.util.AttributeTreeModel;
import zeus.generator.util.ControlPanel;
import zeus.generator.util.FactModel;
import zeus.generator.util.FactPanel;
import zeus.gui.fields.LargeTextField;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class ConditionsPanel
extends JPanel {
    protected PrimitiveTask task;
    protected LargeTextField costfield;
    protected LargeTextField timefield;
    protected FactPanel preconditionsPanel;
    protected FactPanel postconditionsPanel;
    protected FactModel postconditionsModel;
    protected FactModel preconditionsModel;

    public ConditionsPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, TaskEditor taskEditor, PrimitiveTask primitiveTask) {
        this.task = primitiveTask;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        ControlPanel controlPanel = new ControlPanel(taskEditor, "Task Preconditions and Effects", true, false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(controlPanel, gridBagConstraints);
        this.add(controlPanel);
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Task Cost and Time");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        jPanel3.setBackground(Color.lightGray);
        JLabel jLabel = new JLabel("Cost:");
        jLabel.setToolTipText("Default cost of performing this task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        this.costfield = new LargeTextField(2, 15);
        this.costfield.setLineWrap(true);
        this.costfield.setText(primitiveTask.getCostFn().toString());
        this.costfield.addChangeListener(taskEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 16);
        gridBagLayout.setConstraints(this.costfield, gridBagConstraints);
        jPanel3.add(this.costfield);
        jLabel = new JLabel("Time:");
        jLabel.setToolTipText("Default duration of this task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(16, 16, 16, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        this.timefield = new LargeTextField(2, 15);
        this.timefield.setLineWrap(true);
        this.timefield.setText(primitiveTask.getTimeFn().toString());
        this.timefield.addChangeListener(taskEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(this.timefield, gridBagConstraints);
        jPanel3.add(this.timefield);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        jLabel = new JLabel(new ImageIcon(string2 + "uparrow.gif"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel(new ImageIcon(string2 + "arrow.gif"));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel(new ImageIcon(string2 + "body.gif"));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel(new ImageIcon(string2 + "arrow.gif"));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel(new ImageIcon(string2 + "downarrow.gif"));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel2.setBackground(Color.lightGray);
        this.preconditionsPanel = new FactPanel(ontologyDb, taskEditor, primitiveTask.getPreconditions(), true, 1, "Task Inputs/Preconditions");
        this.postconditionsPanel = new FactPanel(ontologyDb, taskEditor, primitiveTask.getPostconditions(), true, 2, "Task Effects/Outputs");
        this.preconditionsModel = this.preconditionsPanel.getFactModel();
        this.postconditionsModel = this.postconditionsPanel.getFactModel();
        AttributeModel attributeModel = this.preconditionsPanel.getAttributeModel();
        AttributeModel attributeModel2 = this.postconditionsPanel.getAttributeModel();
        AttributeTable attributeTable = this.preconditionsPanel.getAttributeTable();
        AttributeTable attributeTable2 = this.postconditionsPanel.getAttributeTable();
        attributeTable.setFactModels(this.preconditionsModel, this.postconditionsModel);
        attributeTable2.setFactModels(this.preconditionsModel, this.postconditionsModel);
        this.preconditionsModel.addRelatedModel(this.postconditionsModel);
        this.postconditionsModel.addRelatedModel(this.preconditionsModel);
        SymRenameAction symRenameAction = new SymRenameAction();
        this.preconditionsModel.addRenameListener(symRenameAction);
        this.postconditionsModel.addRenameListener(symRenameAction);
        this.preconditionsModel.addRenameListener(attributeModel);
        this.preconditionsModel.addRenameListener(attributeModel2);
        this.postconditionsModel.addRenameListener(attributeModel);
        this.postconditionsModel.addRenameListener(attributeModel2);
        SymFocusAction symFocusAction = new SymFocusAction();
        this.costfield.addFocusListener(symFocusAction);
        this.timefield.addFocusListener(symFocusAction);
        SymMouseAction symMouseAction = new SymMouseAction();
        this.costfield.addMouseListener(symMouseAction);
        this.timefield.addMouseListener(symMouseAction);
        jPanel2.add(this.preconditionsPanel);
        jPanel2.add(this.postconditionsPanel);
    }

    FactModel getPostconditionsModel() {
        return this.postconditionsModel;
    }

    FactModel getPreconditionsModel() {
        return this.preconditionsModel;
    }

    void save() {
        this.task.setCostFn(this.costfield.getText());
        this.task.setTimeFn(this.timefield.getText());
        this.task.setPreconditions(this.preconditionsPanel.getData());
        this.task.setPostconditions(this.postconditionsPanel.getData());
    }

    class SymRenameAction
    implements RenameListener {
        SymRenameAction() {
        }

        public void nameChanged(RenameEvent renameEvent) {
            String string = (String)renameEvent.getOriginal();
            String string2 = (String)renameEvent.getCurrent();
            String string3 = ConditionsPanel.this.costfield.getText();
            ConditionsPanel.this.costfield.setText(Misc.substitute(string3, string, string2));
            string3 = ConditionsPanel.this.timefield.getText();
            ConditionsPanel.this.timefield.setText(Misc.substitute(string3, string, string2));
        }
    }

    class SymMouseAction
    extends MouseAdapter
    implements AttributeSelector {
        protected JTextComponent field = null;
        protected AttributeDialog dialog = null;
        protected AttributeTreeModel attributeTreeModel = new AttributeTreeModel();

        public SymMouseAction() {
            this.attributeTreeModel.setFactModels(ConditionsPanel.this.preconditionsModel, ConditionsPanel.this.postconditionsModel);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.field = (JTextComponent)mouseEvent.getSource();
                if (this.dialog == null) {
                    this.dialog = new AttributeDialog((Frame)SwingUtilities.getRoot(this.field), this.attributeTreeModel);
                }
                this.field = (JTextComponent)mouseEvent.getSource();
                this.dialog.setLocationRelativeTo(this.field);
                this.dialog.display(this);
            }
        }

        public void attributeSelected(String string) {
            try {
                Document document = this.field.getDocument();
                int n = document.getLength();
                AttributeSet attributeSet = document.getDefaultRootElement().getAttributes();
                document.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SymFocusAction
    implements FocusListener {
        SymFocusAction() {
        }

        public void focusLost(FocusEvent focusEvent) {
            LargeTextField largeTextField = (LargeTextField)focusEvent.getSource();
            this.validate(largeTextField);
        }

        public void focusGained(FocusEvent focusEvent) {
            LargeTextField largeTextField = (LargeTextField)focusEvent.getSource();
            largeTextField.setForeground(Color.black);
        }

        protected void validate(LargeTextField largeTextField) {
            String string = largeTextField.getText();
            ValueFunction valueFunction = ZeusParser.Expression(string);
            if (valueFunction != null && (valueFunction instanceof NumericFn || valueFunction instanceof ElseFn)) {
                largeTextField.setForeground(Color.black);
            } else {
                largeTextField.setForeground(Color.red);
            }
        }
    }
}

