/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Vector;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.UtilityModel;
import zeus.generator.code.VisualiserInfo;

public class VisualiserModel
extends UtilityModel {
    static final int NAME = 0;
    static final int HOST = 1;
    static final int SERVER_FILE = 2;
    static final int HAS_GUI = 3;
    static final int EXTERNAL = 4;
    protected static final String[] columnNames = new String[]{"Name", "Host", "DNS file", "Create GUI?", "External Program"};
    protected Vector data = new Vector();
    protected GenerationPlan genplan;

    public VisualiserModel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.refresh();
    }

    public void addNewRow() {
        this.genplan.createVisualiser();
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            VisualiserInfo visualiserInfo = (VisualiserInfo)this.data.elementAt(nArray[i] - i);
            this.genplan.removeVisualiser(visualiserInfo.id);
        }
    }

    protected void refresh() {
        this.data.removeAllElements();
        VisualiserInfo[] visualiserInfoArray = this.genplan.getVisualisers();
        for (int i = 0; i < visualiserInfoArray.length; ++i) {
            this.data.addElement(visualiserInfoArray[i]);
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return columnNames.length - 2;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        VisualiserInfo visualiserInfo = (VisualiserInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return visualiserInfo.name;
            }
            case 1: {
                return visualiserInfo.host;
            }
            case 3: {
                return new Boolean(visualiserInfo.has_gui);
            }
            case 4: {
                return visualiserInfo.zeus_external;
            }
            case 2: {
                return visualiserInfo.dns_file;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        VisualiserInfo visualiserInfo = (VisualiserInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                visualiserInfo.name = this.updateString(visualiserInfo.name, object, false);
                break;
            }
            case 1: {
                visualiserInfo.host = this.updateString(visualiserInfo.host, object);
                break;
            }
            case 3: {
                visualiserInfo.has_gui = this.updateBoolean(visualiserInfo.has_gui, object);
                break;
            }
            case 4: {
                visualiserInfo.zeus_external = this.updateString(visualiserInfo.zeus_external, object);
                break;
            }
            case 2: {
                visualiserInfo.dns_file = this.updateString(visualiserInfo.dns_file, object);
            }
        }
        if (this.changed) {
            this.genplan.setVisualiser(visualiserInfo);
        }
    }
}

