/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import zeus.generator.code.DbProxyModel;
import zeus.generator.code.FacilitatorModel;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.NameserverModel;
import zeus.generator.code.UtilityModel;
import zeus.generator.code.VisualiserModel;
import zeus.gui.fields.NameField;
import zeus.gui.fields.RealNumberField;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class UtilityPanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected GenerationPlan genplan;
    protected NameserverModel nameserverModel;
    protected JTable nameserverTable;
    protected FacilitatorModel facilitatorModel;
    protected JTable facilitatorTable;
    protected VisualiserModel visualiserModel;
    protected JTable visualiserTable;
    protected DbProxyModel dbProxyModel;
    protected JTable dbProxyTable;

    public UtilityPanel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this.add(jPanel4);
        this.nameserverModel = new NameserverModel(generationPlan);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jCheckBox);
        TableColumn tableColumn = new TableColumn(0, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.nameserverModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.nameserverModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 8, new CheckBoxCellRenderer(), defaultCellEditor);
        tableColumn.setHeaderValue(this.nameserverModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new RealNumberField(0.0, 1000.0)));
        tableColumn.setHeaderValue(this.nameserverModel.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(4, 24);
        tableColumn.setHeaderValue(this.nameserverModel.getColumnName(4));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(5, 24);
        tableColumn.setHeaderValue(this.nameserverModel.getColumnName(5));
        defaultTableColumnModel.addColumn(tableColumn);
        this.nameserverTable = new JTable(this.nameserverModel, defaultTableColumnModel);
        this.nameserverTable.getTableHeader().setReorderingAllowed(false);
        this.nameserverTable.setColumnSelectionAllowed(false);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Nameservers");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        UtilityToolBar utilityToolBar = new UtilityToolBar(this.nameserverTable, this.nameserverModel, "Generation Plan: Nameservers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(utilityToolBar, gridBagConstraints);
        jPanel.add(utilityToolBar);
        JScrollPane jScrollPane = new JScrollPane(this.nameserverTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.nameserverTable.setBackground(Color.white);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.facilitatorModel = new FacilitatorModel(generationPlan);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        defaultTableColumnModel = new DefaultTableColumnModel();
        jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        defaultCellEditor = new DefaultCellEditor(jCheckBox);
        tableColumn = new TableColumn(0, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.facilitatorModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.facilitatorModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setHeaderValue(this.facilitatorModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new RealNumberField(0.0, 1000.0)));
        tableColumn.setHeaderValue(this.facilitatorModel.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        this.facilitatorTable = new JTable(this.facilitatorModel, defaultTableColumnModel);
        this.facilitatorTable.getTableHeader().setReorderingAllowed(false);
        this.facilitatorTable.setColumnSelectionAllowed(false);
        jScrollPane = new JScrollPane(this.facilitatorTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.facilitatorTable.setBackground(Color.white);
        titledBorder = BorderFactory.createTitledBorder("Facilitators");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints = new GridBagConstraints();
        utilityToolBar = new UtilityToolBar(this.facilitatorTable, this.facilitatorModel, "Generation Plan: Facilitators");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(utilityToolBar, gridBagConstraints);
        jPanel2.add(utilityToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        this.visualiserModel = new VisualiserModel(generationPlan);
        gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        jPanel3.setBackground(Color.lightGray);
        defaultTableColumnModel = new DefaultTableColumnModel();
        jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        defaultCellEditor = new DefaultCellEditor(jCheckBox);
        tableColumn = new TableColumn(0, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.visualiserModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.visualiserModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setHeaderValue(this.visualiserModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.visualiserTable = new JTable(this.visualiserModel, defaultTableColumnModel);
        this.visualiserTable.getTableHeader().setReorderingAllowed(false);
        this.visualiserTable.setColumnSelectionAllowed(false);
        jScrollPane = new JScrollPane(this.visualiserTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.visualiserTable.setBackground(Color.white);
        titledBorder = BorderFactory.createTitledBorder("Visualisers");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder);
        gridBagConstraints = new GridBagConstraints();
        utilityToolBar = new UtilityToolBar(this.visualiserTable, this.visualiserModel, "Generation Plan: Visualisers");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(utilityToolBar, gridBagConstraints);
        jPanel3.add(utilityToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel3.add(jScrollPane);
        this.dbProxyModel = new DbProxyModel(generationPlan);
        gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        jPanel4.setBackground(Color.lightGray);
        defaultTableColumnModel = new DefaultTableColumnModel();
        jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        defaultCellEditor = new DefaultCellEditor(jCheckBox);
        tableColumn = new TableColumn(0, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.dbProxyModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.dbProxyModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24);
        tableColumn.setHeaderValue(this.dbProxyModel.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setHeaderValue(this.dbProxyModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.dbProxyTable = new JTable(this.dbProxyModel, defaultTableColumnModel);
        this.dbProxyTable.getTableHeader().setReorderingAllowed(false);
        this.dbProxyTable.setColumnSelectionAllowed(false);
        jScrollPane = new JScrollPane(this.dbProxyTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.dbProxyTable.setBackground(Color.white);
        titledBorder = BorderFactory.createTitledBorder("Database Proxys");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel4.setBorder(titledBorder);
        gridBagConstraints = new GridBagConstraints();
        utilityToolBar = new UtilityToolBar(this.dbProxyTable, this.dbProxyModel, "Generation Plan: Database Proxys");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(utilityToolBar, gridBagConstraints);
        jPanel4.add(utilityToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel4.add(jScrollPane);
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    protected class UtilityToolBar
    extends JToolBar
    implements ActionListener {
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected HelpWindow helpWin;
        protected JTable table;
        protected String help_page;
        protected UtilityModel model;

        public UtilityToolBar(JTable jTable, UtilityModel utilityModel, String string) {
            this.model = utilityModel;
            this.table = jTable;
            this.help_page = string;
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New entry");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete selected entries");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.model.addNewRow();
            } else if (object == this.deleteBtn) {
                if (this.table.getSelectedRow() == -1) {
                    UtilityPanel.this.errorMsg(0);
                    return;
                }
                this.model.removeRows(this.table.getSelectedRows());
                this.table.clearSelection();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", this.help_page);
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    protected class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setSelected((Boolean)object);
            }
            return this;
        }
    }
}

