/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.TaskModel;
import zeus.gui.fields.NameField;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class TaskPanel
extends JPanel {
    protected GenerationPlan genplan;
    protected TaskModel taskModel;
    protected JTable taskTable;

    public TaskPanel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        this.taskModel = new TaskModel(generationPlan);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jCheckBox);
        TableColumn tableColumn = new TableColumn(0, 8, new CheckBoxCellRenderer(), defaultCellEditor);
        tableColumn.setHeaderValue(this.taskModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.taskModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setHeaderValue(this.taskModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.taskModel.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        this.taskTable = new JTable(this.taskModel, defaultTableColumnModel);
        this.taskTable.getTableHeader().setReorderingAllowed(false);
        this.taskTable.setColumnSelectionAllowed(false);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Tasks");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        this.setBorder(titledBorder);
        JScrollPane jScrollPane = new JScrollPane(this.taskTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setMinimumSize(new Dimension(160, 80));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.taskTable.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        TaskToolBar taskToolBar = new TaskToolBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(taskToolBar, gridBagConstraints);
        this.add(taskToolBar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    protected class TaskToolBar
    extends JToolBar
    implements ActionListener {
        protected JToggleButton helpBtn;
        protected HelpWindow helpWin;

        public TaskToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
            this.helpBtn = new JToggleButton(new ImageIcon(string + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", "Generation Plan: Tasks");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    protected class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setSelected((Boolean)object);
            }
            return this;
        }
    }
}

