/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JTextArea;
import zeus.generator.GeneratorModel;
import zeus.generator.code.AgentInfo;
import zeus.generator.code.DbProxyInfo;
import zeus.generator.code.FacilitatorInfo;
import zeus.generator.code.GenerationInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.NameserverInfo;
import zeus.generator.code.VisualiserInfo;
import zeus.generator.code.Writer;
import zeus.util.SystemProps;

public class ScriptWriter
extends Writer {
    protected String language = SystemProps.getProperty("agent.language");
    protected int ZSHUNIX = 2;
    protected int ZSHWINDOWS = 3;
    protected static final String[][] ScriptName = new String[][]{{"run1", "run3", "run2"}, {"run1.bat", "run3.bat", "run2.bat"}, {"all.scr", "runAll"}, {"all.scr", "runAll.bat"}};
    protected static final String[][] Preamble = new String[][]{{"#!/usr/bin/csh\n#This script runs the root servers and should be run first", "#!/usr/bin/csh\n#This script runs the non-root servers and other utility agents", "#!/usr/bin/csh\n#This script runs the task agents"}, {"REM This script runs the root servers and should be started first", "REM This script runs the non-root servers and other utility agents", "REM This script runs the task agents"}, {""}};

    public ScriptWriter(GenerationPlan generationPlan, GeneratorModel generatorModel, String string, JTextArea jTextArea) {
        super(generationPlan, generatorModel, string, jTextArea);
    }

    public void write() {
        String string = this.genplan.getPlatform();
        int n = 0;
        if (string.equals("Unix")) {
            n = 0;
        } else if (string.equals("Windows")) {
            n = 1;
        } else {
            this.textArea.append("Error: Unknown platform " + string + "-- cannot write scripts");
            return;
        }
        String string2 = this.genplan.getShell();
        if (string2.equals("no shell")) {
            this.normalScripts(n);
        } else if (string2.equals("zsh")) {
            this.zshScripts(n);
        }
    }

    public void zshScripts(int n) {
        try {
            NameserverInfo[] nameserverInfoArray = this.genplan.getNameservers();
            FacilitatorInfo[] facilitatorInfoArray = this.genplan.getFacilitators();
            VisualiserInfo[] visualiserInfoArray = this.genplan.getVisualisers();
            DbProxyInfo[] dbProxyInfoArray = this.genplan.getDbProxys();
            AgentInfo[] agentInfoArray = this.genplan.getAgents();
            this.textArea.append("Writing zsh.zsh script " + ScriptName[this.ZSHUNIX][0] + "\n");
            PrintWriter printWriter = this.createFile(ScriptName[n + this.ZSHUNIX][0]);
            printWriter.println("ns");
            for (int i = 0; i < agentInfoArray.length; ++i) {
                String string = this.writeForScript(n, agentInfoArray[i], printWriter);
                this.textArea.append(string + "\n");
            }
            printWriter.println("yp");
            printWriter.println("vis");
            printWriter.flush();
            printWriter.close();
            this.textArea.append("Writing batch file: " + ScriptName[n + this.ZSHUNIX][1]);
            printWriter = this.createFile(ScriptName[n + this.ZSHUNIX][1]);
            String string = agentInfoArray[0].ontology_file;
            if (n == 0) {
                printWriter.println("java zsh.zsh " + string + " 0.2 all.scr &");
            } else {
                printWriter.println("start /min java zsh.zsh " + string + " 0.2 all.scr ");
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.textArea.append("I/O Error while attempting to create/write script");
        }
    }

    public void normalScripts(int n) {
        try {
            int n2;
            NameserverInfo[] nameserverInfoArray = this.genplan.getNameservers();
            FacilitatorInfo[] facilitatorInfoArray = this.genplan.getFacilitators();
            VisualiserInfo[] visualiserInfoArray = this.genplan.getVisualisers();
            DbProxyInfo[] dbProxyInfoArray = this.genplan.getDbProxys();
            AgentInfo[] agentInfoArray = this.genplan.getAgents();
            this.textArea.append("Attempting to write script: " + ScriptName[n][0] + "\n");
            PrintWriter printWriter = this.createFile(ScriptName[n][0]);
            printWriter.println(Preamble[n][0]);
            for (n2 = 0; n2 < nameserverInfoArray.length; ++n2) {
                if (!nameserverInfoArray[n2].is_root) continue;
                this.writeCommand(n, nameserverInfoArray[n2], printWriter);
            }
            printWriter.flush();
            printWriter.close();
            this.textArea.append("Script: " + ScriptName[n][0] + " written successfully\n");
            this.textArea.append("Attempting to write script: " + ScriptName[n][1] + "\n");
            printWriter = this.createFile(ScriptName[n][1]);
            printWriter.println(Preamble[n][1]);
            for (n2 = 0; n2 < nameserverInfoArray.length; ++n2) {
                if (nameserverInfoArray[n2].is_root) continue;
                this.writeCommand(n, nameserverInfoArray[n2], printWriter);
            }
            for (n2 = 0; n2 < facilitatorInfoArray.length; ++n2) {
                this.writeCommand(n, facilitatorInfoArray[n2], printWriter);
            }
            for (n2 = 0; n2 < visualiserInfoArray.length; ++n2) {
                this.writeCommand(n, visualiserInfoArray[n2], printWriter);
            }
            for (n2 = 0; n2 < dbProxyInfoArray.length; ++n2) {
                this.writeCommand(n, dbProxyInfoArray[n2], printWriter);
            }
            printWriter.flush();
            printWriter.close();
            this.textArea.append("Script: " + ScriptName[n][1] + " written successfully\n");
            this.textArea.append("Attempting to write script: " + ScriptName[n][2] + "\n");
            printWriter = this.createFile(ScriptName[n][2]);
            printWriter.println(Preamble[n][2]);
            for (n2 = 0; n2 < agentInfoArray.length; ++n2) {
                this.writeCommand(n, agentInfoArray[n2], printWriter);
            }
            printWriter.flush();
            printWriter.close();
            this.textArea.append("Script: " + ScriptName[n][2] + " written successfully\n");
            switch (n) {
                case 0: {
                    this.textArea.append("Setting script permissions\n");
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec("chmod 777 " + ScriptName[n][0] + " " + ScriptName[n][1] + " " + ScriptName[n][2]);
                }
            }
        }
        catch (IOException iOException) {
            this.textArea.append("I/O Error while attempting to create/write script");
        }
    }

    protected String writeForScript(int n, GenerationInfo generationInfo, PrintWriter printWriter) {
        String[] stringArray = generationInfo.summarize();
        String string = stringArray[2];
        printWriter.println(string);
        return string;
    }

    protected void writeCommand(int n, GenerationInfo generationInfo, PrintWriter printWriter) {
        String string = generationInfo.isValid();
        if (string != null) {
            this.textArea.append(string);
            return;
        }
        String[] stringArray = generationInfo.summarize();
        String string2 = this.language + " " + stringArray[2];
        switch (n) {
            case 0: {
                string2 = string2 + " & ";
                String string3 = ScriptWriter.updateFilename(this.directory, 0);
                if (generationInfo.host == null || generationInfo.host.equals("127.0.0.1") || generationInfo.host.equals(GenerationInfo.LOCALHOST)) {
                    printWriter.println(string2);
                    break;
                }
                printWriter.println("rsh " + generationInfo.host + " 'cd " + string3 + "; " + string2 + "' & ");
                break;
            }
            case 1: {
                string2 = "start /min " + string2;
                String string4 = ScriptWriter.updateFilename(this.directory, 1);
                if (generationInfo.host == null || generationInfo.host.equals("127.0.0.1") || generationInfo.host.equals(GenerationInfo.LOCALHOST)) {
                    printWriter.println(string2);
                    break;
                }
                printWriter.println("rsh " + generationInfo.host + " cd " + string4 + "; " + string2);
            }
        }
    }
}

