/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import zeus.generator.code.GenerationInfo;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class NameserverInfo
extends GenerationInfo {
    protected static int count = 0;
    static final String DEFAULT_DNS = SystemProps.getProperty("nameserver.dns.default");
    static final String DEFAULT_PERIOD = SystemProps.getProperty("nameserver.period.default");
    public boolean is_root;
    public boolean has_gui;
    public String zeus_external = null;
    public String address_output_file;
    public String time_grain;
    public String dns_file;

    public NameserverInfo() {
        this(NAMESERVER + count++);
    }

    public NameserverInfo(String string) {
        this.name = string;
        this.is_root = count == 1;
        this.has_gui = false;
        this.zeus_external = null;
        if (this.is_root) {
            this.address_output_file = DEFAULT_DNS;
            this.time_grain = DEFAULT_PERIOD;
            this.dns_file = null;
        } else {
            this.address_output_file = null;
            this.time_grain = null;
            this.dns_file = DEFAULT_DNS;
        }
    }

    public NameserverInfo(String string, boolean bl) {
        this.name = string;
        this.is_root = bl;
        this.has_gui = false;
        this.zeus_external = null;
        if (bl) {
            this.address_output_file = DEFAULT_DNS;
            this.time_grain = DEFAULT_PERIOD;
            this.dns_file = null;
        } else {
            this.address_output_file = null;
            this.time_grain = null;
            this.dns_file = DEFAULT_DNS;
        }
    }

    public String[] summarize() {
        String[] stringArray = new String[4];
        stringArray[0] = this.name;
        stringArray[1] = NAMESERVER;
        stringArray[3] = this.id;
        stringArray[2] = "zeus.agents.ANServer " + this.name;
        if (this.dns_file != null) {
            stringArray[2] = stringArray[2] + " -s " + this.dns_file;
        }
        if (this.is_root) {
            stringArray[2] = stringArray[2] + " -t " + this.time_grain;
        }
        if (this.address_output_file != null) {
            stringArray[2] = stringArray[2] + " -f " + this.address_output_file;
        }
        if (this.has_gui) {
            stringArray[2] = stringArray[2] + " -gui zeus.agentviewer.BasicViewer";
        }
        if (this.zeus_external != null) {
            stringArray[2] = stringArray[2] + " -e " + this.zeus_external;
        }
        return stringArray;
    }

    public String isValid() {
        String string = null;
        if (!this.is_root && this.dns_file == null) {
            string = "Nameserver " + this.name + ": (not root) and domain nameserver file not specified\n";
        }
        return string;
    }

    public String toString() {
        String string = "";
        string = string + "(:name " + this.name;
        string = string + " :is_root " + this.is_root;
        string = string + " :has_gui " + this.has_gui;
        if (this.host != null && !this.host.equals(LOCALHOST)) {
            string = string + " :host \"" + Misc.escape(this.host) + "\"";
        }
        if (this.zeus_external != null) {
            string = string + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"";
        }
        if (this.dns_file != null) {
            string = string + " :dns_file \"" + Misc.escape(this.dns_file) + "\"";
        }
        if (this.address_output_file != null) {
            string = string + " :address_output_file \"" + Misc.escape(this.address_output_file) + "\"";
        }
        if (this.time_grain != null) {
            string = string + " :time_grain " + this.time_grain;
        }
        string = string + ")";
        return string;
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string;
        String string3 = string;
        string3 = string3 + "(:name " + this.name + string2;
        string3 = string3 + " :is_root " + this.is_root + string2;
        string3 = string3 + " :has_gui " + this.has_gui + string2;
        if (this.host != null && !this.host.equals(LOCALHOST)) {
            string3 = string3 + " :host \"" + Misc.escape(this.host) + "\"" + string2;
        }
        if (this.zeus_external != null) {
            string3 = string3 + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"" + string2;
        }
        if (this.dns_file != null) {
            string3 = string3 + " :dns_file \"" + Misc.escape(this.dns_file) + "\"" + string2;
        }
        if (this.address_output_file != null) {
            string3 = string3 + " :address_output_file \"" + Misc.escape(this.address_output_file) + "\"" + string2;
        }
        if (this.time_grain != null) {
            string3 = string3 + " :time_grain " + this.time_grain + string2;
        }
        string3 = string3 + ")";
        return string3;
    }
}

