/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import zeus.generator.code.GenerationInfo;
import zeus.generator.code.NameserverInfo;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class FacilitatorInfo
extends GenerationInfo {
    protected static int count = 0;
    static final String DEFAULT_PERIOD = SystemProps.getProperty("facilitator.period.default");
    public boolean has_gui = false;
    public String zeus_external = null;
    public String period = DEFAULT_PERIOD;
    public String dns_file = NameserverInfo.DEFAULT_DNS;
    public String ontology_file = null;

    public FacilitatorInfo(String string) {
        this.name = FACILITATOR + count++;
        this.ontology_file = string;
    }

    public FacilitatorInfo(String string, String string2) {
        this.name = string;
        this.ontology_file = string2;
    }

    public String[] summarize() {
        String[] stringArray = new String[4];
        stringArray[0] = this.name;
        stringArray[1] = FACILITATOR;
        stringArray[3] = this.id;
        stringArray[2] = "zeus.agents.Facilitator " + this.name + " -o " + this.ontology_file + " -s " + this.dns_file + " -t " + this.period;
        if (this.has_gui) {
            stringArray[2] = stringArray[2] + " -gui zeus.agentviewer.BasicViewer";
        }
        if (this.zeus_external != null) {
            stringArray[2] = stringArray[2] + " -e " + this.zeus_external;
        }
        return stringArray;
    }

    public String isValid() {
        String string = null;
        if (this.dns_file == null) {
            string = "Facilitator " + this.name + ": domain nameserver file not specified\n";
        }
        return string;
    }

    public String toString() {
        double d = Double.valueOf(this.period);
        String string = Misc.decimalPlaces(d, 2);
        String string2 = "";
        string2 = string2 + "(:name " + this.name;
        string2 = string2 + " :period " + string;
        string2 = string2 + " :has_gui " + this.has_gui;
        if (this.host != null && !this.host.equals(LOCALHOST)) {
            string2 = string2 + " :host \"" + Misc.escape(this.host) + "\"";
        }
        if (this.zeus_external != null) {
            string2 = string2 + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"";
        }
        if (this.dns_file != null) {
            string2 = string2 + " :dns_file \"" + Misc.escape(this.dns_file) + "\"";
        }
        string2 = string2 + ")";
        return string2;
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string;
        double d = Double.valueOf(this.period);
        String string3 = Misc.decimalPlaces(d, 2);
        String string4 = string;
        string4 = string4 + "(:name " + this.name + string2;
        string4 = string4 + " :period " + string3 + string2;
        string4 = string4 + " :has_gui " + this.has_gui + string2;
        if (this.host != null && !this.host.equals(LOCALHOST)) {
            string4 = string4 + " :host \"" + Misc.escape(this.host) + "\"" + string2;
        }
        if (this.zeus_external != null) {
            string4 = string4 + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"" + string2;
        }
        if (this.dns_file != null) {
            string4 = string4 + " :dns_file \"" + Misc.escape(this.dns_file) + "\"" + string2;
        }
        string4 = string4 + ")";
        return string4;
    }
}

