/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextArea;
import zeus.concepts.AbilityDbItem;
import zeus.concepts.AbilitySpec;
import zeus.concepts.AbstractTask;
import zeus.concepts.Acquaintance;
import zeus.concepts.AgentDescription;
import zeus.concepts.Fact;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.Relationship;
import zeus.concepts.Restriction;
import zeus.concepts.StrategyInfo;
import zeus.concepts.SummaryTask;
import zeus.generator.GeneratorModel;
import zeus.generator.code.AgentInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.Writer;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class AgentWriter
extends Writer {
    public AgentWriter(GenerationPlan generationPlan, GeneratorModel generatorModel, String string, JTextArea jTextArea) {
        super(generationPlan, generatorModel, string, jTextArea);
    }

    private boolean hasTasks(AgentDescription agentDescription) {
        String[] stringArray = agentDescription.getTasks();
        if (stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            AbstractTask abstractTask = this.genmodel.getTask(stringArray[i]);
            switch (abstractTask.getType()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasRules(AgentDescription agentDescription) {
        String[] stringArray = agentDescription.getTasks();
        if (stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            AbstractTask abstractTask = this.genmodel.getTask(stringArray[i]);
            switch (abstractTask.getType()) {
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    public void write() {
        String[] stringArray;
        PrintWriter printWriter;
        Object object;
        AgentInfo[] agentInfoArray = this.genplan.getSelectedAgents();
        if (agentInfoArray.length == 0) {
            return;
        }
        this.textArea.append("\n*** Agent code generation started ***\n\n");
        for (int i = 0; i < agentInfoArray.length; ++i) {
            object = this.genmodel.getAgent(agentInfoArray[i].id);
            String string = this.genmodel.getAgentName(agentInfoArray[i].id);
            this.textArea.append("Generating code for agent " + string + "\n");
            try {
                Object object2;
                List list;
                Object object3;
                Object[] objectArray;
                printWriter = this.createFile(string + ".java");
                printWriter.println("/*\n\tThis software was produced as a part of research\n\tactivities. It is not intended to be used as commercial\n\tor industrial software by any organisation. Except as\n\texplicitly stated, no guarantees are given as to its\n\treliability or trustworthiness if used for purposes other\n\tthan those for which it was originally intended.\n \n\t(c) British Telecommunications plc 1999.\n*/\n");
                printWriter.println("/*");
                printWriter.println("This code was automatically generated by ZeusAgentGenerator version " + SystemProps.getProperty("version.id"));
                printWriter.println("                           DO NOT MODIFY!!");
                printWriter.println("*/\n");
                printWriter.println("import java.util.*;");
                printWriter.println("import java.io.*;");
                printWriter.println("import zeus.util.*;");
                printWriter.println("import zeus.concepts.*;");
                printWriter.println("import zeus.actors.*;");
                printWriter.println("import zeus.agents.*;");
                printWriter.println();
                printWriter.println("public class " + string + " {");
                printWriter.println("   protected static void version() {");
                printWriter.println("      System.err.println(\"ZeusAgent - " + string + " version: " + SystemProps.getProperty("version.id") + "\");");
                printWriter.println("      System.exit(0);");
                printWriter.println("   }");
                printWriter.println();
                printWriter.println("   protected static void usage() {");
                printWriter.println("      System.err.println(\"Usage: java " + string + " -s <dns_file> -o <ontology_file> " + "[-gui ViewerProg] [-e <ExternalProg>] " + "[-r ResourceProg] [-name <AgentName>] [-debug] [-h] [-v]\");");
                printWriter.println("      System.exit(0);");
                printWriter.println("   }");
                printWriter.println();
                printWriter.println("   public static void main(String[] arg) {");
                printWriter.println("   try { ");
                printWriter.println("      ZeusAgent agent;");
                printWriter.println("      String external = null;");
                printWriter.println("      String dns_file = null;");
                printWriter.println("      String resource = null;");
                printWriter.println("      String gui = null;");
                printWriter.println("      String ontology_file = null;");
                printWriter.println("      Vector nameservers = null;");
                printWriter.println("      String name = new String (\"" + string + "\");");
                printWriter.println("      Bindings b = new Bindings(\"" + string + "\");");
                printWriter.println("      FileInputStream stream = null;");
                printWriter.println("      ZeusExternal user_prog = null;");
                printWriter.println();
                printWriter.println();
                printWriter.println("      for( int j = 0; j < arg.length; j++ ) {");
                printWriter.println("         if ( arg[j].equals(\"-s\") &&  ++j < arg.length )");
                printWriter.println("            dns_file = arg[j];");
                printWriter.println("         else if ( arg[j].equals(\"-e\") &&  ++j < arg.length )");
                printWriter.println("            external = arg[j];");
                printWriter.println("         else if ( arg[j].equals(\"-r\") &&  ++j < arg.length )");
                printWriter.println("            resource = arg[j];");
                printWriter.println("         else if ( arg[j].equals(\"-o\") &&  ++j < arg.length )");
                printWriter.println("            ontology_file = arg[j];");
                printWriter.println("         else if ( arg[j].equals(\"-gui\") &&  ++j < arg.length )");
                printWriter.println("            gui = arg[j];");
                printWriter.println("         else if ( arg[j].equals(\"-debug\") ) {");
                printWriter.println("            Core.debug = true;");
                printWriter.println("            Core.setDebuggerOutputFile(\"" + string + ".log" + "\");");
                printWriter.println("         }");
                printWriter.println("         else if ( arg[j].equals(\"-v\") )");
                printWriter.println("            version();");
                printWriter.println("         else if ( arg[j].equals(\"-name\")  && ++j < arg.length )");
                printWriter.println("             name = name  + arg[j];");
                printWriter.println("         else if ( arg[j].equals(\"-h\") )");
                printWriter.println("            usage();");
                printWriter.println("         else");
                printWriter.println("            usage();");
                printWriter.println("      }");
                printWriter.println();
                printWriter.println("       b = new Bindings(name);");
                printWriter.println("      if ( ontology_file == null ) {");
                printWriter.println("         System.err.println(\"Ontology Database file must be specified with -o option\");");
                printWriter.println("         usage();");
                printWriter.println("      }");
                printWriter.println("      if ( dns_file == null ) {");
                printWriter.println("         System.err.println(\"Domain nameserver file must be specified with -s option\");");
                printWriter.println("         usage();");
                printWriter.println("      }");
                printWriter.println();
                printWriter.println("         nameservers = ZeusParser.addressList(new FileInputStream(dns_file));");
                printWriter.println("         if ( nameservers == null || nameservers.isEmpty() ) ");
                printWriter.println("            throw new IOException();");
                printWriter.println();
                printWriter.println("         agent = new ZeusAgent(name,ontology_file,nameservers," + ((AgentDescription)object).getPlannerWidth() + "," + ((AgentDescription)object).getPlannerLength() + "," + this.hasTasks((AgentDescription)object) + "," + this.hasRules((AgentDescription)object) + ");");
                printWriter.println();
                printWriter.println("         AgentContext context = agent.getAgentContext();");
                printWriter.println("         OntologyDb db = context.OntologyDb();");
                printWriter.println();
                printWriter.println();
                printWriter.println("/*\n         Initialising Extensions\n*/");
                printWriter.println("         Class c;");
                printWriter.println();
                printWriter.println("         if ( resource != null ) {");
                printWriter.println("            c = Class.forName(resource);");
                printWriter.println("            ExternalDb oracle = (ExternalDb) c.newInstance();");
                printWriter.println("            context.set(oracle);");
                printWriter.println("            oracle.set(context);");
                printWriter.println("         }");
                printWriter.println("         if ( gui != null ) {");
                printWriter.println("            c = Class.forName(gui);");
                printWriter.println("            ZeusAgentUI ui = (ZeusAgentUI)c.newInstance();");
                printWriter.println("            context.set(ui);");
                printWriter.println("            ui.set(context);");
                printWriter.println("         }");
                printWriter.println();
                ProtocolInfo[] protocolInfoArray = ((AgentDescription)object).getProtocols();
                printWriter.println("/*\n         Initialising ProtocolDb\n*/");
                printWriter.println("         ProtocolInfo info;");
                for (int j = 0; j < protocolInfoArray.length; ++j) {
                    objectArray = protocolInfoArray[j].getConstraints();
                    for (int k = 0; k < objectArray.length; ++k) {
                        object3 = ((StrategyInfo)objectArray[k]).getAgents();
                        list = new Vector<String>();
                        for (int i2 = 0; i2 < ((String[])object3).length; ++i2) {
                            object2 = this.genmodel.getAgentName(object3[i2]);
                            if (object2 == null) {
                                this.textArea.append("Warning: agent " + string + " refers to an undefined agent\n");
                                continue;
                            }
                            ((Vector)list).addElement(object2);
                        }
                        object3 = Misc.stringArray(list);
                        ((StrategyInfo)objectArray[k]).setAgents((String[])object3);
                    }
                    protocolInfoArray[j].setConstraints((StrategyInfo[])objectArray);
                    printWriter.println("         info = ZeusParser.protocolInfo(db,\"" + Misc.escape(protocolInfoArray[j].toString()) + "\");");
                    printWriter.println("         if ( info.resolve(b) )");
                    printWriter.println("            agent.addProtocol(info);");
                }
                printWriter.println();
                stringArray = ((AgentDescription)object).getTasks();
                if (stringArray.length != 0) {
                    printWriter.println("/*\n         Initialising TaskDb\n*/");
                    printWriter.println("         AbstractTask t;");
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string2 = this.genmodel.getTaskName(stringArray[j]);
                        if (string2 == null) {
                            this.textArea.append("Warning: agent " + string + " refers to an undefined task\n");
                            continue;
                        }
                        object3 = this.genmodel.getTask(stringArray[j]);
                        switch (((AbstractTask)object3).getType()) {
                            case 0: {
                                object3 = new PrimitiveTask((PrimitiveTask)object3);
                                ((AbstractTask)object3).setName(string2);
                                printWriter.println("         t = ZeusParser.primitiveTask(db,\"" + Misc.escape(object3.toString()) + "\");");
                                break;
                            }
                            case 1: {
                                object3 = new SummaryTask((SummaryTask)object3);
                                ((AbstractTask)object3).setName(string2);
                                printWriter.println("         t = ZeusParser.summaryTask(db,\"" + Misc.escape(object3.toString()) + "\");");
                                break;
                            }
                            case 2: {
                                printWriter.println("         stream = new FileInputStream(\"" + string2 + ".clp" + "\");");
                                printWriter.println("         t = ZeusParser.reteKB(db,stream);");
                                printWriter.println("         stream.close();");
                                break;
                            }
                            case 3: {
                                ((AbstractTask)object3).setName(string2);
                                printWriter.println("         t = ZeusParser.script(db,\"" + Misc.escape(object3.toString()) + "\");");
                                break;
                            }
                            default: {
                                Core.ERROR(null, 1, (Object)this);
                            }
                        }
                        printWriter.println("         if ( t.resolve(b) )");
                        printWriter.println("            agent.addTask(t);");
                        list = ((AgentDescription)object).getRestrictions();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            object2 = (Restriction)iterator.next();
                            if (!((Restriction)object2).getTaskName().equals(string2)) continue;
                            printWriter.println("         t.addRestriction(\"" + ((Restriction)object2).getFactName() + "\", \"" + ((Restriction)object2).getAttributeName() + "\", \"" + ((Restriction)object2).getRestriction() + "\");");
                        }
                    }
                }
                objectArray = ((AgentDescription)object).getAcquaintances();
                printWriter.println("/*\n         Initialising OrganisationalDb\n*/");
                printWriter.println("         AbilityDbItem item;");
                for (int j = 0; j < objectArray.length; ++j) {
                    object3 = this.genmodel.getAgentName(((Relationship)objectArray[j]).getName());
                    if (object3 == null) {
                        this.textArea.append("Warning: agent " + string + " refers to an undefined acquaintance\n");
                    } else {
                        printWriter.println("         agent.addRelation(\"" + (String)object3 + "\",\"" + ((Relationship)objectArray[j]).getRelation() + "\");");
                        list = ((Acquaintance)objectArray[j]).getAbilities();
                        for (int k = 0; k < ((List<E>)list).length; ++k) {
                            AbilityDbItem abilityDbItem = new AbilityDbItem((String)object3, (AbilitySpec)((Object)list[k]));
                            printWriter.println("         item = ZeusParser.abilityDbItem(db,\"" + Misc.escape(abilityDbItem.toString()) + "\");");
                            printWriter.println("         if ( item.resolve(b) )");
                            printWriter.println("            agent.addAbility(item);");
                        }
                    }
                    printWriter.println();
                }
                Fact[] factArray = ((AgentDescription)object).getInitialFacts();
                printWriter.println("/*\n         Initialising ResourceDb\n*/");
                printWriter.println("         Fact f1;");
                for (int j = 0; j < factArray.length; ++j) {
                    if (!factArray[j].isDeterminate()) {
                        this.textArea.append("Warning: " + factArray[j].getId() + " is not grounded");
                    }
                    printWriter.println("         f1 = ZeusParser.fact(db,\"" + Misc.escape(factArray[j].toString()) + "\");");
                    printWriter.println("         if ( f1.resolve(b) )");
                    printWriter.println("            agent.addFact(f1);");
                }
                printWriter.println();
                printWriter.println();
                printWriter.println("/*\n         Initialising External User Program\n*/");
                printWriter.println();
                printWriter.println("         if ( external != null ) {");
                printWriter.println("            c = Class.forName(external);");
                printWriter.println("            user_prog = (ZeusExternal) c.newInstance();");
                printWriter.println("            context.set(user_prog);");
                printWriter.println("         }");
                printWriter.println();
                if (this.hasRules((AgentDescription)object)) {
                    printWriter.println("/*\n         Activating Rete Engine\n*/");
                    printWriter.println("         context.ReteEngine().run();");
                }
                printWriter.println();
                printWriter.println("/*\n         Activating External User Program\n*/");
                printWriter.println();
                printWriter.println("         if ( user_prog != null )");
                printWriter.println("            user_prog.exec(context);");
                printWriter.println();
                printWriter.println("      }");
                printWriter.println(" catch (ClassNotFoundException cnfe) { ");
                printWriter.print("     System.out.println(\"Java cannot find some of the classes that ");
                printWriter.print("are needed to run this agent. Please ensure that you have the following");
                printWriter.print("in your classpath : zeus_install_dir\\\\lib\\\\zeus.jar, ");
                printWriter.print("zeus_install_dir\\\\lib\\\\gnu-regexp.jar, ");
                printWriter.print("java_install_dir\\\\jre\\\\rt.jar ");
                printWriter.print(" Where zeus_install_dir is the directory that you have installed ");
                printWriter.print(" Zeus in , and java_install_dir is the directory that you have ");
                printWriter.println(" installed Java in\");");
                printWriter.println("   cnfe.printStackTrace();}");
                printWriter.println("      catch(Exception e) {");
                printWriter.println("         e.printStackTrace();");
                printWriter.println("      }");
                printWriter.println("   }");
                printWriter.println("}");
                printWriter.flush();
                printWriter.close();
                agentInfoArray[i].status = "Saved";
                agentInfoArray[i].generate = false;
                continue;
            }
            catch (IOException iOException) {
                this.textArea.append("Error generating agent " + string);
            }
        }
        this.textArea.append("Generating " + SystemProps.getProperty("application.gif") + " file\n");
        try {
            printWriter = this.createFile(SystemProps.getProperty("application.gif"));
            char c = File.separatorChar;
            char c2 = SystemProps.getProperty("file.separator").charAt(0);
            stringArray = this.genmodel.getAgentIds();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.genmodel.getAgentName(stringArray[i]);
                object = this.genmodel.getAgentIcon(stringArray[i]);
                object = Misc.relativePath(this.directory, (String)object);
                object = ((String)object).replace(c, c2);
                printWriter.println(string + " = " + Misc.escape((String)object));
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.textArea.append("Error generating " + SystemProps.getProperty("application.gif") + " file\n");
        }
        this.textArea.append("\n*** Agent Code generation completed ***\n");
    }
}

