/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import zeus.generator.code.GenerationInfo;
import zeus.generator.code.NameserverInfo;
import zeus.util.Misc;

public class AgentInfo
extends GenerationInfo {
    public boolean generate = true;
    public String status = "Modified";
    public String database = null;
    public boolean has_gui = false;
    public String zeus_external = null;
    public String icon_file = null;
    public String dns_file = NameserverInfo.DEFAULT_DNS;
    public String ontology_file = null;

    public AgentInfo(String string, String string2, String string3) {
        super(string);
        this.name = string2;
        this.ontology_file = string3;
    }

    public String[] summarize() {
        String[] stringArray = new String[4];
        stringArray[0] = this.name;
        stringArray[1] = AGENT;
        stringArray[3] = this.id;
        stringArray[2] = this.name + " -o " + this.ontology_file + " -s " + this.dns_file;
        if (this.has_gui) {
            stringArray[2] = stringArray[2] + " -gui zeus.agentviewer.AgentViewer";
        }
        if (this.zeus_external != null) {
            stringArray[2] = stringArray[2] + " -e " + this.zeus_external;
        }
        if (this.database != null) {
            stringArray[2] = stringArray[2] + " -r " + this.database;
        }
        return stringArray;
    }

    public String isValid() {
        String string = null;
        if (this.dns_file == null) {
            string = "Agent " + this.name + ": domain nameserver file not specified\n";
        }
        return string;
    }

    public String toString() {
        String string = "";
        string = string + "(:id " + this.id;
        string = string + " :generate " + this.generate;
        string = string + " :status " + this.status;
        string = string + " :has_gui " + this.has_gui;
        if (this.host != null && !this.host.equals(LOCALHOST)) {
            string = string + " :host \"" + Misc.escape(this.host) + "\"";
        }
        if (this.database != null) {
            string = string + " :database \"" + Misc.escape(this.database) + "\"";
        }
        if (this.zeus_external != null) {
            string = string + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"";
        }
        if (this.dns_file != null) {
            string = string + " :dns_file \"" + Misc.escape(this.dns_file) + "\"";
        }
        string = string + ")";
        return string;
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string;
        String string3 = string;
        string3 = string3 + "(:id " + this.id + string2;
        string3 = string3 + " :generate " + this.generate + string2;
        string3 = string3 + " :status " + this.status + string2;
        string3 = string3 + " :has_gui " + this.has_gui + string2;
        if (this.host != null && !this.host.equals(LOCALHOST)) {
            string3 = string3 + " :host \"" + Misc.escape(this.host) + "\"" + string2;
        }
        if (this.database != null) {
            string3 = string3 + " :database \"" + Misc.escape(this.database) + "\"" + string2;
        }
        if (this.zeus_external != null) {
            string3 = string3 + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"" + string2;
        }
        if (this.dns_file != null) {
            string3 = string3 + " :dns_file \"" + Misc.escape(this.dns_file) + "\"" + string2;
        }
        string3 = string3 + ")";
        return string3;
    }
}

