/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.concepts.AbstractTask;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AgentEditor;
import zeus.generator.agent.TaskModel;
import zeus.gui.fields.NameField;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class TaskPanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected JTable table;
    protected TaskModel model;
    protected HelpWindow helpWin;
    protected AgentEditor editor;
    protected TaskToolBar toolbar;
    protected GeneratorModel genmodel;
    protected AgentGenerator generator;

    public TaskPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, AgentEditor agentEditor, String[] stringArray, String string) {
        this.editor = agentEditor;
        this.genmodel = generatorModel;
        this.generator = agentGenerator;
        this.model = new TaskModel(stringArray, generatorModel);
        this.model.addChangeListener(agentEditor);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.toolbar = new TaskToolBar();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        this.setBorder(titledBorder);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setMinimumSize(new Dimension(160, 80));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.table.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(this.toolbar, gridBagConstraints);
        this.add(this.toolbar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    public String[] getData() {
        return this.model.getData();
    }

    protected String getSelectedTaskId() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.model.getValueAt(n, 2);
    }

    class TaskToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton newBtn;
        protected JButton editBtn;
        protected JButton deleteBtn;
        protected JToggleButton helpBtn;
        protected HelpWindow helpWin;
        protected JPopupMenu popup;
        protected JMenu primitiveMenu;
        protected JMenu summaryMenu;
        protected JMenu behaviourMenu;
        protected JMenu scriptMenu;
        protected JMenuItem primitiveMenuItem;
        protected JMenuItem summaryMenuItem;
        protected JMenuItem behaviourMenuItem;
        protected JMenuItem scriptMenuItem;

        public TaskToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("Create New Task");
            this.newBtn.addActionListener(this);
            this.editBtn = new JButton(new ImageIcon(string2 + "edit1.gif"));
            this.editBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.editBtn);
            this.editBtn.setToolTipText("Edit this Task");
            this.editBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete this Task");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.popup = new JPopupMenu();
            this.popup.add(new JLabel("Tasks"));
            this.popup.addSeparator();
            String string3 = AbstractTask.getTypeName(0);
            this.primitiveMenu = new JMenu(string3, false);
            this.primitiveMenuItem = new JMenuItem("New " + string3 + " task");
            this.primitiveMenuItem.addActionListener(this);
            string3 = AbstractTask.getTypeName(1);
            this.summaryMenu = new JMenu(string3, false);
            this.summaryMenuItem = new JMenuItem("New " + string3 + " task");
            this.summaryMenuItem.addActionListener(this);
            string3 = AbstractTask.getTypeName(2);
            this.behaviourMenu = new JMenu(string3, false);
            this.behaviourMenuItem = new JMenuItem("New " + string3);
            this.behaviourMenuItem.addActionListener(this);
            string3 = AbstractTask.getTypeName(3);
            this.scriptMenu = new JMenu(string3, false);
            this.scriptMenuItem = new JMenuItem("New " + string3);
            this.scriptMenuItem.addActionListener(this);
            this.popup.add(this.primitiveMenu);
            this.popup.add(this.summaryMenu);
            this.popup.add(this.behaviourMenu);
            this.popup.add(this.scriptMenu);
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
            this.popup.setBorder(compoundBorder);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = AbstractTask.getTypeName(0);
            String string2 = AbstractTask.getTypeName(1);
            String string3 = AbstractTask.getTypeName(2);
            String string4 = AbstractTask.getTypeName(3);
            if (object == this.newBtn) {
                JMenuItem jMenuItem;
                int n;
                String[] stringArray = TaskPanel.this.model.getData();
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement(TaskPanel.this.genmodel.getTaskName(stringArray[i]));
                }
                this.primitiveMenu.removeAll();
                this.primitiveMenu.add(this.primitiveMenuItem);
                this.primitiveMenu.addSeparator();
                String[] stringArray2 = TaskPanel.this.genmodel.getTaskNames(0);
                Vector vector2 = Misc.stringVector(stringArray2);
                Vector vector3 = Misc.difference(vector2, vector);
                for (n = 0; n < vector3.size(); ++n) {
                    jMenuItem = new JMenuItem((String)vector3.elementAt(n));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setActionCommand(string);
                    this.primitiveMenu.add(jMenuItem);
                }
                this.summaryMenu.removeAll();
                this.summaryMenu.add(this.summaryMenuItem);
                this.summaryMenu.addSeparator();
                stringArray2 = TaskPanel.this.genmodel.getTaskNames(1);
                vector2 = Misc.stringVector(stringArray2);
                vector3 = Misc.difference(vector2, vector);
                for (n = 0; n < vector3.size(); ++n) {
                    jMenuItem = new JMenuItem((String)vector3.elementAt(n));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setActionCommand(string2);
                    this.summaryMenu.add(jMenuItem);
                }
                this.behaviourMenu.removeAll();
                this.behaviourMenu.add(this.behaviourMenuItem);
                this.behaviourMenu.addSeparator();
                stringArray2 = TaskPanel.this.genmodel.getTaskNames(2);
                vector2 = Misc.stringVector(stringArray2);
                vector3 = Misc.difference(vector2, vector);
                for (n = 0; n < vector3.size(); ++n) {
                    jMenuItem = new JMenuItem((String)vector3.elementAt(n));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setActionCommand(string3);
                    this.behaviourMenu.add(jMenuItem);
                }
                this.scriptMenu.removeAll();
                this.scriptMenu.add(this.scriptMenuItem);
                this.scriptMenu.addSeparator();
                stringArray2 = TaskPanel.this.genmodel.getTaskNames(3);
                vector2 = Misc.stringVector(stringArray2);
                vector3 = Misc.difference(vector2, vector);
                for (n = 0; n < vector3.size(); ++n) {
                    jMenuItem = new JMenuItem((String)vector3.elementAt(n));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setActionCommand(string4);
                    this.scriptMenu.add(jMenuItem);
                }
                this.popup.pack();
                this.popup.show(this.newBtn, 0, 0);
            } else if (object == this.primitiveMenuItem) {
                TaskPanel.this.model.addNewRow(string);
            } else if (object == this.summaryMenuItem) {
                TaskPanel.this.model.addNewRow(string2);
            } else if (object == this.behaviourMenuItem) {
                TaskPanel.this.model.addNewRow(string3);
            } else if (object == this.scriptMenuItem) {
                TaskPanel.this.model.addNewRow(string4);
            } else if (actionEvent.getActionCommand().equals(string)) {
                TaskPanel.this.model.addNewRow(string, ((JMenuItem)object).getText());
            } else if (actionEvent.getActionCommand().equals(string2)) {
                TaskPanel.this.model.addNewRow(string2, ((JMenuItem)object).getText());
            } else if (actionEvent.getActionCommand().equals(string3)) {
                TaskPanel.this.model.addNewRow(string3, ((JMenuItem)object).getText());
            } else if (actionEvent.getActionCommand().equals(string4)) {
                TaskPanel.this.model.addNewRow(string4, ((JMenuItem)object).getText());
            } else if (object == this.editBtn) {
                String string5 = TaskPanel.this.getSelectedTaskId();
                if (string5 == null) {
                    return;
                }
                TaskPanel.this.generator.editTask(string5);
            } else if (object == this.deleteBtn) {
                int n = TaskPanel.this.table.getSelectedRow();
                if (n == -1) {
                    TaskPanel.this.errorMsg(0);
                    return;
                }
                TaskPanel.this.model.removeRow(n);
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Task Declaration");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

