/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import zeus.concepts.AgentDescription;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AgentEditor;
import zeus.generator.agent.TaskAttributeListener;
import zeus.generator.agent.TaskModel;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.FactModel;
import zeus.generator.util.FactPanel;

public class TaskAttributePanel
extends JPanel {
    private List restrictions;

    public TaskAttributePanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, AgentEditor agentEditor, AgentDescription agentDescription, boolean bl, OntologyDb ontologyDb, String string) {
        this.init(agentGenerator, generatorModel, agentEditor, agentDescription, bl, ontologyDb, string);
    }

    private void init(AgentGenerator agentGenerator, GeneratorModel generatorModel, AgentEditor agentEditor, AgentDescription agentDescription, boolean bl, OntologyDb ontologyDb, String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.makeBorder(string);
        String[] stringArray = agentDescription.getTasks();
        TaskModel taskModel = new TaskModel(stringArray, generatorModel);
        taskModel.addChangeListener(agentEditor);
        taskModel.setReadOnly(0);
        JTable jTable = this.makeTaskTable(taskModel);
        this.configureTable(jTable);
        FactModel factModel = new FactModel(ontologyDb, new AttributeModel(), bl, 0, new Fact[0]);
        factModel.setEditable(false);
        FactPanel.FactInstanceEditor factInstanceEditor = new FactPanel(ontologyDb, agentEditor, new Fact[0], bl, string).newInstanceEditor();
        JTable jTable2 = this.makeFactTable(factModel, factInstanceEditor);
        this.configureTable(jTable2);
        AttributeModel attributeModel = factModel.getAttributeModel();
        attributeModel.enableRestrictions();
        attributeModel.setWriteable(2);
        attributeModel.setReadOnly(1);
        JTable jTable3 = this.makeAttributeTable(attributeModel);
        this.configureTable(jTable3);
        this.makeScrollPane(jTable, gridBagLayout);
        this.makeScrollPane(jTable2, gridBagLayout);
        this.makeScrollPane(jTable3, gridBagLayout);
        this.setupListeners(jTable, taskModel, jTable2, factModel, jTable3, attributeModel, generatorModel, agentDescription);
        attributeModel.addChangeListener(agentEditor);
    }

    private void makeScrollPane(JTable jTable, GridBagLayout gridBagLayout) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setMinimumSize(new Dimension(160, 80));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    private void setupListeners(JTable jTable, TaskModel taskModel, JTable jTable2, FactModel factModel, JTable jTable3, AttributeModel attributeModel, GeneratorModel generatorModel, AgentDescription agentDescription) {
        TaskAttributeListener taskAttributeListener = new TaskAttributeListener(jTable, taskModel, jTable2, factModel, jTable3, attributeModel, generatorModel, agentDescription);
        jTable.getSelectionModel().addListSelectionListener(taskAttributeListener);
        jTable2.getSelectionModel().addListSelectionListener(taskAttributeListener);
        jTable3.getSelectionModel().addListSelectionListener(taskAttributeListener);
        this.restrictions = taskAttributeListener.getRestrictions();
    }

    private void configureTable(JTable jTable) {
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.getSelectionModel().setSelectionMode(0);
    }

    private void makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        this.setBorder(titledBorder);
    }

    private JTable makeTaskTable(TaskModel taskModel) {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(taskModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(taskModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        JTable jTable = new JTable(taskModel, defaultTableColumnModel);
        return jTable;
    }

    private JTable makeFactTable(FactModel factModel, TableCellEditor tableCellEditor) {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(factModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(factModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        JTable jTable = new JTable(factModel, defaultTableColumnModel);
        return jTable;
    }

    private JTable makeAttributeTable(AttributeModel attributeModel) {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(attributeModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(attributeModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 12);
        tableColumn.setHeaderValue(attributeModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        JTable jTable = new JTable(attributeModel, defaultTableColumnModel);
        return jTable;
    }

    public List getRestrictions() {
        return this.restrictions;
    }
}

