/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.StrategyInfo;
import zeus.generator.GeneratorModel;
import zeus.generator.util.AttributeModel;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.SystemProps;

public class StrategyModel
extends AbstractTableModel
implements ChangeListener {
    static final int MODE = 0;
    static final int TYPE = 1;
    static final int AGENTS = 2;
    static final int RELATIONS = 3;
    static final int STRATEGY = 4;
    static final int PARAMETERS = 5;
    static final int FACT = 6;
    static final int USE = 0;
    static final int NO_USE = 1;
    static final String[] ALL = new String[0];
    static int count = 0;
    static Vector INITIATOR_STRATEGY_LIST = null;
    static Vector RESPONDENT_STRATEGY_LIST = null;
    protected EventListenerList changeListeners = new EventListenerList();
    protected String[] columnNames = new String[]{"Mode", "Fact Type", "Agents", "Relations", "Strategy", "Parameters"};
    protected Vector data = new Vector();
    protected int selectedRow = -1;
    protected AttributeModel attributeModel;
    protected OntologyDb ontologyDb;
    protected ProtocolInfo protocol;
    protected GeneratorModel genmodel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public StrategyModel(GeneratorModel generatorModel, OntologyDb ontologyDb, AttributeModel attributeModel) {
        this.genmodel = generatorModel;
        this.ontologyDb = ontologyDb;
        this.attributeModel = attributeModel;
        ontologyDb.addChangeListener(this);
        generatorModel.addChangeListener(this);
    }

    public void reset(ProtocolInfo protocolInfo) {
        this.selectRow(-1);
        if (this.protocol != null) {
            this.protocol.setConstraints(this.data);
        }
        int n = this.data.size();
        this.data.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        this.protocol = protocolInfo;
        if (this.protocol != null) {
            StrategyInfo[] strategyInfoArray = this.protocol.getConstraints();
            for (int i = 0; i < strategyInfoArray.length; ++i) {
                this.data.addElement(strategyInfoArray[i]);
            }
            this.fireTableRowsInserted(0, strategyInfoArray.length - 1);
        }
        this.fireTableStructureChanged();
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.data.removeElementAt(nArray[i] - i);
            this.fireTableRowsDeleted(nArray[i] - i, nArray[i] - i);
        }
        this.selectRow(-1);
        this.fireChanged();
    }

    public void selectRow(int n) {
        if (this.selectedRow == n) {
            return;
        }
        this.selectedRow = n;
        if (this.attributeModel != null) {
            if (this.selectedRow >= 0) {
                StrategyInfo strategyInfo = (StrategyInfo)this.data.elementAt(this.selectedRow);
                this.attributeModel.reset(strategyInfo.getFact());
            } else {
                this.attributeModel.reset(null);
            }
        }
    }

    public void addNewRows(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Fact[] factArray = new Fact[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            factArray[i] = this.ontologyDb.getFact(true, stringArray[i]);
        }
        this.addRows(factArray);
    }

    public void addRows(Fact[] factArray) {
        if (factArray == null) {
            return;
        }
        if (factArray.length == 0) {
            return;
        }
        String string = null;
        string = this.protocol.getType().equals("Respondent") ? StrategyInfo.DEFAULT_RESPONDENT_STRATEGY : StrategyInfo.DEFAULT_INITIATOR_STRATEGY;
        int n = this.data.size();
        for (int i = 0; i < factArray.length; ++i) {
            Fact fact = new Fact(factArray[i]);
            String string2 = fact.ID();
            while (this.contains(string2)) {
                string2 = string2 + count++;
            }
            fact.setId(string2);
            this.data.addElement(new StrategyInfo(fact, string));
        }
        this.selectRow(-1);
        this.fireTableRowsInserted(n - 1, n + factArray.length - 1);
        this.fireChanged();
    }

    protected boolean contains(String string) {
        for (int i = 0; i < this.data.size(); ++i) {
            StrategyInfo strategyInfo = (StrategyInfo)this.data.elementAt(i);
            if (!string.equals(strategyInfo.getFact().ID())) continue;
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        StrategyInfo strategyInfo = (StrategyInfo)this.data.elementAt(n);
        return !(n2 == 1 || n2 == 4 && strategyInfo.getType() != 0 || n2 == 5 && strategyInfo.getType() != 0);
    }

    public Object getValueAt(int n, int n2) {
        StrategyInfo strategyInfo = (StrategyInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return new Boolean(strategyInfo.getType() == 0);
            }
            case 1: {
                return strategyInfo.getFact().getType();
            }
            case 5: {
                return strategyInfo.getType() == 0 ? strategyInfo.getParameters() : null;
            }
            case 2: {
                String[] stringArray = strategyInfo.getAgents();
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = this.genmodel.getAgentName(stringArray[i]);
                }
                return stringArray2;
            }
            case 3: {
                return strategyInfo.getRelations();
            }
            case 4: {
                return strategyInfo.getType() == 0 ? strategyInfo.getStrategy() : null;
            }
            case 6: {
                return strategyInfo.getFact();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        StrategyInfo strategyInfo = (StrategyInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                int n3;
                Boolean bl = (Boolean)object;
                int n4 = n3 = bl.equals(Boolean.TRUE) ? 0 : 1;
                if (n3 == strategyInfo.getType()) break;
                strategyInfo.setType(n3);
                if (n3 == 0) {
                    if (this.protocol.getType().equals("Respondent")) {
                        strategyInfo.setStrategy(StrategyInfo.DEFAULT_RESPONDENT_STRATEGY);
                    } else {
                        strategyInfo.setStrategy(StrategyInfo.DEFAULT_INITIATOR_STRATEGY);
                    }
                    strategyInfo.clearParameters();
                }
                this.fireTableCellUpdated(n, 4);
                this.fireTableCellUpdated(n, 5);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 1: {
                Core.ERROR(null, 1, (Object)this);
                break;
            }
            case 2: {
                String[] stringArray = (String[])object;
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = this.genmodel.reverseAgentNameLookup(stringArray[i]);
                    if (stringArray2[i] != null) continue;
                    stringArray2[i] = this.genmodel.createNewAgentId();
                    this.genmodel.createNewAgent(stringArray2[i]);
                    this.genmodel.renameAgent(stringArray2[i], stringArray[i]);
                }
                strategyInfo.setAgents(stringArray2);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 3: {
                String[] stringArray = (String[])object;
                strategyInfo.setRelations(stringArray);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 4: {
                Core.ERROR(strategyInfo.getType() == 0, 2, (Object)this);
                if (strategyInfo.getStrategy().equals(object)) {
                    return;
                }
                strategyInfo.setStrategy((String)object);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 5: {
                Core.ERROR(strategyInfo.getType() == 0, 3, (Object)this);
                if (strategyInfo.getParameters().equals(object)) {
                    return;
                }
                strategyInfo.setParameters((Hashtable)object);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object != this.ontologyDb && object == this.genmodel) {
            this.fireTableDataChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StrategyModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StrategyModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? StrategyModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = SystemProps.getProperty("file.separator");
        String string2 = SystemProps.getProperty("user.strategy.initiator");
        String string3 = SystemProps.getProperty("user.strategy.respondent");
        String string4 = SystemProps.getProperty("system.strategy.initiator");
        String string5 = SystemProps.getProperty("system.strategy.respondent");
        StringTokenizer stringTokenizer = null;
        HSet hSet = new HSet();
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, string);
            while (stringTokenizer.hasMoreTokens()) {
                hSet.add(stringTokenizer.nextToken());
            }
        }
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, string);
            while (stringTokenizer.hasMoreTokens()) {
                hSet.add(stringTokenizer.nextToken());
            }
        }
        if (StrategyInfo.DEFAULT_INITIATOR_STRATEGY != null) {
            hSet.add(StrategyInfo.DEFAULT_INITIATOR_STRATEGY);
        }
        INITIATOR_STRATEGY_LIST = hSet.toVector();
        hSet.clear();
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(string5, string);
            while (stringTokenizer.hasMoreTokens()) {
                hSet.add(stringTokenizer.nextToken());
            }
        }
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, string);
            while (stringTokenizer.hasMoreTokens()) {
                hSet.add(stringTokenizer.nextToken());
            }
        }
        if (StrategyInfo.DEFAULT_RESPONDENT_STRATEGY != null) {
            hSet.add(StrategyInfo.DEFAULT_RESPONDENT_STRATEGY);
        }
        RESPONDENT_STRATEGY_LIST = hSet.toVector();
    }
}

