/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Acquaintance;
import zeus.concepts.AgentDescription;
import zeus.concepts.OntologyDb;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AbilityModel;
import zeus.generator.agent.AcquaintanceModel;
import zeus.generator.agent.AgentEditor;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.AttributeTable;
import zeus.generator.util.ControlPanel;
import zeus.generator.util.FactDialog;
import zeus.generator.util.FactSelector;
import zeus.gui.fields.NameField;
import zeus.gui.fields.RealNumberField;
import zeus.gui.fields.WholeNumberField;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class OrganisationPanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected ControlPanel controlPane;
    protected AgentDescription agent;
    protected AcquaintanceModel acquaintanceModel;
    protected JTable acquaintanceTable;
    protected AbilityModel abilityModel;
    protected JTable abilityTable;
    protected AgentGenerator generator;
    protected GeneratorModel genmodel;
    protected OntologyDb ontologyDb;
    protected AgentEditor editor;
    protected AbilitySpec[] clipboard = null;
    protected FactToolBar factToolBar;

    public OrganisationPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, AgentEditor agentEditor, AgentDescription agentDescription) {
        this.agent = agentDescription;
        this.generator = agentGenerator;
        this.genmodel = generatorModel;
        this.editor = agentEditor;
        this.ontologyDb = ontologyDb;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.controlPane = new ControlPanel(agentEditor, "Agent Organisation Panel", false, false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.controlPane, gridBagConstraints);
        this.add(this.controlPane);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        AttributeModel attributeModel = new AttributeModel();
        AttributeTable attributeTable = new AttributeTable(attributeModel);
        this.abilityModel = new AbilityModel(ontologyDb, attributeModel);
        this.acquaintanceModel = new AcquaintanceModel(generatorModel, ontologyDb, this.abilityModel, agentDescription.getAcquaintances());
        attributeModel.addChangeListener(agentEditor);
        this.abilityModel.addChangeListener(agentEditor);
        this.acquaintanceModel.addChangeListener(agentEditor);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.acquaintanceModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12, new DefaultTableCellRenderer(), new RelationEditor());
        tableColumn.setHeaderValue(this.acquaintanceModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.acquaintanceTable = new JTable(this.acquaintanceModel, defaultTableColumnModel);
        this.acquaintanceTable.getTableHeader().setReorderingAllowed(false);
        this.acquaintanceTable.setColumnSelectionAllowed(false);
        ListSelectionModel listSelectionModel = this.acquaintanceTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction1());
        JScrollPane jScrollPane = new JScrollPane(this.acquaintanceTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(340, 120));
        this.acquaintanceTable.setBackground(Color.white);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        this.acquaintanceTable.setMinimumSize(new Dimension(400, 140));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Acquaintances");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        AcquaintanceToolBar acquaintanceToolBar = new AcquaintanceToolBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(acquaintanceToolBar, gridBagConstraints);
        jPanel.add(acquaintanceToolBar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        defaultTableColumnModel = new DefaultTableColumnModel();
        tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(this.abilityModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new RealNumberField()));
        tableColumn.setHeaderValue(this.abilityModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new WholeNumberField()));
        tableColumn.setHeaderValue(this.abilityModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.abilityTable = new JTable(this.abilityModel, defaultTableColumnModel);
        this.abilityTable.getTableHeader().setReorderingAllowed(false);
        this.abilityTable.setColumnSelectionAllowed(false);
        listSelectionModel = this.abilityTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction2());
        jScrollPane = new JScrollPane(this.abilityTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        this.abilityTable.setBackground(Color.white);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        this.abilityTable.setMinimumSize(new Dimension(400, 120));
        attributeTable.setMinimumSize(new Dimension(400, 140));
        titledBorder = BorderFactory.createTitledBorder("Acquaintance Abilities");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        this.factToolBar = new FactToolBar();
        this.factToolBar.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(this.factToolBar, gridBagConstraints);
        jPanel2.add(this.factToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(attributeTable, gridBagConstraints);
        jPanel2.add(attributeTable);
    }

    void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    protected void resetAcquaintance() {
        int n = this.acquaintanceTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return;
        }
        this.acquaintanceModel.setValueAt(SystemProps.getProperty("organisation.relations.default"), n, 1);
    }

    protected String getSelectedAcquaintanceName() {
        int n = this.acquaintanceTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.acquaintanceModel.getValueAt(n, 0);
    }

    protected String getSelectedAcquaintanceId() {
        int n = this.acquaintanceTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.acquaintanceModel.getValueAt(n, 2);
    }

    protected void addNewAcquaintance() {
        this.acquaintanceModel.addNewRow();
        this.factToolBar.setEnabled(false);
    }

    protected void addNewAcquaintance(String string) {
        this.acquaintanceModel.addNewRow(string);
        this.factToolBar.setEnabled(false);
    }

    protected void editAcquaintance() {
        String string = this.getSelectedAcquaintanceId();
        if (string == null) {
            return;
        }
        this.generator.editAgent(string);
    }

    protected void removeAcquaintance() {
        int n = this.acquaintanceTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return;
        }
        this.acquaintanceModel.removeRow(n);
        this.factToolBar.setEnabled(false);
        this.repaint();
    }

    protected void reset(Acquaintance[] acquaintanceArray) {
        this.acquaintanceModel.reset(acquaintanceArray);
        this.factToolBar.setEnabled(false);
    }

    protected Acquaintance[] getData() {
        return this.acquaintanceModel.getData();
    }

    protected AbilitySpec[] getSelectedAbilities() {
        int[] nArray = this.abilityTable.getSelectedRows();
        AbilitySpec[] abilitySpecArray = new AbilitySpec[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            abilitySpecArray[i] = (AbilitySpec)this.abilityModel.getValueAt(nArray[i], 3);
        }
        return abilitySpecArray;
    }

    protected AbilitySpec[] cutSelectedAbilities() {
        AbilitySpec[] abilitySpecArray = this.getSelectedAbilities();
        this.abilityModel.removeRows(this.abilityTable.getSelectedRows());
        this.repaint();
        return abilitySpecArray;
    }

    protected void deleteSelectedAbilities() {
        int n = this.abilityTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return;
        }
        this.cutSelectedAbilities();
    }

    public void save() {
        this.agent.setAcquaintances(this.acquaintanceModel.getData());
    }

    class SymListAction2
    implements ListSelectionListener {
        SymListAction2() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            OrganisationPanel.this.abilityModel.selectRow(OrganisationPanel.this.abilityTable.getSelectedRow());
            OrganisationPanel.this.repaint();
        }
    }

    class SymListAction1
    implements ListSelectionListener {
        SymListAction1() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = OrganisationPanel.this.acquaintanceTable.getSelectedRow();
            OrganisationPanel.this.acquaintanceModel.selectRow(n);
            OrganisationPanel.this.factToolBar.setEnabled(n != -1);
            OrganisationPanel.this.repaint();
        }
    }

    class RelationEditor
    extends DefaultCellEditor {
        public RelationEditor() {
            super(new JComboBox(AcquaintanceModel.RELATIONS_LIST){

                public void contentsChanged(ListDataEvent listDataEvent) {
                    this.selectedItemReminder = null;
                    super.contentsChanged(listDataEvent);
                }
            });
            this.setClickCountToStart(2);
        }
    }

    class FactToolBar
    extends JToolBar
    implements ActionListener,
    FactSelector {
        protected FactDialog factWin;
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;

        public FactToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.factWin = new FactDialog((Frame)OrganisationPanel.this.editor, OrganisationPanel.this.ontologyDb);
        }

        public void setEnabled(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
            this.cutBtn.setEnabled(bl);
            this.copyBtn.setEnabled(bl);
            this.pasteBtn.setEnabled(bl);
        }

        public void factSelected(String[] stringArray) {
            OrganisationPanel.this.abilityModel.addNewRows(stringArray);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.factWin.setLocationRelativeTo(this.newBtn);
                this.factWin.display(this);
            } else if (object == this.deleteBtn) {
                OrganisationPanel.this.deleteSelectedAbilities();
            } else if (object == this.copyBtn) {
                OrganisationPanel.this.clipboard = OrganisationPanel.this.getSelectedAbilities();
            } else if (object == this.pasteBtn) {
                OrganisationPanel.this.abilityModel.addRows(OrganisationPanel.this.clipboard);
                OrganisationPanel.this.abilityTable.clearSelection();
            } else if (object == this.cutBtn) {
                OrganisationPanel.this.clipboard = OrganisationPanel.this.cutSelectedAbilities();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(OrganisationPanel.this.editor, point, "generator", "Activity Org-2");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class AcquaintanceToolBar
    extends JToolBar
    implements ActionListener {
        protected JToggleButton helpBtn;
        protected JToggleButton allBtn;
        protected JToggleButton peerBtn;
        protected JToggleButton nonpeerBtn;
        protected HelpWindow helpWin;
        protected JButton resetBtn;
        protected JButton newBtn;
        protected JButton editBtn;
        protected JButton deleteBtn;
        protected JPopupMenu popup;
        protected JMenuItem addMenuItem;

        public AcquaintanceToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
            this.newBtn = new JButton(new ImageIcon(string + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New acquaintance");
            this.newBtn.addActionListener(this);
            this.addSeparator();
            this.editBtn = new JButton(new ImageIcon(string + "edit1.gif"));
            this.editBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.editBtn);
            this.editBtn.setToolTipText("Edit this acquaintance");
            this.editBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete this acquaintance");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.resetBtn = new JButton(new ImageIcon(string + "reset.gif"));
            this.resetBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.resetBtn);
            this.resetBtn.setToolTipText("Reset acquaintance to peer");
            this.resetBtn.addActionListener(this);
            this.addSeparator();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.allBtn = new JToggleButton(new ImageIcon(string + "all.gif"), true);
            this.allBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.allBtn);
            this.allBtn.setToolTipText("Show all acquaintances");
            this.allBtn.addActionListener(this);
            buttonGroup.add(this.allBtn);
            this.peerBtn = new JToggleButton(new ImageIcon(string + "peers.gif"));
            this.peerBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.peerBtn);
            this.peerBtn.setToolTipText("Show peers only");
            this.peerBtn.addActionListener(this);
            buttonGroup.add(this.peerBtn);
            this.nonpeerBtn = new JToggleButton(new ImageIcon(string + "others.gif"));
            this.nonpeerBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.nonpeerBtn);
            this.nonpeerBtn.setToolTipText("Show non-peers only");
            this.nonpeerBtn.addActionListener(this);
            buttonGroup.add(this.nonpeerBtn);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.popup = new JPopupMenu("Add new acquaintance");
            this.addMenuItem = new JMenuItem("Create new acquaintance");
            this.addMenuItem.addActionListener(this);
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
            this.popup.setBorder(compoundBorder);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray;
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.popup.removeAll();
                this.popup.add(this.addMenuItem);
                this.popup.addSeparator();
                stringArray = OrganisationPanel.this.genmodel.getAgentNames();
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(OrganisationPanel.this.editor.getObjectName());
                for (int i = 0; i < OrganisationPanel.this.acquaintanceModel.getRowCount(); ++i) {
                    vector.addElement(OrganisationPanel.this.acquaintanceModel.getValueAt(i, 0));
                }
                Vector vector2 = Misc.stringVector(stringArray);
                Vector vector3 = Misc.difference(vector2, vector);
                for (int i = 0; i < vector3.size(); ++i) {
                    JMenuItem jMenuItem = new JMenuItem((String)vector3.elementAt(i));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setActionCommand("NEW_ACQUAINTANCE");
                    this.popup.add(jMenuItem);
                }
                this.popup.pack();
                this.popup.show(this.newBtn, 0, 0);
            } else if (object == this.addMenuItem) {
                OrganisationPanel.this.addNewAcquaintance();
            } else if (actionEvent.getActionCommand().equals("NEW_ACQUAINTANCE")) {
                OrganisationPanel.this.addNewAcquaintance(((JMenuItem)object).getText());
            } else if (object == this.editBtn) {
                OrganisationPanel.this.editAcquaintance();
            } else if (object == this.deleteBtn) {
                OrganisationPanel.this.removeAcquaintance();
            }
            if (object == this.resetBtn) {
                OrganisationPanel.this.resetAcquaintance();
            } else if (object == this.allBtn) {
                OrganisationPanel.this.acquaintanceModel.setFilter(0);
            } else if (object == this.peerBtn) {
                OrganisationPanel.this.acquaintanceModel.setFilter(1);
            } else if (object == this.nonpeerBtn) {
                OrganisationPanel.this.acquaintanceModel.setFilter(2);
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    stringArray = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), (Point)stringArray, "generator", "Activity Org-1");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

