/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import zeus.concepts.AgentDescription;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AgentEditor;
import zeus.generator.agent.TaskPanel;
import zeus.generator.util.ControlPanel;
import zeus.generator.util.FactPanel;
import zeus.gui.fields.WholeNumberField;
import zeus.util.SystemProps;

public class DefinitionPanel
extends JPanel {
    protected WholeNumberField planner_width;
    protected WholeNumberField planner_length;
    protected TaskPanel taskPanel;
    protected FactPanel factPanel;
    protected AgentDescription agent;

    public DefinitionPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, AgentEditor agentEditor, AgentDescription agentDescription) {
        this.agent = agentDescription;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        ControlPanel controlPanel = new ControlPanel(agentEditor, "Agent Definition Panel", true, false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(controlPanel, gridBagConstraints);
        this.add(controlPanel);
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        String[] stringArray = agentDescription.getTasks();
        this.taskPanel = new TaskPanel(agentGenerator, generatorModel, agentEditor, stringArray, "Task Identification");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.taskPanel, gridBagConstraints);
        this.add(this.taskPanel);
        Fact[] factArray = agentDescription.getInitialFacts();
        this.factPanel = new FactPanel(ontologyDb, agentEditor, factArray, false, "Initial Agent Resources");
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.factPanel, gridBagConstraints);
        this.add(this.factPanel);
        jPanel.setBackground(Color.lightGray);
        int n = SystemProps.getInt("planner.processors.min");
        int n2 = SystemProps.getInt("planner.processors.max");
        int n3 = SystemProps.getInt("planner.length.min");
        int n4 = SystemProps.getInt("planner.length.max");
        this.planner_width = new WholeNumberField(n, n2);
        this.planner_width.setBackground(Color.white);
        this.planner_width.setValue(agentDescription.getPlannerWidth());
        this.planner_width.addChangeListener(agentEditor);
        this.planner_length = new WholeNumberField(n3, n4);
        this.planner_length.setBackground(Color.white);
        this.planner_length.setValue(agentDescription.getPlannerLength());
        this.planner_length.addChangeListener(agentEditor);
        this.planner_width.setPreferredSize(new Dimension(200, 20));
        this.planner_length.setPreferredSize(new Dimension(200, 20));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Planning Parameters");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Maximum Number of Simultaneous Tasks");
        jLabel.setFont(new Font("Helvetica", 0, 12));
        jLabel.setToolTipText("Minimum = " + n + ", Maximum = " + n2);
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagLayout2.setConstraints(this.planner_width, gridBagConstraints);
        jPanel.add(this.planner_width);
        JLabel jLabel2 = new JLabel("Planner Length");
        jLabel2.setFont(new Font("Helvetica", 0, 12));
        jLabel2.setToolTipText("Minimum = " + n3 + ", Maximum = " + n4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this.planner_length, gridBagConstraints);
        jPanel.add(this.planner_length);
    }

    public void save() {
        Long l = this.planner_width.getValue();
        if (l != null) {
            this.agent.setPlannerWidth(l.intValue());
        }
        if ((l = this.planner_length.getValue()) != null) {
            this.agent.setPlannerLength(l.intValue());
        }
        this.agent.setTasks(this.taskPanel.getData());
        this.agent.setInitialFacts(this.factPanel.getData());
    }
}

