/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Acquaintance;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.util.AttributeModel;
import zeus.util.Core;

public class AbilityModel
extends AbstractTableModel
implements ChangeListener {
    static final int TYPE = 0;
    static final int TIME = 1;
    static final int COST = 2;
    static final int ABILITY = 3;
    static int count = 0;
    protected String[] columnNames = new String[]{"Ability Type", "Time", "Cost"};
    protected int selectedRow = -1;
    protected AttributeModel attributeModel;
    protected OntologyDb ontologyDb;
    protected Vector data = new Vector(100);
    protected Acquaintance acquaintance = null;
    protected EventListenerList changeListeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public AbilityModel(OntologyDb ontologyDb, AttributeModel attributeModel) {
        this.ontologyDb = ontologyDb;
        this.attributeModel = attributeModel;
        ontologyDb.addChangeListener(this);
    }

    public void reset(Acquaintance acquaintance) {
        if (this.acquaintance != null) {
            this.acquaintance.setAbilities(this.data);
        }
        int n = this.data.size();
        this.acquaintance = acquaintance;
        this.data.removeAllElements();
        this.selectRow(-1);
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        if (acquaintance != null) {
            AbilitySpec[] abilitySpecArray = acquaintance.getAbilities();
            for (int i = 0; i < abilitySpecArray.length; ++i) {
                this.data.addElement(abilitySpecArray[i]);
            }
            this.fireTableRowsInserted(0, abilitySpecArray.length - 1);
        }
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.data.removeElementAt(nArray[i] - i);
            this.fireTableRowsDeleted(nArray[i] - i, nArray[i] - i);
        }
        this.selectRow(-1);
        this.fireChanged();
    }

    public void selectRow(int n) {
        this.selectedRow = n;
        if (this.attributeModel != null) {
            if (this.selectedRow >= 0) {
                AbilitySpec abilitySpec = (AbilitySpec)this.data.elementAt(this.selectedRow);
                this.attributeModel.reset(abilitySpec.getFact());
            } else {
                this.attributeModel.reset(null);
            }
        }
    }

    public void addNewRows(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        AbilitySpec[] abilitySpecArray = new AbilitySpec[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Fact fact = this.ontologyDb.getFact(true, stringArray[i]);
            abilitySpecArray[i] = new AbilitySpec(fact, 0, 0.0);
        }
        this.addRows(abilitySpecArray);
    }

    public void addRows(AbilitySpec[] abilitySpecArray) {
        if (abilitySpecArray == null) {
            return;
        }
        if (abilitySpecArray.length == 0) {
            return;
        }
        int n = this.data.size();
        for (int i = 0; i < abilitySpecArray.length; ++i) {
            AbilitySpec abilitySpec = new AbilitySpec(abilitySpecArray[i]);
            String string = abilitySpec.getFact().ID();
            while (this.contains(string)) {
                string = string + count++;
            }
            abilitySpec.getFact().setId(string);
            this.data.addElement(abilitySpec);
        }
        this.selectRow(-1);
        this.fireTableRowsInserted(n - 1, n + abilitySpecArray.length - 1);
        this.fireChanged();
    }

    protected boolean contains(String string) {
        for (int i = 0; i < this.data.size(); ++i) {
            AbilitySpec abilitySpec = (AbilitySpec)this.data.elementAt(i);
            if (!string.equals(abilitySpec.getFact().ID())) continue;
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        AbilitySpec abilitySpec = (AbilitySpec)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return abilitySpec.getType();
            }
            case 2: {
                return new Double(abilitySpec.getCost());
            }
            case 1: {
                return new Integer(abilitySpec.getTime());
            }
            case 3: {
                return abilitySpec;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        AbilitySpec abilitySpec = (AbilitySpec)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                Core.ERROR(null, 1, (Object)this);
                break;
            }
            case 1: {
                int n3 = Integer.parseInt((String)object);
                if (n3 == abilitySpec.getTime()) {
                    return;
                }
                abilitySpec.setTime(n3);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 2: {
                double d = Double.valueOf((String)object);
                if (Math.abs(d - abilitySpec.getCost()) < 1.0E-12) {
                    return;
                }
                abilitySpec.setCost(d);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbilityModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbilityModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? AbilityModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

