/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.TaskTableModel;
import zeus.gui.fields.NameField;

public class TaskTableUI
extends JPanel {
    protected JTable table;
    protected TaskTableModel model;
    protected AgentGenerator generator;
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};

    public TaskTableUI(AgentGenerator agentGenerator, GeneratorModel generatorModel) {
        this.generator = agentGenerator;
        this.model = new TaskTableModel(generatorModel);
        this.setPreferredSize(new Dimension(240, 120));
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        this.table.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = TaskTableUI.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1 && TaskTableUI.this.table.isRowSelected(n) && mouseEvent.getClickCount() == 2) {
                    TaskTableUI.this.editTask();
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
    }

    void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    protected String getSelectedTaskName() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.model.getValueAt(n, 0);
    }

    protected String getSelectedTaskId() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.model.getValueAt(n, 2);
    }

    public void addNewTask(int n) {
        this.model.addNewRow(n);
    }

    public void editTask() {
        String string = this.getSelectedTaskId();
        if (string == null) {
            return;
        }
        this.generator.editTask(string);
    }

    public void removeTask() {
        String string = this.getSelectedTaskId();
        if (string == null) {
            return;
        }
        this.generator.removeTask(string);
    }

    public void cloneTask() {
        String string = this.getSelectedTaskId();
        if (string == null) {
            return;
        }
        this.generator.cloneTask(string);
    }

    public void renameTask() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return;
        }
        this.model.setEditable(true);
        this.table.editCellAt(n, 0);
        this.model.setEditable(false);
    }
}

