/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.AbstractTask;
import zeus.generator.GeneratorModel;

public class TaskTableModel
extends AbstractTableModel
implements ChangeListener {
    static final int TASK = 0;
    static final int TYPE = 1;
    static final int ID = 2;
    protected String[] columnNames = new String[]{"Task", "Type"};
    protected Object[][] data = new Object[0][2];
    protected boolean isEditable = false;
    protected GeneratorModel genmodel;

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public TaskTableModel(GeneratorModel generatorModel) {
        this.genmodel = generatorModel;
        generatorModel.addChangeListener(this);
        this.data = generatorModel.getTaskData();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.isEditable && n2 == 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null || object.toString().equals("")) {
            return;
        }
        switch (n2) {
            case 0: {
                if (this.data[n][0].equals((String)object)) {
                    return;
                }
                this.genmodel.renameTask((String)this.data[n][2], (String)object);
            }
        }
    }

    public void addNewRow(int n) {
        this.genmodel.createNewTask(AbstractTask.getTypeName(n));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.data.length;
        this.data = this.genmodel.getTaskData();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        this.fireTableDataChanged();
    }
}

