/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import zeus.concepts.AgentDescription;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.SocietyModel;
import zeus.generator.agent.AcquaintanceModel;
import zeus.gui.graph.AbstractGraphNodeEditor;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphNode;
import zeus.gui.graph.GraphNodeRenderer;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class SocietyPanel
extends JPanel {
    protected Graph graph;
    protected GraphNode[] clipboard;
    protected SocietyModel model;
    protected GeneratorModel genmodel;
    protected AgentGenerator generator;

    public SocietyPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel) {
        this.generator = agentGenerator;
        this.genmodel = generatorModel;
        this.model = new SocietyModel(generatorModel, true);
        this.graph = new Graph(0, this.model, true, false);
        this.graph.setNodeRenderer(new SocietyNodeRenderer());
        this.graph.setNodeEditor(new SocietyNodeEditor());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        SoceityControlPanel soceityControlPanel = new SoceityControlPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(soceityControlPanel, gridBagConstraints);
        jPanel.add(soceityControlPanel);
        jPanel.setBackground(Color.lightGray);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        JScrollPane jScrollPane = new JScrollPane(this.graph);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(600, 600));
        this.graph.setPreferredSize(new Dimension(2000, 2000));
        this.graph.setBackground(Color.white);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Agent Society");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        NodesToolBar nodesToolBar = new NodesToolBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(nodesToolBar, gridBagConstraints);
        jPanel2.add(nodesToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
    }

    protected void deleteSelectedNodes() {
        this.model.removeNodes(this.graph.getSelectedNodes());
        this.graph.redraw();
    }

    protected GraphNode[] cutSelectedNodes() {
        GraphNode[] graphNodeArray = this.graph.getSelectedNodes();
        this.model.removeNodes(graphNodeArray);
        this.graph.redraw();
        return graphNodeArray;
    }

    protected class SoceityControlPanel
    extends JPanel
    implements ItemListener {
        protected JCheckBox[] checkbox;
        protected JRadioButton[] view;

        public SoceityControlPanel() {
            int n;
            String[] stringArray = Misc.stringArray(AcquaintanceModel.RELATIONS_LIST);
            this.checkbox = new JCheckBox[stringArray.length];
            this.view = new JRadioButton[stringArray.length];
            JPanel jPanel = new JPanel();
            TitledBorder titledBorder = BorderFactory.createTitledBorder("View Style");
            titledBorder.setTitlePosition(2);
            titledBorder.setTitleJustification(3);
            titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
            titledBorder.setTitleColor(Color.blue);
            jPanel.setBorder(titledBorder);
            jPanel.setBackground(Color.lightGray);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            jPanel.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < this.view.length; ++i) {
                this.view[i] = i == 0 ? new JRadioButton("vertical", SocietyPanel.this.model.getView() == i) : (i == 1 ? new JRadioButton("centered", SocietyPanel.this.model.getView() == i) : new JRadioButton(stringArray[i], SocietyPanel.this.model.getView() == i));
                this.view[i].setBackground(Color.lightGray);
                buttonGroup.add(this.view[i]);
                gridBagLayout.setConstraints(this.view[i], gridBagConstraints);
                jPanel.add(this.view[i]);
            }
            JPanel jPanel2 = new JPanel();
            titledBorder = BorderFactory.createTitledBorder("Relational Links");
            titledBorder.setTitlePosition(2);
            titledBorder.setTitleJustification(3);
            titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
            titledBorder.setTitleColor(Color.blue);
            jPanel2.setBorder(titledBorder);
            jPanel2.setBackground(Color.lightGray);
            gridBagLayout = new GridBagLayout();
            gridBagConstraints = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout);
            for (n = 0; n < this.checkbox.length; ++n) {
                this.checkbox[n] = new JCheckBox(stringArray[n]);
                this.checkbox[n].setBackground(Color.lightGray);
                JPanel jPanel3 = new JPanel();
                jPanel3.setSize(10, 10);
                jPanel3.setBackground(SocietyPanel.this.model.getColor(n));
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(4, 4, 0, 0);
                gridBagConstraints.gridwidth = 1;
                gridBagLayout.setConstraints(this.checkbox[n], gridBagConstraints);
                jPanel2.add(this.checkbox[n]);
                gridBagConstraints.anchor = 13;
                gridBagConstraints.insets = new Insets(4, 0, 0, 4);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
                jPanel2.add(jPanel3);
            }
            gridBagLayout = new GridBagLayout();
            gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            for (n = 0; n < this.checkbox.length; ++n) {
                this.checkbox[n].setSelected(SocietyPanel.this.model.isLinkVisible(n));
                this.checkbox[n].addItemListener(this);
                this.view[n].addItemListener(this);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            for (int i = 0; i < this.checkbox.length; ++i) {
                if (object == this.checkbox[i]) {
                    SocietyPanel.this.model.showLinks(i, this.checkbox[i].isSelected());
                    SocietyPanel.this.graph.redraw();
                    return;
                }
                if (object != this.view[i]) continue;
                switch (i) {
                    case 0: {
                        SocietyPanel.this.graph.setViewMode(0);
                        break;
                    }
                    case 1: {
                        SocietyPanel.this.graph.setViewMode(4);
                        break;
                    }
                    default: {
                        SocietyPanel.this.graph.setViewMode(5);
                    }
                }
                SocietyPanel.this.model.setView(i);
                SocietyPanel.this.graph.recompute();
                return;
            }
        }
    }

    class SocietyNodeEditor
    extends AbstractGraphNodeEditor
    implements ActionListener {
        protected JButton button = new JButton("Click to edit");
        protected GraphNode node;
        protected Graph graph;
        protected FileDialog dialog = null;

        public SocietyNodeEditor() {
            this.button.setBackground(Color.lightGray);
            this.button.setHorizontalAlignment(0);
            this.button.setBorderPainted(true);
            this.button.addActionListener(this);
            this.button.setOpaque(true);
            this.button.setMinimumSize(new Dimension(120, 30));
            this.button.setPreferredSize(new Dimension(120, 30));
            this.button.setSize(120, 30);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                File file;
                AgentDescription agentDescription;
                String string;
                if (this.dialog == null) {
                    this.dialog = new FileDialog((Frame)SwingUtilities.getRoot(this.button), "Select Icon File", 0);
                }
                if ((string = SocietyPanel.this.genmodel.getAgentIcon((agentDescription = (AgentDescription)this.node.getUserObject()).getName())) != null) {
                    file = new File(string);
                    this.dialog.setFile(file.getName());
                    this.dialog.setDirectory(file.getParent());
                } else {
                    this.dialog.setFile("*.gif");
                }
                this.dialog.pack();
                this.dialog.setVisible(true);
                File file2 = file = this.dialog.getFile() == null ? null : this.dialog.getDirectory() + File.separator + this.dialog.getFile();
                if (file == null) {
                    this.fireEditAction(1, this.node, null);
                } else {
                    this.fireEditAction(0, this.node, file);
                }
            }
        }

        public Component getNodeEditorComponent(Graph graph, GraphNode graphNode) {
            this.graph = graph;
            this.node = graphNode;
            return this.button;
        }
    }

    protected class NodesToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton selectBtn;
        protected JButton selectAllBtn;
        protected JButton hideBtn;
        protected JButton showBtn;
        protected JButton collapseBtn;
        protected JButton expandBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JButton recomputeBtn;
        protected JButton redrawBtn;

        public NodesToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New node");
            this.newBtn.addActionListener(this);
            this.addSeparator();
            this.recomputeBtn = new JButton(new ImageIcon(string2 + "recompute.gif"));
            this.recomputeBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.recomputeBtn);
            this.recomputeBtn.setToolTipText("Recompute node positions");
            this.recomputeBtn.addActionListener(this);
            this.redrawBtn = new JButton(new ImageIcon(string2 + "redraw.gif"));
            this.redrawBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.redrawBtn);
            this.redrawBtn.setToolTipText("Redraw");
            this.redrawBtn.addActionListener(this);
            this.addSeparator();
            this.selectBtn = new JButton(new ImageIcon(string2 + "select.gif"));
            this.selectBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectBtn);
            this.selectBtn.setToolTipText("Select nodes");
            this.selectBtn.addActionListener(this);
            this.selectAllBtn = new JButton(new ImageIcon(string2 + "selectAll.gif"));
            this.selectAllBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectAllBtn);
            this.selectAllBtn.setToolTipText("Select all nodes");
            this.selectAllBtn.addActionListener(this);
            this.addSeparator();
            this.collapseBtn = new JButton(new ImageIcon(string2 + "collapse.gif"));
            this.collapseBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.collapseBtn);
            this.collapseBtn.setToolTipText("Collapse nodes");
            this.collapseBtn.addActionListener(this);
            this.expandBtn = new JButton(new ImageIcon(string2 + "expand.gif"));
            this.expandBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.expandBtn);
            this.expandBtn.setToolTipText("Expand nodes");
            this.expandBtn.addActionListener(this);
            this.addSeparator();
            this.hideBtn = new JButton(new ImageIcon(string2 + "hide.gif"));
            this.hideBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.hideBtn);
            this.hideBtn.setToolTipText("Hide nodes");
            this.hideBtn.addActionListener(this);
            this.showBtn = new JButton(new ImageIcon(string2 + "show.gif"));
            this.showBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.showBtn);
            this.showBtn.setToolTipText("Show nodes");
            this.showBtn.addActionListener(this);
            this.addSeparator();
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                SocietyPanel.this.model.addNewNode();
            } else if (object == this.recomputeBtn) {
                SocietyPanel.this.graph.recompute();
            } else if (object == this.redrawBtn) {
                SocietyPanel.this.graph.redraw();
            } else if (object == this.selectBtn) {
                SocietyPanel.this.graph.select();
            } else if (object == this.selectAllBtn) {
                SocietyPanel.this.graph.selectAll();
            } else if (object == this.collapseBtn) {
                SocietyPanel.this.graph.collapse();
            } else if (object == this.expandBtn) {
                SocietyPanel.this.graph.expand();
            } else if (object == this.hideBtn) {
                SocietyPanel.this.graph.hide();
            } else if (object == this.showBtn) {
                SocietyPanel.this.graph.show();
            } else if (object == this.deleteBtn) {
                SocietyPanel.this.deleteSelectedNodes();
            } else if (object == this.copyBtn) {
                SocietyPanel.this.clipboard = SocietyPanel.this.graph.getSelectedNodes();
            } else if (object == this.pasteBtn) {
                SocietyPanel.this.model.addNodes(SocietyPanel.this.clipboard);
            } else if (object == this.cutBtn) {
                SocietyPanel.this.clipboard = SocietyPanel.this.cutSelectedNodes();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", "Society Viewer");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    protected class SocietyNodeRenderer
    implements GraphNodeRenderer {
        protected SocietyNodeRenderer() {
        }

        public Component getNodeRendererComponent(Graph graph, GraphNode graphNode) {
            AgentDescription agentDescription = (AgentDescription)graphNode.getUserObject();
            String string = agentDescription.getName();
            String string2 = SocietyPanel.this.genmodel.getAgentName(string);
            String string3 = SocietyPanel.this.genmodel.getAgentIcon(string);
            if (string3 == null) {
                return new JLabel(string2, 0);
            }
            JLabel jLabel = new JLabel(string2, new ImageIcon(string3), 0);
            jLabel.setVerticalTextPosition(3);
            jLabel.setHorizontalTextPosition(0);
            return jLabel;
        }
    }
}

