/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.awt.Color;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.Acquaintance;
import zeus.concepts.AgentDescription;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AcquaintanceModel;
import zeus.generator.event.AgentChangeEvent;
import zeus.generator.event.AgentListener;
import zeus.gui.ColorManager;
import zeus.gui.graph.AbstractGraphModel;
import zeus.gui.graph.GraphNode;
import zeus.util.Misc;

public class SocietyModel
extends AbstractGraphModel
implements AgentListener {
    static final int SUPERIORS = 0;
    static final int SUBORDINATES = 1;
    static final int PEERS = 2;
    static final int COWORKERS = 3;
    protected boolean isNodeEditable = false;
    protected GeneratorModel genmodel = null;
    protected Hashtable nodeTable = new Hashtable();
    protected EventListenerList listeners = new EventListenerList();
    protected int view = 0;
    protected BitSet links = new BitSet(AcquaintanceModel.RELATIONS_LIST.size());
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public SocietyModel(GeneratorModel generatorModel, boolean bl) {
        this(generatorModel);
        this.isNodeEditable = bl;
    }

    public SocietyModel(GeneratorModel generatorModel) {
        this.genmodel = generatorModel;
        generatorModel.addAgentListener(this);
        this.reset();
    }

    public void reset() {
        this.nodeTable.clear();
        for (int i = 0; i < this.links.size(); ++i) {
            this.links.set(i);
        }
        AgentDescription[] agentDescriptionArray = this.genmodel.getAgents();
        for (int i = 0; i < agentDescriptionArray.length; ++i) {
            this.nodeTable.put(agentDescriptionArray[i].getName(), new GraphNode(agentDescriptionArray[i]));
        }
        for (int i = 0; i < agentDescriptionArray.length; ++i) {
            GraphNode graphNode = (GraphNode)this.nodeTable.get(agentDescriptionArray[i].getName());
            Acquaintance[] acquaintanceArray = agentDescriptionArray[i].getAcquaintances();
            block7: for (int j = 0; j < acquaintanceArray.length; ++j) {
                GraphNode graphNode2 = (GraphNode)this.nodeTable.get(acquaintanceArray[j].getName());
                String string = acquaintanceArray[j].getRelation();
                switch (Misc.whichPosition(string, AcquaintanceModel.RELATIONS_LIST)) {
                    case 0: {
                        graphNode2.addChild(graphNode);
                        graphNode.addParent(graphNode2);
                        continue block7;
                    }
                    case 1: {
                        graphNode.addChild(graphNode2);
                        graphNode2.addParent(graphNode);
                        continue block7;
                    }
                    default: {
                        graphNode.addSibling(graphNode2);
                        graphNode2.addSibling(graphNode);
                    }
                }
            }
        }
        this.fireGraphStructureChanged();
    }

    public Enumeration nodes() {
        return this.nodeTable.elements();
    }

    public void setValue(GraphNode graphNode, Object object) {
        AgentDescription agentDescription = (AgentDescription)graphNode.getUserObject();
        String string = agentDescription.getName();
        this.genmodel.setAgentIcon(string, (String)object);
        this.fireChanged();
    }

    public boolean isNodeEditable(GraphNode graphNode) {
        return this.isNodeEditable;
    }

    public Color getLinkColor(GraphNode graphNode, GraphNode graphNode2) {
        int n = this.getLinkType(graphNode, graphNode2);
        if (n != -1) {
            return this.getColor(n);
        }
        return Color.black;
    }

    public boolean isLinkVisible(GraphNode graphNode, GraphNode graphNode2) {
        int n = this.getLinkType(graphNode, graphNode2);
        if (n != -1) {
            return this.links.get(n);
        }
        return false;
    }

    public Vector getViewRelations(GraphNode graphNode) {
        Vector<Object> vector = new Vector<Object>();
        AgentDescription agentDescription = (AgentDescription)graphNode.getUserObject();
        String string = agentDescription.getName();
        Acquaintance[] acquaintanceArray = agentDescription.getAcquaintances();
        for (int i = 0; i < acquaintanceArray.length; ++i) {
            if (Misc.whichPosition(acquaintanceArray[i].getRelation(), AcquaintanceModel.RELATIONS_LIST) != this.view) continue;
            vector.addElement(this.nodeTable.get(acquaintanceArray[i].getName()));
        }
        Enumeration enumeration = this.nodeTable.elements();
        while (enumeration.hasMoreElements()) {
            GraphNode graphNode2 = (GraphNode)enumeration.nextElement();
            if (graphNode2 == graphNode || vector.contains(graphNode2)) continue;
            agentDescription = (AgentDescription)graphNode2.getUserObject();
            acquaintanceArray = agentDescription.getAcquaintances();
            for (int i = 0; i < acquaintanceArray.length; ++i) {
                if (!acquaintanceArray[i].getName().equals(string) || Misc.whichPosition(acquaintanceArray[i].getRelation(), AcquaintanceModel.RELATIONS_LIST) != this.view) continue;
                vector.addElement(graphNode2);
            }
        }
        return vector;
    }

    protected int getLinkType(GraphNode graphNode, GraphNode graphNode2) {
        AgentDescription agentDescription = (AgentDescription)graphNode.getUserObject();
        AgentDescription agentDescription2 = (AgentDescription)graphNode2.getUserObject();
        String string = agentDescription2.getName();
        Acquaintance[] acquaintanceArray = agentDescription.getAcquaintances();
        for (int i = 0; i < acquaintanceArray.length; ++i) {
            if (!acquaintanceArray[i].getName().equals(string)) continue;
            return Misc.whichPosition(acquaintanceArray[i].getRelation(), AcquaintanceModel.RELATIONS_LIST);
        }
        return -1;
    }

    public Color getColor(int n) {
        return ColorManager.getColor(n);
    }

    public boolean isLinkVisible(int n) {
        return this.links.get(n);
    }

    public void setView(int n) {
        this.view = n;
    }

    public int getView() {
        return this.view;
    }

    public void showLinks(int n, boolean bl) {
        if (bl) {
            this.links.set(n);
        } else {
            this.links.clear(n);
        }
    }

    public void removeNodes(GraphNode[] graphNodeArray) {
        for (int i = 0; i < graphNodeArray.length; ++i) {
            AgentDescription agentDescription = (AgentDescription)graphNodeArray[i].getUserObject();
            String string = agentDescription.getName();
            this.genmodel.removeAgent(string);
        }
        this.fireChanged();
    }

    public void addNewNode() {
        this.genmodel.createNewAgent();
    }

    public void addNodes(GraphNode[] graphNodeArray) {
        if (graphNodeArray == null || graphNodeArray.length == 0) {
            return;
        }
        for (int i = 0; i < graphNodeArray.length; ++i) {
            AgentDescription agentDescription = (AgentDescription)graphNodeArray[i].getUserObject();
            String string = agentDescription.getName();
            if (this.genmodel.containsAgent(string)) {
                this.genmodel.cloneAgent(string);
                continue;
            }
            this.genmodel.addAgent(agentDescription);
        }
        this.fireChanged();
    }

    public void agentStateChanged(AgentChangeEvent agentChangeEvent) {
        AgentDescription agentDescription = agentChangeEvent.getAgent();
        String string = agentDescription.getName();
        switch (agentChangeEvent.getEventType()) {
            case 0: {
                GraphNode graphNode = new GraphNode(agentDescription);
                this.nodeTable.put(string, graphNode);
                Acquaintance[] acquaintanceArray = agentDescription.getAcquaintances();
                block13: for (int i = 0; i < acquaintanceArray.length; ++i) {
                    GraphNode graphNode2 = (GraphNode)this.nodeTable.get(acquaintanceArray[i].getName());
                    if (graphNode2 == null) continue;
                    String string2 = acquaintanceArray[i].getRelation();
                    int n = Misc.whichPosition(string2, AcquaintanceModel.RELATIONS_LIST);
                    switch (n) {
                        case 0: {
                            graphNode2.addChild(graphNode);
                            graphNode.addParent(graphNode2);
                            this.fireGraphNodeStateChanged(graphNode2);
                            continue block13;
                        }
                        case 1: {
                            graphNode.addChild(graphNode2);
                            graphNode2.addParent(graphNode);
                            this.fireGraphNodeStateChanged(graphNode2);
                            continue block13;
                        }
                        default: {
                            graphNode.addSibling(graphNode2);
                            graphNode2.addSibling(graphNode);
                            this.fireGraphNodeStateChanged(graphNode2);
                        }
                    }
                }
                this.fireGraphNodeAdded(graphNode);
                break;
            }
            case 2: {
                GraphNode graphNode = (GraphNode)this.nodeTable.remove(string);
                Enumeration enumeration = this.nodeTable.elements();
                while (enumeration.hasMoreElements()) {
                    GraphNode graphNode3 = (GraphNode)enumeration.nextElement();
                    if (graphNode3.hasChild(graphNode)) {
                        graphNode3.removeChild(graphNode);
                        this.fireGraphNodeStateChanged(graphNode3);
                        continue;
                    }
                    if (graphNode3.hasParent(graphNode)) {
                        graphNode3.removeParent(graphNode);
                        this.fireGraphNodeStateChanged(graphNode3);
                        continue;
                    }
                    if (!graphNode3.hasSibling(graphNode)) continue;
                    graphNode3.removeSibling(graphNode);
                    this.fireGraphNodeStateChanged(graphNode3);
                }
                this.fireGraphNodeRemoved(graphNode);
                break;
            }
            case 1: {
                GraphNode graphNode = (GraphNode)this.nodeTable.get(string);
                graphNode.initialize();
                graphNode.setUserObject(agentDescription);
                Acquaintance[] acquaintanceArray = agentDescription.getAcquaintances();
                block15: for (int i = 0; i < acquaintanceArray.length; ++i) {
                    GraphNode graphNode4 = (GraphNode)this.nodeTable.get(acquaintanceArray[i].getName());
                    if (graphNode4 == null) continue;
                    String string3 = acquaintanceArray[i].getRelation();
                    int n = Misc.whichPosition(string3, AcquaintanceModel.RELATIONS_LIST);
                    switch (n) {
                        case 0: {
                            graphNode4.addChild(graphNode);
                            graphNode.addParent(graphNode4);
                            this.fireGraphNodeStateChanged(graphNode4);
                            continue block15;
                        }
                        case 1: {
                            graphNode.addChild(graphNode4);
                            graphNode4.addParent(graphNode);
                            this.fireGraphNodeStateChanged(graphNode4);
                            continue block15;
                        }
                        default: {
                            graphNode.addSibling(graphNode4);
                            graphNode4.addSibling(graphNode);
                            this.fireGraphNodeStateChanged(graphNode4);
                        }
                    }
                }
                this.fireGraphNodeStateChanged(graphNode);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SocietyModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SocietyModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? SocietyModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

