/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import zeus.concepts.AbstractTask;
import zeus.concepts.AgentDescription;
import zeus.concepts.OntologyDb;
import zeus.concepts.Parser;
import zeus.generator.GeneratorModel;
import zeus.generator.code.AgentInfo;
import zeus.generator.code.DbProxyInfo;
import zeus.generator.code.FacilitatorInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.NameserverInfo;
import zeus.generator.code.TaskInfo;
import zeus.generator.code.VisualiserInfo;
import zeus.util.Assert;
import zeus.util.Misc;
import zeus.util.PrettyPrintWriter;
import zeus.util.SystemProps;

public class FileHandler {
    static final String BEGIN_GENERATOR = "BEGIN_GENERATOR";
    static final String BEGIN_PREAMBLE = "BEGIN_PREAMBLE";
    static final String SYSTEM = ":system";
    static final String SYSTEM_NAME = "ZEUS-Agent-Generator";
    static final String VERSION = ":version";
    static final String ONTOLOGY = ":ontology";
    static final String END_PREAMBLE = "END_PREAMBLE";
    static final String BEGIN_AGENT_NAME_INDEX = "BEGIN_AGENT_NAME_INDEX";
    static final String END_AGENT_NAME_INDEX = "END_AGENT_NAME_INDEX";
    static final String BEGIN_AGENT_ICON_INDEX = "BEGIN_AGENT_ICON_INDEX";
    static final String END_AGENT_ICON_INDEX = "END_AGENT_ICON_INDEX";
    static final String BEGIN_TASK_NAME_INDEX = "BEGIN_TASK_NAME_INDEX";
    static final String END_TASK_NAME_INDEX = "END_TASK_NAME_INDEX";
    static final String BEGIN_AGENT_LIST = "BEGIN_AGENT_LIST";
    static final String END_AGENT_LIST = "END_AGENT_LIST";
    static final String BEGIN_TASK_LIST = "BEGIN_TASK_LIST";
    static final String END_TASK_LIST = "END_TASK_LIST";
    static final String BEGIN_GENERATION_PLAN = "BEGIN_GENERATION_PLAN";
    static final String END_GENERATION_PLAN = "END_GENERATION_PLAN";
    static final String END_GENERATOR = "END_GENERATOR";
    static final String PLATFORM = ":platform";
    static final String DIRECTORY = ":directory";
    static final String BEGIN_NAMESERVER_LIST = "BEGIN_NAMESERVER_LIST";
    static final String END_NAMESERVER_LIST = "END_NAMESERVER_LIST";
    static final String BEGIN_FACILITATOR_LIST = "BEGIN_FACILITATOR_LIST";
    static final String END_FACILITATOR_LIST = "END_FACILITATOR_LIST";
    static final String BEGIN_VISUALISER_LIST = "BEGIN_VISUALISER_LIST";
    static final String END_VISUALISER_LIST = "END_VISUALISER_LIST";
    static final String BEGIN_DBPROXY_LIST = "BEGIN_DBPROXY_LIST";
    static final String END_DBPROXY_LIST = "END_DBPROXY_LIST";
    protected static final String TFILE = "___file";
    protected int count = 0;
    public static final int WARNING_MASK = 1;
    public static final int ERROR_MASK = 2;
    protected String error = null;
    protected String warning = null;
    protected GeneratorModel genmodel;
    protected GenerationPlan genplan;
    protected OntologyDb ontology;

    public FileHandler(OntologyDb ontologyDb, GeneratorModel generatorModel, GenerationPlan generationPlan) {
        this.genmodel = generatorModel;
        this.genplan = generationPlan;
        this.ontology = ontologyDb;
    }

    public int saveFile(File file) {
        this.error = null;
        this.warning = null;
        int n = 0;
        int n2 = 0;
        String string = file.getParent();
        String string2 = string != null ? string + File.separator + TFILE : TFILE;
        File file2 = new File(string2);
        char c = File.separatorChar;
        char c2 = SystemProps.getProperty("file.separator").charAt(0);
        String string3 = this.ontology.getFilename();
        string3 = Misc.relativePath(string, string3);
        string3 = string3.replace(c, c2);
        String string4 = this.genplan.getDirectory();
        string4 = Misc.relativePath(string, string4);
        string4 = string4.replace(c, c2);
        while (file2.exists()) {
            file2 = new File(string2 + n2++);
        }
        try {
            DbProxyInfo[] dbProxyInfoArray;
            VisualiserInfo[] visualiserInfoArray;
            FacilitatorInfo[] facilitatorInfoArray;
            NameserverInfo[] nameserverInfoArray;
            TaskInfo[] taskInfoArray;
            int n3;
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter(file2);
            prettyPrintWriter.pprint(0, BEGIN_GENERATOR);
            prettyPrintWriter.pprint(1, BEGIN_PREAMBLE);
            prettyPrintWriter.pprint(2, ":system \"ZEUS-Agent-Generator\"");
            prettyPrintWriter.pprint(2, ":version \"" + SystemProps.getProperty("version.id") + "\"");
            prettyPrintWriter.pprint(2, ":ontology \"" + Misc.escape(string3) + "\"");
            prettyPrintWriter.pprint(1, END_PREAMBLE);
            prettyPrintWriter.println();
            prettyPrintWriter.pprint(1, BEGIN_AGENT_NAME_INDEX);
            String[] stringArray = this.genmodel.getAgentIds();
            String[] stringArray2 = this.genmodel.getAgentNames();
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                prettyPrintWriter.pprint(2, stringArray[n3] + " " + stringArray2[n3]);
            }
            prettyPrintWriter.pprint(1, END_AGENT_NAME_INDEX);
            prettyPrintWriter.println();
            prettyPrintWriter.pprint(1, BEGIN_AGENT_ICON_INDEX);
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                String string5 = this.genmodel.getAgentIcon(stringArray[n3]);
                string5 = Misc.relativePath(string, string5);
                string5 = string5.replace(c, c2);
                prettyPrintWriter.pprint(2, stringArray[n3] + " \"" + Misc.escape(string5) + "\"");
            }
            prettyPrintWriter.pprint(1, END_AGENT_ICON_INDEX);
            prettyPrintWriter.println();
            prettyPrintWriter.pprint(1, BEGIN_TASK_NAME_INDEX);
            stringArray = this.genmodel.getTaskIds();
            stringArray2 = this.genmodel.getTaskNames();
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                prettyPrintWriter.pprint(2, stringArray[n3] + " " + stringArray2[n3]);
            }
            prettyPrintWriter.pprint(1, END_TASK_NAME_INDEX);
            prettyPrintWriter.println();
            prettyPrintWriter.pprint(1, BEGIN_AGENT_LIST);
            AgentDescription[] agentDescriptionArray = this.genmodel.getAgents();
            for (int i = 0; i < agentDescriptionArray.length; ++i) {
                prettyPrintWriter.println(agentDescriptionArray[i].pprint(4));
            }
            prettyPrintWriter.pprint(1, END_AGENT_LIST);
            prettyPrintWriter.println();
            prettyPrintWriter.pprint(1, BEGIN_TASK_LIST);
            AbstractTask[] abstractTaskArray = this.genmodel.getTasks();
            for (int i = 0; i < abstractTaskArray.length; ++i) {
                prettyPrintWriter.println(abstractTaskArray[i].pprint(4));
            }
            prettyPrintWriter.pprint(1, END_TASK_LIST);
            prettyPrintWriter.println();
            prettyPrintWriter.pprint(1, BEGIN_GENERATION_PLAN);
            prettyPrintWriter.pprint(2, BEGIN_PREAMBLE);
            prettyPrintWriter.pprint(3, ":platform \"" + this.genplan.getPlatform() + "\"");
            prettyPrintWriter.pprint(3, ":directory \"" + Misc.escape(string4) + "\"");
            prettyPrintWriter.pprint(2, END_PREAMBLE);
            AgentInfo[] agentInfoArray = this.genplan.getAgents();
            if (agentInfoArray.length > 0) {
                prettyPrintWriter.pprint(2, BEGIN_AGENT_LIST);
                for (int i = 0; i < agentInfoArray.length; ++i) {
                    prettyPrintWriter.println(agentInfoArray[i].pprint(6));
                }
                prettyPrintWriter.pprint(2, END_AGENT_LIST);
            }
            if ((taskInfoArray = this.genplan.getTasks()).length > 0) {
                prettyPrintWriter.pprint(2, BEGIN_TASK_LIST);
                for (int i = 0; i < taskInfoArray.length; ++i) {
                    prettyPrintWriter.println(taskInfoArray[i].pprint(6));
                }
                prettyPrintWriter.pprint(2, END_TASK_LIST);
            }
            if ((nameserverInfoArray = this.genplan.getNameservers()).length > 0) {
                prettyPrintWriter.pprint(2, BEGIN_NAMESERVER_LIST);
                for (int i = 0; i < nameserverInfoArray.length; ++i) {
                    prettyPrintWriter.println(nameserverInfoArray[i].pprint(6));
                }
                prettyPrintWriter.pprint(2, END_NAMESERVER_LIST);
            }
            if ((facilitatorInfoArray = this.genplan.getFacilitators()).length > 0) {
                prettyPrintWriter.pprint(2, BEGIN_FACILITATOR_LIST);
                for (int i = 0; i < facilitatorInfoArray.length; ++i) {
                    prettyPrintWriter.println(facilitatorInfoArray[i].pprint(6));
                }
                prettyPrintWriter.pprint(2, END_FACILITATOR_LIST);
            }
            if ((visualiserInfoArray = this.genplan.getVisualisers()).length > 0) {
                prettyPrintWriter.pprint(2, BEGIN_VISUALISER_LIST);
                for (int i = 0; i < visualiserInfoArray.length; ++i) {
                    prettyPrintWriter.println(visualiserInfoArray[i].pprint(6));
                }
                prettyPrintWriter.pprint(2, END_VISUALISER_LIST);
            }
            if ((dbProxyInfoArray = this.genplan.getDbProxys()).length > 0) {
                prettyPrintWriter.pprint(2, BEGIN_DBPROXY_LIST);
                for (int i = 0; i < dbProxyInfoArray.length; ++i) {
                    prettyPrintWriter.println(dbProxyInfoArray[i].pprint(6));
                }
                prettyPrintWriter.pprint(2, END_DBPROXY_LIST);
            }
            prettyPrintWriter.pprint(1, END_GENERATION_PLAN);
            prettyPrintWriter.pprint(0, END_GENERATOR);
            prettyPrintWriter.flush();
            prettyPrintWriter.close();
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
        }
        catch (Exception exception) {
            this.error = exception.toString();
            n |= 2;
        }
        return n;
    }

    public int openFile(File file) {
        Assert.notNull(file);
        int n = 0;
        this.genplan.purge();
        try {
            Parser parser = new Parser(new FileInputStream(file));
            String string = null;
            try {
                string = file.getParentFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getParentFile().getAbsolutePath();
            }
            parser.generator(this, this.genmodel, this.genplan, this.ontology, string);
        }
        catch (Exception exception) {
            this.genmodel.clear();
            this.genplan.reset();
            this.ontology.clear();
            this.error = exception.toString();
            n |= 2;
        }
        if (this.warning != null) {
            n |= 1;
        }
        return n;
    }

    public void __setWarning(String string) {
        this.warning = this.warning == null ? string : this.warning + "\n" + string;
    }

    public void __setError(String string) {
        this.error = this.error == null ? string : this.error + "\n" + string;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getError() {
        return this.error;
    }
}

