/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import zeus.generator.GeneratorModel;

public class AgentTableModel
extends AbstractTableModel
implements ChangeListener {
    static final int AGENT = 0;
    static final int TASK = 1;
    static final int ID = 2;
    protected String[] columnNames = new String[]{"Agent", "Tasks"};
    protected Object[][] data = null;
    protected boolean isEditable = false;
    protected GeneratorModel genmodel;

    public AgentTableModel(GeneratorModel generatorModel) {
        this.genmodel = generatorModel;
        generatorModel.addChangeListener(this);
        this.data = generatorModel.getAgentData();
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.isEditable;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                if (object == null || object.equals("")) {
                    return;
                }
                if (this.data[n][0].equals((String)object)) {
                    return;
                }
                this.genmodel.renameAgent((String)this.data[n][2], (String)object);
                break;
            }
            case 1: {
                if (this.data[n][1].equals((String[])object)) {
                    return;
                }
                this.genmodel.modifyAgentTasks((String)this.data[n][2], (String[])object);
            }
        }
    }

    public void addNewRow() {
        this.genmodel.createNewAgent();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.data.length;
        this.data = this.genmodel.getAgentData();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        this.fireTableDataChanged();
    }
}

