/*
 * Decompiled with CFR 0.152.
 */
package zeus.ext;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import zeus.agents.PersistentStore;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.util.HSet;
import zeus.util.Misc;

public class FlatFile
extends PersistentStore {
    protected Hashtable ht = new Hashtable();
    String fsep = System.getProperty("file.separator");
    String ROOT = System.getProperty("user.dir") + this.fsep + "dbs" + this.fsep;
    String NEWLINE = System.getProperty("line.separator");
    String NEWRECORD = this.NEWLINE + "_:RECORD";
    String RECORD_TAG = "_:RECORD";
    String PREFIX = "ps_";

    public void createSession(String string, String string2, String string3, String string4, String string5) {
        Performative performative;
        try {
            String string6 = this.isAccessible() ? this.ROOT + string3 : this.ROOT + this.PREFIX + string2 + this.fsep + string3;
            File file = new File(string6);
            if (!file.exists() && !file.mkdirs()) {
                throw new SecurityException("Couldn't create sessionType");
            }
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            File file2 = new File(string6 + this.fsep + string4);
            if (file2.exists()) {
                performative.setContent(string3 + " created by " + string2 + " already exists... appending.");
            } else {
                performative.setContent("done");
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
            this.ht.put(string5, randomAccessFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " couldn't create " + string4);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent("Access to create denied by security manager");
        }
        this.proxy.sendMsg(performative);
    }

    public void deleteSession(String string, String string2, String string3, String string4) {
        Performative performative = null;
        String string5 = this.isAccessible() ? this.ROOT + string3 + this.fsep + string4 : this.ROOT + this.PREFIX + string2 + this.fsep + string3 + this.fsep + string4;
        File file = new File(string5);
        try {
            if (file.exists()) {
                if (!file.delete()) {
                    throw new IOException("Delete failed. Close session" + string4);
                }
                performative = new Performative("inform");
                performative.setReceiver(string2);
                performative.setInReplyTo(string);
                performative.setContent("done");
            } else {
                performative = new Performative("failure");
                performative.setReceiver(string2);
                performative.setInReplyTo(string);
                performative.setContent(string4 + " doesn't exist, delete failed");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.proxy.sendMsg(performative);
    }

    public void countRecords(String string, String string2, String string3) {
        int n = 0;
        long l = 0L;
        Performative performative = null;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            l = randomAccessFile.getFilePointer();
            if (randomAccessFile == null) {
                throw new IOException("Error counting records with access " + string3);
            }
            n = this.getCountUpTo(randomAccessFile, randomAccessFile.length());
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setContent(Integer.toString(n));
            performative.setInReplyTo(string);
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setContent("-1");
            performative.setInReplyTo(string);
        }
        this.proxy.sendMsg(performative);
    }

    private int getCountUpTo(RandomAccessFile randomAccessFile, long l) {
        int n = 0;
        try {
            randomAccessFile.seek(0L);
            while (randomAccessFile.getFilePointer() < l) {
                String string = randomAccessFile.readLine();
                if (!string.equals(this.RECORD_TAG)) continue;
                ++n;
            }
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public void getAllSessions(String string, String string2, String string3) {
        String string4 = "";
        String string5 = this.isAccessible() ? this.ROOT + string3 : this.ROOT + this.PREFIX + string2 + this.fsep + string3;
        File file = new File(string5);
        if (!file.exists()) {
            System.out.println("Session type doesn't exist");
            Performative performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setContent("Session type doesn't exist");
            performative.setInReplyTo(string);
            this.proxy.sendMsg(performative);
            return;
        }
        Object[] objectArray = file.list();
        Performative performative = new Performative("inform");
        performative.setReceiver(string2);
        performative.setContent(Misc.concat(objectArray));
        performative.setInReplyTo(string);
        this.proxy.sendMsg(performative);
    }

    public void deleteSessionType(String string, String string2, String string3) {
        Performative performative;
        String string4 = this.isAccessible() ? this.ROOT + string3 : this.ROOT + this.PREFIX + string2 + this.fsep + string3;
        File file = new File(string4);
        if (!file.exists()) {
            System.out.println("Session type doesn't exist");
            Performative performative2 = new Performative("failure");
            performative2.setReceiver(string2);
            performative2.setContent("Session type doesn't exist: delete failed.");
            performative2.setInReplyTo(string);
            this.proxy.sendMsg(performative2);
            return;
        }
        try {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string4 + this.fsep + stringArray[i]);
                if (!file2.exists() || file2.delete()) continue;
                throw new IOException("Delete Failed close all sessions");
            }
            if (!file.delete()) {
                throw new IOException("Delete Failed close all sessions");
            }
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setContent("done");
            performative.setInReplyTo(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setContent("Error purging " + string3);
            performative.setInReplyTo(string);
        }
        this.proxy.sendMsg(performative);
    }

    public void openSession(String string, String string2, String string3, String string4, String string5) {
        Performative performative;
        if (this.ht.contains(string5)) {
            Performative performative2 = new Performative("failure");
            performative2.setReceiver(string2);
            performative2.setInReplyTo(string);
            performative2.setContent(string4 + " already opened");
            this.proxy.sendMsg(performative2);
            return;
        }
        try {
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            String string6 = this.isAccessible() ? this.ROOT + string3 + this.fsep + string4 : this.ROOT + this.PREFIX + string2 + this.fsep + string3 + this.fsep + string4;
            File file = new File(string6);
            if (!file.exists()) {
                throw new IOException(string4 + " doesn't exist");
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.ht.put(string5, randomAccessFile);
            performative.setContent("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " couldn't open " + string4);
        }
        this.proxy.sendMsg(performative);
    }

    public void saveRecord(String string, String string2, String string3, String string4) {
        Performative performative;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            randomAccessFile.seek(randomAccessFile.length());
            if (randomAccessFile.getFilePointer() != 0L) {
                randomAccessFile.writeBytes(this.NEWLINE);
            }
            randomAccessFile.writeBytes(this.RECORD_TAG);
            randomAccessFile.writeBytes(this.NEWLINE);
            randomAccessFile.writeBytes(string4);
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " couldn't save " + string4);
        }
        this.proxy.sendMsg(performative);
    }

    public void closeSession(String string, String string2, String string3) {
        Performative performative;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            randomAccessFile.close();
            this.ht.remove(string3);
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " couldn't close  with accesskey:" + string3);
        }
        this.proxy.sendMsg(performative);
    }

    public void nextRecord(String string, String string2, String string3) {
        Performative performative;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            String string4 = this.readRecord(randomAccessFile);
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " couldn't read next record  with accesskey:" + string3);
        }
        this.proxy.sendMsg(performative);
    }

    public void priorRecord(String string, String string2, String string3) {
        Performative performative;
        String string4 = "";
        try {
            int n;
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            int n2 = this.getCountUpTo(randomAccessFile, randomAccessFile.getFilePointer());
            randomAccessFile.seek(0L);
            for (n = 0; n < n2; ++n) {
                string4 = this.readRecord(randomAccessFile);
            }
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string4);
            randomAccessFile.seek(0L);
            for (n = 0; n < n2 - 1; ++n) {
                this.readRecord(randomAccessFile);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " couldn't locate prior record  with accesskey:" + string3);
        }
        this.proxy.sendMsg(performative);
    }

    public void beginSession(String string, String string2, String string3) {
        Performative performative;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            randomAccessFile.seek(0L);
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " can't move to first record  with accesskey:" + string3);
        }
        this.proxy.sendMsg(performative);
    }

    public void endSession(String string, String string2, String string3) {
        Performative performative;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            randomAccessFile.seek(randomAccessFile.length());
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + " can't move to last record  with accesskey:" + string3);
        }
        this.proxy.sendMsg(performative);
    }

    public void getAgents(String string, String string2, String string3) {
        Performative performative;
        HSet hSet = new HSet();
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.ht.get(string3);
            if (randomAccessFile == null) {
                throw new IOException("Error file pointer doesn't exist.");
            }
            long l = randomAccessFile.getFilePointer();
            int n = this.getCountUpTo(randomAccessFile, randomAccessFile.length());
            randomAccessFile.seek(0L);
            for (int i = 0; i < n; ++i) {
                String string4 = this.readRecord(randomAccessFile);
                Performative performative2 = ZeusParser.performative(string4);
                hSet.add(performative2.getSender());
                hSet.add(performative2.getReceiver());
            }
            performative = new Performative("inform");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(Misc.concat(hSet));
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            performative = new Performative("failure");
            performative.setReceiver(string2);
            performative.setInReplyTo(string);
            performative.setContent(string2 + ": error lisitng agents with accesskey:" + string3);
        }
        this.proxy.sendMsg(performative);
    }

    private String readRecord(RandomAccessFile randomAccessFile) {
        String string = "";
        boolean bl = false;
        try {
            while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
                String string2 = randomAccessFile.readLine();
                if (string2.equals(this.RECORD_TAG)) {
                    if (bl = !bl) continue;
                    break;
                }
                if (!bl) continue;
                string = string + string2;
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() - (long)this.NEWRECORD.length());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }
}

