/*
 * Decompiled with CFR 0.152.
 */
package zeus.ext;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DbConnector
implements Serializable {
    protected Connection dbConn = null;
    protected String username = null;
    protected String password = null;
    protected String JDBCdriverName = null;
    protected String JDBCconnectionName = null;

    public DbConnector(String string, String string2, String string3, String string4) {
        this.username = string;
        this.password = string2;
        this.JDBCdriverName = string3;
        this.JDBCconnectionName = string4;
    }

    public boolean connect() throws SQLException {
        try {
            Properties properties = new Properties();
            if (this.username != null) {
                properties.put("user", this.username);
            }
            if (this.password != null) {
                properties.put("password", this.password);
            }
            if (this.JDBCdriverName == null || this.JDBCconnectionName == null) {
                throw new SQLException("JDBC connection attempted without driver and connection being specified");
            }
            Class.forName(this.JDBCdriverName).newInstance();
            this.dbConn = DriverManager.getConnection(this.JDBCconnectionName, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("Cannot create database driver... exiting");
        }
        return true;
    }

    public Connection getConnection() throws SQLException {
        if (this.dbConn == null || this.dbConn.isClosed()) {
            this.connect();
        }
        return this.dbConn;
    }

    public Statement getStatement() throws SQLException {
        if (this.dbConn == null || this.dbConn.isClosed()) {
            this.connect();
        }
        return this.dbConn.createStatement();
    }

    public boolean activeConnection() throws SQLException {
        return this.dbConn != null && !this.dbConn.isClosed();
    }

    public void close() {
        try {
            if (this.dbConn != null && !this.dbConn.isClosed()) {
                this.dbConn.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQL exception thrown while trying to close a db connection");
        }
    }

    public ResultSet sqlQuery(String string) throws SQLException {
        if (!this.activeConnection()) {
            this.connect();
        }
        Statement statement = this.dbConn.createStatement();
        return statement.executeQuery(string);
    }

    public void sqlCommand(String string) throws SQLException {
        if (!this.activeConnection()) {
            this.connect();
        }
        Statement statement = this.dbConn.createStatement();
        statement.execute(string);
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting DbTest");
        DbConnector dbConnector = new DbConnector("database", "tiger", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@(description=(address=(host=tb-toledo)(protocol=tcp)(port=1521))(connect_data=(sid=visitor)))");
        try {
            ResultSet resultSet = dbConnector.sqlQuery("select count(*) from table1");
            while (resultSet.next()) {
                int n = resultSet.getInt("count(*)");
                System.out.println("result = " + n);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Ooops: " + sQLException);
        }
    }
}

