/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.StringTokenizer;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Core;
import zeus.util.Misc;

public class VectorFn
extends ValueFunction {
    protected Object args = null;
    static final String[] METHOD_LIST = new String[]{"elementAt", "1", "setElementAt", "2", "insertElementAt", "2", "addElement", "1", "removeElement", "1", "removeElementAt", "1", "removeAllElements", "0", "containsElement", "1", "isEmpty", "0", "size", "0", "firstElement", "0", "lastElement", "0", "union", "1", "intersection", "1", "difference", "1"};
    static final int ELEMENT_AT = 0;
    static final int SET_ELEMENT_AT = 2;
    static final int INSERT_ELEMENT_AT = 4;
    static final int ADD_ELEMENT = 6;
    static final int REMOVE_ELEMENT = 8;
    static final int REMOVE_ELEMENT_AT = 10;
    static final int REMOVE_ALL_ELEMENTS = 12;
    static final int CONTAINS_ELEMENT = 14;
    static final int IS_EMPTY = 16;
    static final int SIZE = 18;
    static final int FIRST_ELEMENT = 20;
    static final int LAST_ELEMENT = 22;
    static final int UNION = 24;
    static final int INTERSECTION = 26;
    static final int DIFFERENCE = 28;

    public VectorFn(Vector vector) {
        super(23, 10);
        this.args = vector;
    }

    public ValueFunction mirror() {
        Vector vector = (Vector)this.args;
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.mirror();
            vector2.addElement(valueFunction);
        }
        return new VectorFn(vector2);
    }

    public String toString() {
        String string = "{";
        Vector vector = (Vector)this.args;
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            string = string + valueFunction;
            if (i + 1 >= vector.size()) continue;
            string = string + ",";
        }
        string = string + "}";
        return string;
    }

    ValueFunction simplify() {
        Vector vector = (Vector)this.args;
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.simplify();
            vector2.addElement(valueFunction);
        }
        return new VectorFn(vector2);
    }

    Object getArg(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.args;
    }

    public boolean references(ValueFunction valueFunction) {
        Vector vector = (Vector)this.args;
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction2 = (ValueFunction)vector.elementAt(i);
            if (!valueFunction2.references(valueFunction)) continue;
            return true;
        }
        return false;
    }

    public Vector variables() {
        Vector vector = (Vector)this.args;
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            vector2 = Misc.union(vector2, valueFunction.variables());
        }
        return vector2;
    }

    public boolean isDeterminate() {
        Vector vector = (Vector)this.args;
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            if (valueFunction.isDeterminate()) continue;
            return false;
        }
        return true;
    }

    ValueFunction normalize() {
        Vector vector = (Vector)this.args;
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.normalize();
            vector2.addElement(valueFunction);
        }
        return new VectorFn(vector2);
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        Vector vector = (Vector)this.args;
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.resolve(resolutionContext, bindings);
            vector2.addElement(valueFunction);
        }
        VectorFn vectorFn = new VectorFn(vector2);
        return vectorFn.evaluationFn();
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        Vector vector = (Vector)this.args;
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.duplicate(duplicationTable);
            vector2.addElement(valueFunction);
        }
        return new VectorFn(vector2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof VectorFn)) {
            return false;
        }
        VectorFn vectorFn = (VectorFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = vectorFn.simplify();
        return Misc.sameVector((Vector)valueFunction.getArg(0), (Vector)valueFunction2.getArg(0));
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        switch (valueFunction.getID()) {
            case 23: {
                Vector vector = (Vector)this.getArg();
                Vector vector2 = (Vector)valueFunction.getArg();
                if (vector.size() != vector2.size()) {
                    return null;
                }
                Bindings bindings2 = new Bindings(bindings);
                Vector<ValueFunction> vector3 = new Vector<ValueFunction>();
                for (int i = 0; i < vector.size(); ++i) {
                    ValueFunction valueFunction2;
                    ValueFunction valueFunction3 = (ValueFunction)vector.elementAt(i);
                    ValueFunction valueFunction4 = valueFunction3.unifiesWith(valueFunction2 = (ValueFunction)vector2.elementAt(i), bindings2);
                    if (valueFunction4 == null) {
                        return null;
                    }
                    vector3.addElement(valueFunction4);
                }
                bindings.add(bindings2);
                return new VectorFn(vector3);
            }
        }
        throw new IllegalArgumentException("Unification type clash between '" + this + "' and '" + valueFunction + "'");
    }

    ValueFunction invokeMethod(String string, Vector vector) {
        int n = Misc.whichPosition(string, METHOD_LIST);
        if (n == -1) {
            return super.invokeMethod(string, vector);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(METHOD_LIST[n + 1], ",");
        boolean bl = false;
        int n2 = -1;
        while (!bl && stringTokenizer.hasMoreTokens()) {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            bl = vector.size() == n2;
        }
        if (!bl) {
            throw new IllegalArgumentException("Wrong number of arguments in method VectorFn.'" + string + "/" + n2 + "' --> " + this);
        }
        try {
            Vector vector2 = (Vector)this.args;
            switch (n) {
                case 0: {
                    IntFn intFn = (IntFn)vector.elementAt(0);
                    return (ValueFunction)vector2.elementAt(intFn.intValue());
                }
                case 2: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    IntFn intFn = (IntFn)vector.elementAt(1);
                    vector2.setElementAt(valueFunction, intFn.intValue());
                    return BoolFn.trueFn;
                }
                case 4: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    IntFn intFn = (IntFn)vector.elementAt(1);
                    vector2.insertElementAt(valueFunction, intFn.intValue());
                    return BoolFn.trueFn;
                }
                case 6: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    vector2.addElement(valueFunction);
                    return BoolFn.trueFn;
                }
                case 8: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    return BoolFn.newBoolFn(vector2.removeElement(valueFunction));
                }
                case 10: {
                    IntFn intFn = (IntFn)vector.elementAt(0);
                    ValueFunction valueFunction = (ValueFunction)vector2.elementAt(intFn.intValue());
                    vector2.removeElementAt(intFn.intValue());
                    return valueFunction;
                }
                case 12: {
                    vector2.removeAllElements();
                    return BoolFn.trueFn;
                }
                case 14: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    return BoolFn.newBoolFn(vector2.contains(valueFunction));
                }
                case 16: {
                    return BoolFn.newBoolFn(vector2.isEmpty());
                }
                case 18: {
                    return new IntFn(vector2.size());
                }
                case 20: {
                    return (ValueFunction)vector2.firstElement();
                }
                case 22: {
                    return (ValueFunction)vector2.lastElement();
                }
                case 24: {
                    VectorFn vectorFn = (VectorFn)vector.elementAt(0);
                    Vector vector3 = (Vector)vectorFn.getArg();
                    return new VectorFn(Misc.union(vector2, vector3));
                }
                case 26: {
                    VectorFn vectorFn = (VectorFn)vector.elementAt(0);
                    Vector vector4 = (Vector)vectorFn.getArg();
                    return new VectorFn(Misc.intersection(vector2, vector4));
                }
                case 28: {
                    VectorFn vectorFn = (VectorFn)vector.elementAt(0);
                    Vector vector5 = (Vector)vectorFn.getArg();
                    return new VectorFn(Misc.difference(vector2, vector5));
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Type mismatch in method '" + this + '.' + string + "(...)'");
        }
        Core.ERROR(null, 1, (Object)this);
        return null;
    }
}

