/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Assert;
import zeus.util.Misc;

public class LogicalOrFn
extends LogicalFn {
    protected ValueFunction[] args = new ValueFunction[2];
    static final String[] legal_operands = new String[]{"zeus.concepts.fn.DefinedFn", "zeus.concepts.fn.MethodCallFn"};

    public LogicalOrFn(ValueFunction valueFunction, ValueFunction valueFunction2) throws IllegalArgumentException {
        super(10, 4);
        String string = valueFunction.getClass().getName();
        String string2 = valueFunction2.getClass().getName();
        if (!(valueFunction instanceof LogicalFn) && !Misc.member(string, legal_operands) || !(valueFunction2 instanceof LogicalFn) && !Misc.member(string2, legal_operands)) {
            throw new IllegalArgumentException("Illegal operand type in function  '" + valueFunction + " || " + valueFunction2 + "'");
        }
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
    }

    public ValueFunction mirror() {
        return new LogicalOrFn(this.args[0].mirror(), this.args[1].mirror());
    }

    public String toString() {
        return "(" + this.args[0] + " || " + this.args[1] + ")";
    }

    ValueFunction simplify() {
        ValueFunction valueFunction = this.args[0].simplify();
        ValueFunction valueFunction2 = this.args[1].simplify();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new LogicalOrFn(valueFunction, valueFunction2) : this;
    }

    Object getArg(int n) {
        Assert.notFalse(n >= 0 && n <= this.args.length);
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    ValueFunction normalize() {
        ValueFunction valueFunction = this.args[0].normalize();
        ValueFunction valueFunction2 = this.args[1].normalize();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new LogicalOrFn(valueFunction, valueFunction2) : this;
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.args[0].resolve(resolutionContext, bindings);
        ValueFunction valueFunction2 = this.args[1].resolve(resolutionContext, bindings);
        return new LogicalOrFn(valueFunction, valueFunction2).evaluationFn();
    }

    public int evaluate() {
        ValueFunction valueFunction = this.evaluationFn();
        if (valueFunction == this) {
            return 2;
        }
        if (valueFunction == BoolFn.trueFn) {
            return 0;
        }
        return 1;
    }

    public ValueFunction evaluationFn() {
        if (!this.isDeterminate()) {
            return this;
        }
        BoolFn boolFn = (BoolFn)this.args[0].evaluationFn();
        BoolFn boolFn2 = (BoolFn)this.args[1].evaluationFn();
        return boolFn.equals(BoolFn.trueFn) || boolFn2.equals(BoolFn.trueFn) ? BoolFn.trueFn : BoolFn.falseFn;
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new LogicalOrFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable));
    }

    public boolean equals(Object object) {
        if (!(object instanceof LogicalOrFn)) {
            return false;
        }
        LogicalOrFn logicalOrFn = (LogicalOrFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = logicalOrFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }
}

