/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class LogicalNotFn
extends LogicalFn {
    protected ValueFunction arg;
    static final String[] legal_operands = new String[]{"zeus.concepts.fn.DefinedFn", "zeus.concepts.fn.MethodCallFn"};

    public LogicalNotFn(ValueFunction valueFunction) throws IllegalArgumentException {
        super(12, 4);
        String string = valueFunction.getClass().getName();
        if (!(valueFunction instanceof LogicalFn) && !Misc.member(string, legal_operands)) {
            throw new IllegalArgumentException("Illegal operand type in '" + valueFunction + "'");
        }
        this.arg = valueFunction;
    }

    public ValueFunction mirror() {
        return new LogicalNotFn(this.arg);
    }

    public String toString() {
        return "!" + this.arg;
    }

    ValueFunction simplify() {
        ValueFunction valueFunction = this.arg.simplify();
        return valueFunction != this.arg ? new LogicalNotFn(valueFunction) : this;
    }

    Object getArg(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.arg;
    }

    public boolean references(ValueFunction valueFunction) {
        return this.arg.references(valueFunction);
    }

    public Vector variables() {
        return this.arg.variables();
    }

    public boolean isDeterminate() {
        return this.arg.isDeterminate();
    }

    ValueFunction normalize() {
        ValueFunction valueFunction = this.arg.normalize();
        return valueFunction != this.arg ? new LogicalNotFn(valueFunction) : this;
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.arg.resolve(resolutionContext, bindings);
        return new LogicalNotFn(valueFunction).evaluationFn();
    }

    public int evaluate() {
        ValueFunction valueFunction = this.evaluationFn();
        if (valueFunction == this) {
            return 2;
        }
        if (valueFunction == BoolFn.trueFn) {
            return 0;
        }
        return 1;
    }

    public ValueFunction evaluationFn() {
        if (!this.isDeterminate()) {
            return this;
        }
        BoolFn boolFn = (BoolFn)this.arg.evaluationFn();
        return boolFn.equals(BoolFn.trueFn) ? BoolFn.falseFn : BoolFn.trueFn;
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new LogicalNotFn(this.arg.duplicate(duplicationTable));
    }

    public boolean equals(Object object) {
        if (!(object instanceof LogicalNotFn)) {
            return false;
        }
        LogicalNotFn logicalNotFn = (LogicalNotFn)object;
        LogicalNotFn logicalNotFn2 = (LogicalNotFn)this.simplify();
        LogicalNotFn logicalNotFn3 = (LogicalNotFn)logicalNotFn.simplify();
        return ((LogicalFn)logicalNotFn2.getArg()).equals((LogicalFn)logicalNotFn3.getArg());
    }
}

