/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class LogicalAndFn
extends LogicalFn {
    protected ValueFunction[] args = new ValueFunction[2];
    static final String[] legal_operands = new String[]{"zeus.concepts.fn.DefinedFn", "zeus.concepts.fn.MethodCallFn"};

    public LogicalAndFn(ValueFunction valueFunction, ValueFunction valueFunction2) throws IllegalArgumentException {
        super(11, 4);
        String string = valueFunction.getClass().getName();
        String string2 = valueFunction2.getClass().getName();
        if (!(valueFunction instanceof LogicalFn) && !Misc.member(string, legal_operands) || !(valueFunction2 instanceof LogicalFn) && !Misc.member(string2, legal_operands)) {
            throw new IllegalArgumentException("Illegal operand type in function  '" + valueFunction + " && " + valueFunction2 + "'");
        }
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
    }

    public String toString() {
        return "(" + this.args[0] + " && " + this.args[1] + ")";
    }

    public ValueFunction mirror() {
        return new LogicalAndFn(this.args[0].mirror(), this.args[1].mirror());
    }

    ValueFunction simplify() {
        ValueFunction valueFunction = this.args[0].simplify();
        ValueFunction valueFunction2 = this.args[1].simplify();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new LogicalAndFn(valueFunction, valueFunction2) : this;
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    ValueFunction normalize() {
        ValueFunction valueFunction = this.args[0].normalize();
        ValueFunction valueFunction2 = this.args[1].normalize();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new LogicalAndFn(valueFunction, valueFunction2) : this;
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.args[0].resolve(resolutionContext, bindings);
        ValueFunction valueFunction2 = this.args[1].resolve(resolutionContext, bindings);
        return new LogicalAndFn(valueFunction, valueFunction2).evaluationFn();
    }

    public int evaluate() {
        ValueFunction valueFunction = this.evaluationFn();
        if (valueFunction == this) {
            return 2;
        }
        if (valueFunction == BoolFn.trueFn) {
            return 0;
        }
        return 1;
    }

    public ValueFunction evaluationFn() {
        BoolFn boolFn;
        if (!this.isDeterminate()) {
            return this;
        }
        BoolFn boolFn2 = (BoolFn)this.args[0].evaluationFn();
        return boolFn2.equals(boolFn = (BoolFn)this.args[1].evaluationFn()) ? BoolFn.trueFn : BoolFn.falseFn;
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new LogicalAndFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable));
    }

    public boolean equals(Object object) {
        if (!(object instanceof LogicalAndFn)) {
            return false;
        }
        LogicalAndFn logicalAndFn = (LogicalAndFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = logicalAndFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }
}

