/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.ElseFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class ImplyFn
extends ValueFunction {
    protected ValueFunction[] args = new ValueFunction[2];

    public ImplyFn(ValueFunction valueFunction, ValueFunction valueFunction2) {
        super(8, 2);
        if (!(valueFunction instanceof LogicalFn)) {
            throw new IllegalArgumentException("Illegal argument '" + valueFunction + "' in function '(if " + valueFunction + " then " + valueFunction2 + ")'");
        }
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
    }

    public String toString() {
        String string = "(if " + this.args[0] + " then " + this.args[1] + ")";
        return string;
    }

    ValueFunction simplify() {
        ValueFunction valueFunction = this.args[0].simplify();
        ValueFunction valueFunction2 = this.args[1].simplify();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new ImplyFn(valueFunction, valueFunction2) : this;
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    ValueFunction normalize() {
        return new ImplyFn(this.args[0].normalize(), this.args[1].normalize());
    }

    public ValueFunction mirror() {
        return new ImplyFn(this.args[0].mirror(), this.args[1].mirror());
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.args[0].resolve(resolutionContext, bindings);
        ValueFunction valueFunction2 = this.args[1].resolve(resolutionContext, bindings);
        return new ImplyFn(valueFunction, valueFunction2).evaluationFn();
    }

    public ValueFunction evaluationFn() {
        switch (((LogicalFn)this.args[0]).evaluate()) {
            case 0: {
                return this.args[1];
            }
            case 1: {
                return null;
            }
            case 2: {
                return this;
            }
        }
        return this;
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new ImplyFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImplyFn)) {
            return false;
        }
        ImplyFn implyFn = (ImplyFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = implyFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        ValueFunction valueFunction2 = null;
        ValueFunction valueFunction3 = null;
        valueFunction2 = this.evaluationFn();
        if (valueFunction2 == null) {
            return null;
        }
        if (valueFunction2 != this) {
            return valueFunction2.unifiesWith(valueFunction, bindings);
        }
        switch (valueFunction.getID()) {
            case 8: {
                valueFunction3 = ((ImplyFn)valueFunction).evaluationFn();
                if (valueFunction3 == null) {
                    return null;
                }
                if (valueFunction3 != valueFunction) {
                    return this.unifiesWith(valueFunction3, bindings);
                }
                valueFunction2 = this.args[1].unifiesWith(valueFunction, bindings);
                if (valueFunction2 == null) {
                    return null;
                }
                return new ImplyFn(this.args[0], valueFunction2);
            }
            case 9: {
                valueFunction3 = ((ElseFn)valueFunction).evaluationFn();
                if (valueFunction3 == null) {
                    return null;
                }
                if (valueFunction3 != valueFunction) {
                    return this.unifiesWith(valueFunction3, bindings);
                }
                valueFunction2 = this.args[1].unifiesWith(valueFunction, bindings);
                if (valueFunction2 == null) {
                    return null;
                }
                return new ImplyFn(this.args[0], valueFunction2);
            }
        }
        valueFunction2 = this.args[1].unifiesWith(valueFunction, bindings);
        if (valueFunction2 == null) {
            return null;
        }
        return new ImplyFn(this.args[0], valueFunction2);
    }

    public int baseID() {
        return this.args[1].baseID();
    }
}

