/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.AndFn;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.IdFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.PrimitiveNumericFn;
import zeus.concepts.fn.RealFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class DefinedFn
extends ValueFunction {
    static final int ABS = 0;
    static final int ACOS = 2;
    static final int ASIN = 4;
    static final int ATAN = 6;
    static final int ATAN2 = 8;
    static final int CEIL = 10;
    static final int COS = 12;
    static final int SIN = 14;
    static final int TAN = 16;
    static final int EXP = 18;
    static final int FLOOR = 20;
    static final int IEEE_REMAINDER = 22;
    static final int LOG = 24;
    static final int MAX = 26;
    static final int MIN = 28;
    static final int POW = 30;
    static final int RANDOM = 32;
    static final int RINT = 34;
    static final int ROUND = 36;
    static final int SQRT = 38;
    static final int TO_DEGREES = 40;
    static final int TO_RADIANS = 42;
    static final int CONCAT = 44;
    static final int NONVAR = 46;
    static final int VAR = 48;
    static final String[] FUNCTIONS = new String[]{"abs", "1", "acos", "1", "asin", "1", "atan", "1", "atan2", "2", "ceil", "1", "cos", "1", "sin", "1", "tan", "1", "exp", "1", "floor", "1", "IEEEremainder", "2", "log", "1", "max", "2", "min", "2", "pow", "2", "random", "0", "rint", "1", "round", "1", "sqrt", "1", "toDegrees", "1", "toRadians", "1", "concat", "2", "nonvar", "1", "var", "1"};
    protected Object[] args = new Object[2];

    public DefinedFn(String string, Vector vector) {
        super(21, 3);
        this.args[0] = string;
        this.args[1] = vector;
        int n = -1;
        n = Misc.whichPosition(string, FUNCTIONS);
        if (n == -1 || n % 2 != 0) {
            throw new IllegalArgumentException("Unknown function " + string + " in expression.");
        }
        int n2 = Integer.parseInt(FUNCTIONS[n + 1]);
        if (vector == null || vector.size() != n2) {
            throw new IllegalArgumentException("Wrong number of arguments used in function " + string + "/" + n2 + ".");
        }
    }

    public ValueFunction mirror() {
        Vector vector = (Vector)this.args[1];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.mirror();
            vector2.addElement(valueFunction);
        }
        return new DefinedFn((String)this.args[0], vector2);
    }

    public String toString() {
        String string = (String)this.args[0] + "(";
        Vector vector = (Vector)this.args[1];
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            string = string + valueFunction;
            if (i + 1 >= vector.size()) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    ValueFunction simplify() {
        Vector vector = (Vector)this.args[1];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.simplify();
            vector2.addElement(valueFunction);
        }
        return new DefinedFn((String)this.args[0], vector2);
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        Vector vector = (Vector)this.args[1];
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction2 = (ValueFunction)vector.elementAt(i);
            if (!valueFunction2.references(valueFunction)) continue;
            return true;
        }
        return false;
    }

    public Vector variables() {
        Vector vector = (Vector)this.args[1];
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            vector2 = Misc.union(vector2, valueFunction.variables());
        }
        return vector2;
    }

    public boolean isDeterminate() {
        Vector vector = (Vector)this.args[1];
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            if (valueFunction.isDeterminate()) continue;
            return false;
        }
        return true;
    }

    ValueFunction normalize() {
        Vector vector = (Vector)this.args[1];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.normalize();
            vector2.addElement(valueFunction);
        }
        return new DefinedFn((String)this.args[0], vector2);
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        Vector vector = (Vector)this.args[1];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.resolve(resolutionContext, bindings);
            vector2.addElement(valueFunction);
        }
        return new DefinedFn((String)this.args[0], vector2).evaluationFn();
    }

    public ValueFunction evaluationFn() {
        if (!(this.args[0].equals("nonvar") || this.args[0].equals("var") || this.isDeterminate())) {
            return this;
        }
        try {
            switch (Misc.whichPosition((String)this.args[0], FUNCTIONS)) {
                case 0: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    switch (((ValueFunction)((Object)primitiveNumericFn)).getID()) {
                        case 14: {
                            return new IntFn(Math.abs(primitiveNumericFn.longValue()));
                        }
                        case 15: {
                            return new RealFn(Math.abs(primitiveNumericFn.doubleValue()));
                        }
                    }
                    break;
                }
                case 2: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.acos(primitiveNumericFn.doubleValue()));
                }
                case 4: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.asin(primitiveNumericFn.doubleValue()));
                }
                case 6: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.atan(primitiveNumericFn.doubleValue()));
                }
                case 8: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    PrimitiveNumericFn primitiveNumericFn2 = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(1);
                    return new RealFn(Math.atan2(primitiveNumericFn.doubleValue(), primitiveNumericFn2.doubleValue()));
                }
                case 10: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.ceil(primitiveNumericFn.doubleValue()));
                }
                case 12: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.cos(primitiveNumericFn.doubleValue()));
                }
                case 18: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.exp(primitiveNumericFn.doubleValue()));
                }
                case 20: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.floor(primitiveNumericFn.doubleValue()));
                }
                case 22: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    PrimitiveNumericFn primitiveNumericFn3 = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(1);
                    return new RealFn(Math.IEEEremainder(primitiveNumericFn.doubleValue(), primitiveNumericFn3.doubleValue()));
                }
                case 24: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.log(primitiveNumericFn.doubleValue()));
                }
                case 26: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    PrimitiveNumericFn primitiveNumericFn4 = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(1);
                    if (((ValueFunction)((Object)primitiveNumericFn)).getID() == 14 && ((ValueFunction)((Object)primitiveNumericFn4)).getID() == 14) {
                        return new IntFn(Math.max(primitiveNumericFn.longValue(), primitiveNumericFn4.longValue()));
                    }
                    return new RealFn(Math.max(primitiveNumericFn.doubleValue(), primitiveNumericFn4.doubleValue()));
                }
                case 28: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    PrimitiveNumericFn primitiveNumericFn5 = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(1);
                    if (((ValueFunction)((Object)primitiveNumericFn)).getID() == 14 && ((ValueFunction)((Object)primitiveNumericFn5)).getID() == 14) {
                        return new IntFn(Math.min(primitiveNumericFn.longValue(), primitiveNumericFn5.longValue()));
                    }
                    return new RealFn(Math.min(primitiveNumericFn.doubleValue(), primitiveNumericFn5.doubleValue()));
                }
                case 30: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    PrimitiveNumericFn primitiveNumericFn6 = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(1);
                    return new RealFn(Math.pow(primitiveNumericFn.doubleValue(), primitiveNumericFn6.doubleValue()));
                }
                case 32: {
                    return new RealFn(Math.random());
                }
                case 34: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.rint(primitiveNumericFn.doubleValue()));
                }
                case 36: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new IntFn(Math.round(primitiveNumericFn.doubleValue()));
                }
                case 14: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.sin(primitiveNumericFn.doubleValue()));
                }
                case 38: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.sqrt(primitiveNumericFn.doubleValue()));
                }
                case 16: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.tan(primitiveNumericFn.doubleValue()));
                }
                case 40: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.toDegrees(primitiveNumericFn.doubleValue()));
                }
                case 42: {
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Vector)this.args[1]).elementAt(0);
                    return new RealFn(Math.toRadians(primitiveNumericFn.doubleValue()));
                }
                case 44: {
                    IdFn idFn = (IdFn)((Vector)this.args[1]).elementAt(0);
                    IdFn idFn2 = (IdFn)((Vector)this.args[1]).elementAt(1);
                    return new IdFn(idFn.getValue() + idFn2.getValue());
                }
                case 46: {
                    ValueFunction valueFunction = (ValueFunction)((Vector)this.args[1]).elementAt(0);
                    return BoolFn.newBoolFn(valueFunction.isDeterminate());
                }
                case 48: {
                    ValueFunction valueFunction = (ValueFunction)((Vector)this.args[1]).elementAt(0);
                    return BoolFn.newBoolFn(!valueFunction.isDeterminate());
                }
                default: {
                    throw new IllegalArgumentException("Unknown function: '" + this.args[0] + "'");
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Type mismatch in function '" + this + "'");
        }
        return null;
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        Vector vector = (Vector)this.args[1];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.duplicate(duplicationTable);
            vector2.addElement(valueFunction);
        }
        return new DefinedFn((String)this.args[0], vector2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefinedFn)) {
            return false;
        }
        DefinedFn definedFn = (DefinedFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = definedFn.simplify();
        return valueFunction.getArg(0).equals(valueFunction2.getArg(0)) && Misc.sameVector((Vector)valueFunction.getArg(1), (Vector)valueFunction2.getArg(1));
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        ValueFunction valueFunction2 = null;
        valueFunction2 = this.evaluationFn();
        if (valueFunction2 == this) {
            return new AndFn(this, valueFunction);
        }
        return valueFunction2.unifiesWith(valueFunction, bindings);
    }
}

