/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.AndFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class ConstraintBFn
extends ValueFunction {
    static final int NONVAR = 0;
    static final int VAR = 3;
    static final String[] FUNCTIONS = new String[]{"nonvar", "0", "false", "var", "0", "false"};
    protected Object[] args = new Object[3];
    protected int position = -1;

    public ConstraintBFn(ValueFunction valueFunction, String string, Vector vector) {
        super(0, 0);
        this.args[0] = valueFunction;
        this.args[1] = string;
        this.args[2] = vector;
        this.position = Misc.whichPosition(string, FUNCTIONS);
        if (this.position == -1 || this.position % 3 != 0) {
            throw new IllegalArgumentException("Unknown operator " + string + " in constraint expression.");
        }
        int n = Integer.parseInt(FUNCTIONS[this.position + 1]);
        if (vector == null || vector.size() != n) {
            throw new IllegalArgumentException("Wrong number of arguments used in constraint expression " + string + "/" + n + ".");
        }
    }

    public ValueFunction mirror() {
        ValueFunction valueFunction;
        Vector vector = (Vector)this.args[2];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.mirror();
            vector2.addElement(valueFunction);
        }
        valueFunction = ((ValueFunction)this.args[0]).mirror();
        return new ConstraintBFn(valueFunction, (String)this.args[1], vector2);
    }

    public String toString() {
        String string = this.args[0].toString() + "::" + (String)this.args[1] + "(";
        Vector vector = (Vector)this.args[2];
        for (int i = 0; i < vector.size(); ++i) {
            string = string + vector.elementAt(i);
            if (i + 1 >= vector.size()) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    ValueFunction simplify() {
        ValueFunction valueFunction;
        Vector vector = (Vector)this.args[2];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.simplify();
            vector2.addElement(valueFunction);
        }
        valueFunction = ((ValueFunction)this.args[0]).simplify();
        return new ConstraintBFn(valueFunction, (String)this.args[1], vector2);
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        ValueFunction valueFunction2 = (ValueFunction)this.args[0];
        if (valueFunction2.references(valueFunction)) {
            return true;
        }
        Vector vector = (Vector)this.args[2];
        for (int i = 0; i < vector.size(); ++i) {
            valueFunction2 = (ValueFunction)vector.elementAt(i);
            if (!valueFunction2.references(valueFunction)) continue;
            return true;
        }
        return false;
    }

    public Vector variables() {
        ValueFunction valueFunction = (ValueFunction)this.args[0];
        Vector vector = valueFunction.variables();
        Vector vector2 = (Vector)this.args[2];
        for (int i = 0; i < vector2.size(); ++i) {
            valueFunction = (ValueFunction)vector2.elementAt(i);
            vector = Misc.union(vector, valueFunction.variables());
        }
        return vector;
    }

    public boolean isDeterminate() {
        ValueFunction valueFunction = (ValueFunction)this.args[0];
        if (!valueFunction.isDeterminate()) {
            return false;
        }
        Vector vector = (Vector)this.args[2];
        for (int i = 0; i < vector.size(); ++i) {
            valueFunction = (ValueFunction)vector.elementAt(i);
            if (valueFunction.isDeterminate()) continue;
            return false;
        }
        return true;
    }

    ValueFunction normalize() {
        ValueFunction valueFunction;
        Vector vector = (Vector)this.args[2];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            valueFunction = (ValueFunction)vector.elementAt(i);
            valueFunction = valueFunction.normalize();
            vector2.addElement(valueFunction);
        }
        valueFunction = ((ValueFunction)this.args[0]).normalize();
        return new ConstraintBFn(valueFunction, (String)this.args[1], vector2);
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = ((ValueFunction)this.args[0]).resolve(resolutionContext, bindings);
        Vector vector = (Vector)this.args[2];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction2 = (ValueFunction)vector.elementAt(i);
            valueFunction2 = valueFunction2.resolve(resolutionContext, bindings);
            vector2.addElement(valueFunction2);
        }
        return new ConstraintBFn(valueFunction, (String)this.args[1], vector2).evaluationFn();
    }

    protected final boolean onlyEvaluateIfDeterminate() {
        return Boolean.valueOf(FUNCTIONS[this.position + 2]);
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        if (!(!this.onlyEvaluateIfDeterminate() || this.isDeterminate() && valueFunction.isDeterminate())) {
            return new AndFn(this, valueFunction);
        }
        switch (this.position) {
            case 0: {
                if (valueFunction.isDeterminate()) break;
                return null;
            }
            case 3: {
                if (!valueFunction.isDeterminate()) break;
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator in: '" + this + "'");
            }
        }
        ValueFunction valueFunction2 = (ValueFunction)this.args[0];
        return valueFunction2.unifiesWith(valueFunction, bindings);
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        ValueFunction valueFunction = ((ValueFunction)this.args[0]).duplicate(duplicationTable);
        Vector vector = (Vector)this.args[2];
        Vector<ValueFunction> vector2 = new Vector<ValueFunction>();
        for (int i = 0; i < vector.size(); ++i) {
            ValueFunction valueFunction2 = (ValueFunction)vector.elementAt(i);
            valueFunction2 = valueFunction2.duplicate(duplicationTable);
            vector2.addElement(valueFunction2);
        }
        return new ConstraintBFn(valueFunction, (String)this.args[1], vector2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstraintBFn)) {
            return false;
        }
        ConstraintBFn constraintBFn = (ConstraintBFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = constraintBFn.simplify();
        return valueFunction.getArg(0).equals(valueFunction2.getArg(0)) && valueFunction.getArg(1).equals(valueFunction2.getArg(1)) && Misc.sameVector((Vector)valueFunction.getArg(2), (Vector)valueFunction2.getArg(2));
    }
}

