/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.ArithmeticFn;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.DefinedFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.NumericFn;
import zeus.concepts.fn.PrimitiveFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class ComparisonFn
extends LogicalFn {
    static final int EQ = 0;
    static final int NE = 1;
    static final int LE = 2;
    static final int GE = 3;
    static final int LT = 4;
    static final int GT = 5;
    static final String[] comparators = new String[]{"==", "!=", "<=", ">=", "<", ">"};
    static final int[] illegal_operands = new int[]{5, 6, 9, 8};
    protected ValueFunction[] args = new ValueFunction[2];
    protected int op = -1;

    public ComparisonFn(ValueFunction valueFunction, ValueFunction valueFunction2, String string) {
        super(13, 4);
        this.op = Misc.whichPosition(string, comparators);
        if (this.op == -1) {
            throw new IllegalArgumentException("Unknown operator in '" + valueFunction + " " + string + " " + valueFunction2 + "'");
        }
        int n = valueFunction.getID();
        int n2 = valueFunction2.getID();
        if (Misc.member(n, illegal_operands) || Misc.member(n2, illegal_operands)) {
            throw new IllegalArgumentException("Illegal operands in  function '" + valueFunction + " " + string + " " + valueFunction2 + "'");
        }
        if (valueFunction.isDeterminate() && valueFunction2.isDeterminate() && (valueFunction instanceof LogicalFn ? !(valueFunction2 instanceof LogicalFn) && !(valueFunction2 instanceof DefinedFn) : (valueFunction instanceof NumericFn ? !(valueFunction2 instanceof NumericFn) && !(valueFunction2 instanceof DefinedFn) : n != n2))) {
            throw new IllegalArgumentException("Illegal operands in  function '" + valueFunction + " " + string + " " + valueFunction2 + "'");
        }
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
    }

    public ValueFunction mirror() {
        return new ComparisonFn(this.args[0].mirror(), this.args[1].mirror(), comparators[this.op]);
    }

    public String toString() {
        return "(" + this.args[0] + " " + comparators[this.op] + " " + this.args[1] + ")";
    }

    int getOperator() {
        return this.op;
    }

    ValueFunction simplify() {
        ValueFunction valueFunction = this.args[0].simplify();
        ValueFunction valueFunction2 = this.args[1].simplify();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new ComparisonFn(valueFunction, valueFunction2, comparators[this.op]) : this;
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.args[0].resolve(resolutionContext, bindings);
        ValueFunction valueFunction2 = this.args[1].resolve(resolutionContext, bindings);
        return new ComparisonFn(valueFunction, valueFunction2, comparators[this.op]).evaluationFn();
    }

    ValueFunction normalize() {
        ValueFunction valueFunction = this.args[0].normalize();
        ValueFunction valueFunction2 = this.args[1].normalize();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new ComparisonFn(valueFunction, valueFunction2, comparators[this.op]) : this;
    }

    public int evaluate() {
        ValueFunction valueFunction = this.evaluationFn();
        if (valueFunction == this) {
            return 2;
        }
        if (valueFunction == BoolFn.trueFn) {
            return 0;
        }
        return 1;
    }

    public ValueFunction evaluationFn() {
        int n;
        if (!this.isDeterminate()) {
            return this;
        }
        ValueFunction valueFunction = this.args[0];
        ValueFunction valueFunction2 = this.args[1];
        if (valueFunction instanceof LogicalFn) {
            valueFunction = ((LogicalFn)valueFunction).evaluationFn();
        } else if (valueFunction instanceof ArithmeticFn) {
            valueFunction = ((ArithmeticFn)valueFunction).evaluationFn();
        }
        if (valueFunction2 instanceof LogicalFn) {
            valueFunction2 = ((LogicalFn)valueFunction2).evaluationFn();
        } else if (valueFunction2 instanceof ArithmeticFn) {
            valueFunction2 = ((ArithmeticFn)valueFunction2).evaluationFn();
        }
        if (!(valueFunction instanceof PrimitiveFn) || !(valueFunction2 instanceof PrimitiveFn)) {
            throw new IllegalArgumentException(this.toString());
        }
        PrimitiveFn primitiveFn = (PrimitiveFn)((Object)valueFunction);
        PrimitiveFn primitiveFn2 = (PrimitiveFn)((Object)valueFunction2);
        int n2 = valueFunction.getID();
        if (!(n2 == (n = valueFunction2.getID()) || n2 == 14 && n == 15 || n2 == 15 && n == 14)) {
            throw new IllegalArgumentException(this.toString());
        }
        switch (this.op) {
            case 0: {
                return primitiveFn.equals(primitiveFn2) ? BoolFn.trueFn : BoolFn.falseFn;
            }
            case 2: {
                return primitiveFn.less(primitiveFn2) || primitiveFn.equals(primitiveFn2) ? BoolFn.trueFn : BoolFn.falseFn;
            }
            case 3: {
                return !primitiveFn.less(primitiveFn2) ? BoolFn.trueFn : BoolFn.falseFn;
            }
            case 1: {
                return !primitiveFn.equals(primitiveFn2) ? BoolFn.trueFn : BoolFn.falseFn;
            }
            case 5: {
                return !primitiveFn.less(primitiveFn2) && !primitiveFn.equals(primitiveFn2) ? BoolFn.trueFn : BoolFn.falseFn;
            }
            case 4: {
                return primitiveFn.less(primitiveFn2) ? BoolFn.trueFn : BoolFn.falseFn;
            }
        }
        throw new IllegalArgumentException("Unknown operator in '" + this + "'");
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new ComparisonFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable), comparators[this.op]);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparisonFn)) {
            return false;
        }
        ComparisonFn comparisonFn = (ComparisonFn)object;
        if (this.op != comparisonFn.getOperator()) {
            return false;
        }
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = comparisonFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }
}

