/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.AndFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.NumericFn;
import zeus.concepts.fn.RealFn;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.util.Misc;

public class ArithmeticFn
extends ValueFunction
implements NumericFn {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIVIDE = 3;
    public static final int REM = 4;
    public static final String[] operators = new String[]{"+", "-", "*", "/", "%"};
    public static final String[] legal_operands = new String[]{"zeus.concepts.fn.MethodCallFn", "zeus.concepts.fn.DefinedFn", "zeus.concepts.fn.ArithmeticFn", "zeus.concepts.fn.IntFn", "zeus.concepts.fn.RealFn", "zeus.concepts.fn.VarFn", "zeus.concepts.fn.FieldFn", "zeus.concepts.fn.ElseFn"};
    public static final String[] legal_unifiers = new String[]{"zeus.concepts.fn.MethodCallFn", "zeus.concepts.fn.DefinedFn", "zeus.concepts.fn.ArithmeticFn", "zeus.concepts.fn.IntFn", "zeus.concepts.fn.RealFn", "zeus.concepts.fn.VarFn", "zeus.concepts.fn.FieldFn", "zeus.concepts.fn.AndFn", "zeus.concepts.fn.OrFn", "zeus.concepts.fn.NotFn", "zeus.concepts.fn.ImplyFn", "zeus.concepts.fn.ElseFn"};
    protected ValueFunction[] args = new ValueFunction[2];
    protected int op = -1;

    public void resolve(String string, ValueFunction valueFunction) {
        ArithmeticFn arithmeticFn;
        ValueFunction valueFunction2 = this.args[0];
        ValueFunction valueFunction3 = this.args[1];
        this.debug("in resolve");
        if (valueFunction2 instanceof ArithmeticFn) {
            this.debug("recursing lhs");
            arithmeticFn = (ArithmeticFn)valueFunction2;
            arithmeticFn.resolve(string, valueFunction);
        } else if (valueFunction2 instanceof VarFn) {
            this.debug("resolving lhs");
            this.debug(" lhs = " + valueFunction2.toString() + " val = " + valueFunction.toString() + " attrName = " + string);
            if (valueFunction2.toString().equals("?" + string)) {
                this.args[0] = valueFunction2 = valueFunction;
            }
            this.debug(" lhs = " + valueFunction2.toString() + " val = " + valueFunction.toString() + " attrName = " + string);
        }
        if (valueFunction3 instanceof ArithmeticFn) {
            this.debug("recursing rhs");
            arithmeticFn = (ArithmeticFn)valueFunction3;
            arithmeticFn.resolve(string, valueFunction);
        } else if (valueFunction3 instanceof VarFn) {
            this.debug("resolving rhs");
            if (valueFunction3.toString().equals("?" + string)) {
                this.args[1] = valueFunction3 = valueFunction;
            }
        }
    }

    public ArithmeticFn(ValueFunction valueFunction, ValueFunction valueFunction2, String string) {
        super(19, 3);
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
        this.op = Misc.whichPosition(string, operators);
        if (this.op == -1) {
            throw new IllegalArgumentException("Illegal operator  in arithmetic function '" + valueFunction + string + valueFunction2 + "'");
        }
        String string2 = valueFunction.getClass().getName();
        String string3 = valueFunction2.getClass().getName();
        if (!Misc.member(string2, legal_operands) || !Misc.member(string3, legal_operands)) {
            throw new IllegalArgumentException("Illegal operands  in arithmetic function '" + valueFunction + string + valueFunction2 + "'");
        }
    }

    public ValueFunction getLHS() {
        return this.args[0];
    }

    public ValueFunction getRHS() {
        return this.args[1];
    }

    public ValueFunction mirror() {
        return new ArithmeticFn(this.args[0].mirror(), this.args[1].mirror(), operators[this.op]);
    }

    public String toString() {
        return "(" + this.args[0] + " " + operators[this.op] + " " + this.args[1] + ")";
    }

    public int getOperator() {
        return this.op;
    }

    ValueFunction simplify() {
        ValueFunction valueFunction = this.args[0].simplify();
        ValueFunction valueFunction2 = this.args[1].simplify();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new ArithmeticFn(valueFunction, valueFunction2, operators[this.op]) : this;
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    ValueFunction normalize() {
        ValueFunction valueFunction = this.args[0].normalize();
        ValueFunction valueFunction2 = this.args[1].normalize();
        return valueFunction != this.args[0] || valueFunction2 != this.args[1] ? new ArithmeticFn(valueFunction, valueFunction2, operators[this.op]) : this;
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.args[0].resolve(resolutionContext, bindings);
        ValueFunction valueFunction2 = this.args[1].resolve(resolutionContext, bindings);
        return new ArithmeticFn(valueFunction, valueFunction2, operators[this.op]).evaluationFn();
    }

    public ValueFunction evaluationFn() {
        if (!this.isDeterminate()) {
            return this;
        }
        double d = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 15;
        int n2 = 15;
        int n3 = 15;
        try {
            ValueFunction valueFunction = this.args[0].evaluationFn();
            ValueFunction valueFunction2 = this.args[1].evaluationFn();
            if (valueFunction instanceof IntFn) {
                d = ((IntFn)valueFunction).getValue();
                n = 14;
            } else {
                d = ((RealFn)valueFunction).getValue();
            }
            if (valueFunction2 instanceof IntFn) {
                d3 = ((IntFn)valueFunction2).getValue();
                n2 = 14;
            } else {
                d3 = ((RealFn)valueFunction2).getValue();
            }
            n3 = n == 15 || n2 == 15 ? 15 : 14;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown operand type in  arithmetic function '" + this + "'");
        }
        switch (this.op) {
            case 0: {
                d4 = d + d3;
                break;
            }
            case 1: {
                d4 = d - d3;
                break;
            }
            case 2: {
                d4 = d * d3;
                break;
            }
            case 3: {
                d4 = d / d3;
                break;
            }
            case 4: {
                d4 = (int)d % (int)d3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator in  arithmetic function '" + this + "'");
            }
        }
        if (this.op == 4 || n3 == 14) {
            return new IntFn((int)d4);
        }
        return new RealFn(d4);
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new ArithmeticFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable), operators[this.op]);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArithmeticFn)) {
            return false;
        }
        ArithmeticFn arithmeticFn = (ArithmeticFn)object;
        if (this.op != arithmeticFn.getOperator()) {
            return false;
        }
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = arithmeticFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        String string = valueFunction.getClass().getName();
        if (!Misc.member(string, legal_unifiers)) {
            throw new IllegalArgumentException("Illegal unification attempted: " + this + " and " + valueFunction);
        }
        ValueFunction valueFunction2 = null;
        valueFunction2 = this.evaluationFn();
        if (valueFunction2 == this) {
            return new AndFn(this, valueFunction);
        }
        return valueFunction2.unifiesWith(valueFunction, bindings);
    }

    public void debug(String string) {
    }
}

