/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.AbilityDbItem;
import zeus.concepts.AbilitySpec;
import zeus.concepts.AbstractTask;
import zeus.concepts.Acquaintance;
import zeus.concepts.Address;
import zeus.concepts.AgentDescription;
import zeus.concepts.ConsumerRecord;
import zeus.concepts.DF_Description;
import zeus.concepts.FIPAParser;
import zeus.concepts.FIPAPerformative;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.FIPA_AMS_Management_Content;
import zeus.concepts.FIPA_DF_Management_Content;
import zeus.concepts.Fact;
import zeus.concepts.FactSummary;
import zeus.concepts.Goal;
import zeus.concepts.GoalSummary;
import zeus.concepts.OntologyDb;
import zeus.concepts.Ordering;
import zeus.concepts.Parser;
import zeus.concepts.Performative;
import zeus.concepts.PerformativeParser;
import zeus.concepts.PlanScript;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ProducerRecord;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.Relationship;
import zeus.concepts.ReportRec;
import zeus.concepts.ReservationEntry;
import zeus.concepts.ResolutionContext;
import zeus.concepts.RoutingRecord;
import zeus.concepts.StrategyInfo;
import zeus.concepts.SummaryTask;
import zeus.concepts.SuppliedDb;
import zeus.concepts.SuppliedItem;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.concepts.TaskSummary;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.GeneratorModel;
import zeus.generator.code.AgentInfo;
import zeus.generator.code.DbProxyInfo;
import zeus.generator.code.FacilitatorInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.NameserverInfo;
import zeus.generator.code.TaskInfo;
import zeus.generator.code.VisualiserInfo;
import zeus.rete.Action;
import zeus.rete.Pattern;
import zeus.rete.ReteFact;
import zeus.rete.Rule;
import zeus.util.Core;
import zeus.util.StringHashtable;

public class ZeusParser {
    public static final AbilityDbItem abilityDbItem(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.abilityDbItem(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 1, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector abilityDbItemList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.abilityDbItemList(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 2, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector abilitySpecList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.abilitySpecList(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 3, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final AbilitySpec abilitySpec(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.abilitySpec(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 4, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Acquaintance acquaintance(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.acquaintance(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 5, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Address address(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.address();
        }
        catch (Exception exception) {
            Core.ERROR(null, 6, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector addressList(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.addressList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 7, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector addressList(InputStream inputStream) {
        try {
            Parser parser = new Parser(inputStream);
            return parser.addressList();
        }
        catch (Exception exception) {
            Core.ERROR(null, 61, (Object)("Error parsing " + inputStream));
            exception.printStackTrace();
            return null;
        }
    }

    public static final AgentDescription agentDescription(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.agentDescription(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 8, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ConsumerRecord consumerRecord(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.consumerRecord();
        }
        catch (Exception exception) {
            Core.ERROR(null, 10, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Fact fact(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.fact(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 11, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector factList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.factList(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 12, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final FactSummary factSummary(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.factSummary(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 13, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector goalList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.goalList(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 14, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Goal goal(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.goal(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 15, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final GoalSummary goalSummary(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.goalSummary();
        }
        catch (Exception exception) {
            Core.ERROR(null, 16, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final FIPAPerformative fipaPerformative(String string) {
        try {
            string = string.toLowerCase();
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.Message();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final Hashtable addresses(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.Addresses();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 17, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final FIPA_AID_Address fipaAddress(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.SenderName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 17, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Performative performative(byte[] byArray) {
        try {
            PerformativeParser performativeParser = new PerformativeParser(new ByteArrayInputStream(byArray));
            return performativeParser.Message();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 17, (Object)("Error parsing " + new String(byArray)));
            return null;
        }
    }

    public static final synchronized Performative performative(String string) {
        try {
            string = string.toLowerCase();
            PerformativeParser performativeParser = new PerformativeParser(new ByteArrayInputStream(string.getBytes()));
            return performativeParser.Message();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 17, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ProducerRecord producerRecord(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.producerRecord();
        }
        catch (Exception exception) {
            Core.ERROR(null, 18, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ProtocolInfo protocolInfo(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.protocolInfo(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 19, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final StrategyInfo strategyInfo(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.strategyInfo(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 20, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Relationship relationship(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.relationship();
        }
        catch (Exception exception) {
            Core.ERROR(null, 21, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector relationshipList(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.relationshipList();
        }
        catch (Exception exception) {
            Core.ERROR(null, 210, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ReportRec reportRec(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reportRec(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 22, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ReservationEntry reservationEntry(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reservationEntry();
        }
        catch (Exception exception) {
            Core.ERROR(null, 23, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final RoutingRecord routingRecord(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.routingRecord();
        }
        catch (Exception exception) {
            Core.ERROR(null, 24, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final SuppliedDb suppliedDb(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.suppliedDb(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 25, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final SuppliedItem suppliedItem(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.suppliedItem(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 26, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ResolutionContext resolutionContext(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.resolutionContext(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 27, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final AbstractTask abstractTask(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.abstractTask(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 28, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final PrimitiveTask primitiveTask(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.primitiveTask(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 29, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final SummaryTask summaryTask(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.summaryTask(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 30, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final PlanScript planScript(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.planScript(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 301, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final TaskLink taskLink(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.taskLink();
        }
        catch (Exception exception) {
            Core.ERROR(null, 31, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final TaskNode taskNode(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.taskNode(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 32, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final TaskSummary taskSummary(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.taskSummary(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 33, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Ordering ordering(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.ordering();
        }
        catch (Exception exception) {
            Core.ERROR(null, 34, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final AbstractTask reteKB(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reteKB(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 35, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final AbstractTask reteKB(OntologyDb ontologyDb, InputStream inputStream) {
        try {
            Parser parser = new Parser(inputStream);
            return parser.reteKB(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 63, (Object)("Error parsing\n" + exception));
            exception.printStackTrace();
            return null;
        }
    }

    public static final Rule reteRule(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reteRule(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 36, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Pattern retePattern(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.retePattern(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 37, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Action reteAction(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reteAction(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 38, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector reteFactList(OntologyDb ontologyDb, InputStream inputStream) {
        try {
            Parser parser = new Parser(inputStream);
            return parser.reteFactList(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 390, (Object)("Error parsing reteFactList from stream" + inputStream));
            return null;
        }
    }

    public static final Vector reteFactList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reteFactList(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 391, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ReteFact reteFact(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reteFact(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 39, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector retePatternList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.retePatternList(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 40, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector reteActionList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.reteActionList(ontologyDb);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 62, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final AgentInfo agentInfo(GeneratorModel generatorModel, GenerationPlan generationPlan, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.agentInfo(generatorModel, generationPlan);
        }
        catch (Exception exception) {
            Core.ERROR(null, 41, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final DbProxyInfo dbProxyInfo(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.dbProxyInfo();
        }
        catch (Exception exception) {
            Core.ERROR(null, 42, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final FacilitatorInfo facilitatorInfo(GenerationPlan generationPlan, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.facilitatorInfo(generationPlan);
        }
        catch (Exception exception) {
            Core.ERROR(null, 43, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final VisualiserInfo visualiserInfo(GenerationPlan generationPlan, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.visualiserInfo(generationPlan);
        }
        catch (Exception exception) {
            Core.ERROR(null, 44, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final NameserverInfo nameserverInfo(String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.nameserverInfo();
        }
        catch (Exception exception) {
            Core.ERROR(null, 45, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final TaskInfo taskInfo(GeneratorModel generatorModel, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.taskInfo(generatorModel);
        }
        catch (Exception exception) {
            Core.ERROR(null, 46, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector taskList(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.taskList(ontologyDb);
        }
        catch (Exception exception) {
            Core.ERROR(null, 47, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final ValueFunction Expression(String string) {
        return ZeusParser.Expression(null, string);
    }

    public static final ValueFunction Expression(OntologyDb ontologyDb, String string) {
        try {
            Parser parser = new Parser(new ByteArrayInputStream(string.getBytes()));
            return parser.Expression(ontologyDb);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final FIPA_AMS_Management_Content FIPA_AMS_Management_Content(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.FIPA_AMS_Management_Content();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final FIPA_DF_Management_Content FIPA_DF_Management_Content(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.FIPA_DF_Management_Content();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 49, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final DF_Description DF_Content(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.DFDescription();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 49, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static final Vector descriptionSet(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.descriptions();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final StringHashtable Transports(String string) {
        try {
            FIPAParser fIPAParser = new FIPAParser(new ByteArrayInputStream(string.getBytes()));
            return fIPAParser.Transports();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Core.ERROR(null, 50, (Object)("Error parsing " + string));
            return null;
        }
    }

    public static void main(String[] stringArray) {
        ZeusParser.descriptionSet(stringArray[0]);
    }
}

