/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;

public class TaskNode {
    public static final String BEGIN = "begin";
    public static final String END = "end";
    public static final String DEFAULT_GROUP = "default";
    protected boolean isConditionalNode = false;
    protected String name;
    protected Hashtable consumed = new Hashtable();
    protected Hashtable produced = new Hashtable();

    public TaskNode(String string) {
        this.setName(string);
        this.consumed.put(DEFAULT_GROUP, new Vector());
        this.produced.put(DEFAULT_GROUP, new Vector());
    }

    public TaskNode(String string, Fact[] factArray, Fact[] factArray2) {
        this.setName(string);
        this.setPostconditions(factArray2);
        this.setPreconditions(factArray);
    }

    public TaskNode(String string, Vector vector, Vector vector2) {
        this.setName(string);
        this.setPostconditions(vector2);
        this.setPreconditions(vector);
    }

    public TaskNode(TaskNode taskNode) {
        this.name = taskNode.getName();
        this.setPostconditions(taskNode.getPostconditions());
        this.setPreconditions(taskNode.getPreconditions());
    }

    public final boolean isConditionalNode() {
        return this.isConditionalNode;
    }

    public final boolean isBeginNode() {
        return this.name.equals(BEGIN);
    }

    public final boolean isEndNode() {
        return this.name.equals(END);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        Assert.notNull(string);
        Assert.notFalse(!string.equals(""));
        this.name = string;
    }

    public String[] getPreconditionGroups() {
        String[] stringArray = new String[this.consumed.size()];
        Enumeration enumeration = this.consumed.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getPostconditionGroups() {
        String[] stringArray = new String[this.produced.size()];
        Enumeration enumeration = this.produced.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void setPostconditions(Hashtable hashtable) {
        this.produced.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            Vector<Fact> vector2 = new Vector<Fact>();
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(new Fact((Fact)vector.elementAt(i)));
            }
            this.produced.put(string, vector2);
        }
    }

    public void setPreconditions(Hashtable hashtable) {
        this.consumed.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            Vector<Fact> vector2 = new Vector<Fact>();
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(new Fact((Fact)vector.elementAt(i)));
            }
            this.consumed.put(string, vector2);
        }
    }

    public Hashtable getAllPostconditions() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.produced.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.produced.get(string);
            Vector<Fact> vector2 = new Vector<Fact>();
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(new Fact((Fact)vector.elementAt(i)));
            }
            hashtable.put(string, vector2);
        }
        return hashtable;
    }

    public Hashtable getAllPreconditions() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.consumed.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.consumed.get(string);
            Vector<Fact> vector2 = new Vector<Fact>();
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(new Fact((Fact)vector.elementAt(i)));
            }
            hashtable.put(string, vector2);
        }
        return hashtable;
    }

    public Vector produced() {
        return this.getGroup(this.produced, DEFAULT_GROUP);
    }

    public Vector consumed() {
        return this.getGroup(this.consumed, DEFAULT_GROUP);
    }

    public Vector produced(String string) {
        return this.getGroup(this.produced, string);
    }

    public Vector consumed(String string) {
        return this.getGroup(this.consumed, string);
    }

    public void setPostconditions(Vector vector) {
        this.setPostconditions(DEFAULT_GROUP, vector);
    }

    public void setPostconditions(Fact[] factArray) {
        this.setPostconditions(DEFAULT_GROUP, factArray);
    }

    public void setPreconditions(Vector vector) {
        this.setPreconditions(DEFAULT_GROUP, vector);
    }

    public void setPreconditions(Fact[] factArray) {
        this.setPreconditions(DEFAULT_GROUP, factArray);
    }

    protected Vector getGroup(Hashtable hashtable, String string) {
        Vector vector = (Vector)hashtable.get(string);
        if (vector == null) {
            vector = new Vector();
            hashtable.put(string, vector);
        }
        return vector;
    }

    public void setPostconditions(String string, Vector vector) {
        Vector vector2 = this.getGroup(this.produced, string);
        vector2.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(new Fact((Fact)vector.elementAt(i)));
        }
    }

    public void setPostconditions(String string, Fact[] factArray) {
        Vector vector = this.getGroup(this.produced, string);
        vector.removeAllElements();
        for (int i = 0; i < factArray.length; ++i) {
            vector.addElement(new Fact(factArray[i]));
        }
    }

    public void setPreconditions(String string, Vector vector) {
        Vector vector2 = this.getGroup(this.consumed, string);
        vector2.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(new Fact((Fact)vector.elementAt(i)));
        }
    }

    public void setPreconditions(String string, Fact[] factArray) {
        Vector vector = this.getGroup(this.consumed, string);
        vector.removeAllElements();
        for (int i = 0; i < factArray.length; ++i) {
            vector.addElement(new Fact(factArray[i]));
        }
    }

    public Fact[] getPostconditions() {
        return this.getPostconditions(DEFAULT_GROUP);
    }

    public Fact[] getPreconditions() {
        return this.getPreconditions(DEFAULT_GROUP);
    }

    public Fact[] getPostconditions(String string) {
        Vector vector = this.getGroup(this.produced, string);
        Fact[] factArray = new Fact[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            factArray[i] = new Fact((Fact)vector.elementAt(i));
        }
        return factArray;
    }

    public Fact[] getPreconditions(String string) {
        Vector vector = this.getGroup(this.consumed, string);
        Fact[] factArray = new Fact[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            factArray[i] = new Fact((Fact)vector.elementAt(i));
        }
        return factArray;
    }

    public int countPreconditions() {
        return this.countPreconditions(DEFAULT_GROUP);
    }

    public int countPostconditions() {
        return this.countPostconditions(DEFAULT_GROUP);
    }

    public int[] numPreconditions() {
        return this.numPreconditions(DEFAULT_GROUP);
    }

    public int[] numPostconditions() {
        return this.numPostconditions(DEFAULT_GROUP);
    }

    public int countPreconditions(String string) {
        return this.getGroup(this.consumed, string).size();
    }

    public int countPostconditions(String string) {
        return this.getGroup(this.produced, string).size();
    }

    public int[] numPreconditions(String string) {
        Vector vector = this.getGroup(this.consumed, string);
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = ((Fact)vector.elementAt(i)).getNumber();
        }
        return nArray;
    }

    public int[] numPostconditions(String string) {
        Vector vector = this.getGroup(this.produced, string);
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = ((Fact)vector.elementAt(i)).getNumber();
        }
        return nArray;
    }

    public Fact getPrecondition(String string) {
        return this.getPrecondition(DEFAULT_GROUP, string);
    }

    public Fact getPostcondition(String string) {
        return this.getPostcondition(DEFAULT_GROUP, string);
    }

    public Fact getPrecondition(int n) {
        return this.getPrecondition(DEFAULT_GROUP, n);
    }

    public Fact getPostcondition(int n) {
        return this.getPostcondition(DEFAULT_GROUP, n);
    }

    public int getConsumedPos(Fact fact) {
        return this.getConsumedPos(DEFAULT_GROUP, fact);
    }

    public int getProducedPos(Fact fact) {
        return this.getProducedPos(DEFAULT_GROUP, fact);
    }

    public Fact getPrecondition(String string, String string2) {
        Vector vector = this.getGroup(this.consumed, string);
        for (int i = 0; i < vector.size(); ++i) {
            Fact fact = (Fact)vector.elementAt(i);
            if (!string2.equals(fact.getId())) continue;
            return fact;
        }
        return null;
    }

    public Fact getPostcondition(String string, String string2) {
        Vector vector = this.getGroup(this.produced, string);
        for (int i = 0; i < vector.size(); ++i) {
            Fact fact = (Fact)vector.elementAt(i);
            if (!string2.equals(fact.getId())) continue;
            return fact;
        }
        return null;
    }

    public Fact getPrecondition(String string, int n) {
        Vector vector = this.getGroup(this.consumed, string);
        return (Fact)vector.elementAt(n);
    }

    public Fact getPostcondition(String string, int n) {
        Vector vector = this.getGroup(this.produced, string);
        return (Fact)vector.elementAt(n);
    }

    public int getConsumedPos(String string, Fact fact) {
        Vector vector = this.getGroup(this.consumed, string);
        String string2 = fact.getId();
        for (int i = 0; i < vector.size(); ++i) {
            Fact fact2 = (Fact)vector.elementAt(i);
            if (!string2.equals(fact2.getId())) continue;
            return i;
        }
        Assert.notNull(null);
        return -1;
    }

    public int getProducedPos(String string, Fact fact) {
        Vector vector = this.getGroup(this.produced, string);
        String string2 = fact.getId();
        for (int i = 0; i < vector.size(); ++i) {
            Fact fact2 = (Fact)vector.elementAt(i);
            if (!string2.equals(fact2.getId())) continue;
            return i;
        }
        Assert.notNull(null);
        return -1;
    }

    public void relaxNumberFields() {
        ValueFunction valueFunction;
        Fact fact;
        int n;
        Vector vector;
        Enumeration enumeration = this.consumed.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                fact = (Fact)vector.elementAt(n);
                if (!fact.isa("Entity") || (valueFunction = fact.getFn("number")).getID() != 14) continue;
                fact.setValue("number", fact.newVar());
            }
        }
        enumeration = this.produced.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                fact = (Fact)vector.elementAt(n);
                if (!fact.isa("Entity") || (valueFunction = fact.getFn("number")).getID() != 14) continue;
                fact.setValue("number", fact.newVar());
            }
        }
    }

    public boolean resolve(Bindings bindings) {
        Core.DEBUG(3, "TaskNode resolve: b = " + bindings);
        return this.resolve(new ResolutionContext(), bindings);
    }

    public boolean resolve(ResolutionContext resolutionContext, Bindings bindings) {
        Vector vector;
        boolean bl = true;
        Enumeration<Object> enumeration = this.consumed.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (int i = 0; bl && i < vector.size(); bl &= ((Fact)vector.elementAt(i)).resolve(resolutionContext, bindings), ++i) {
            }
        }
        if (!bl) {
            return bl;
        }
        enumeration = this.produced.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector = (Vector)this.produced.get(string);
            boolean bl2 = true;
            Bindings bindings2 = new Bindings(bindings);
            for (int i = 0; bl2 && i < vector.size(); bl2 &= ((Fact)vector.elementAt(i)).resolve(resolutionContext, bindings2), ++i) {
            }
            if (bl2) {
                bindings.add(bindings2);
                continue;
            }
            this.produced.remove(string);
        }
        if (this.produced.isEmpty()) {
            return false;
        }
        return bl;
    }

    public String toString() {
        int n;
        Vector vector;
        String string;
        Enumeration enumeration;
        String string2 = new String("(");
        string2 = string2 + ":name " + this.name + " ";
        string2 = string2 + ":is_conditional " + this.isConditionalNode + " ";
        if (!this.consumed.isEmpty()) {
            string2 = string2 + ":consumed_facts (";
            enumeration = this.consumed.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector = (Vector)this.consumed.get(string);
                string2 = string2 + "(:group " + string + " (";
                for (n = 0; n < vector.size(); ++n) {
                    string2 = string2 + vector.elementAt(n);
                }
                string2 = string2 + "))";
            }
            string2 = string2 + ") ";
        }
        if (!this.produced.isEmpty()) {
            string2 = string2 + ":produced_facts (";
            enumeration = this.produced.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector = (Vector)this.produced.get(string);
                string2 = string2 + "(:group " + string + " (";
                for (n = 0; n < vector.size(); ++n) {
                    string2 = string2 + vector.elementAt(n);
                }
                string2 = string2 + "))";
            }
            string2 = string2 + ") ";
        }
        return string2.trim() + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        int n2;
        Vector vector;
        String string;
        Enumeration enumeration;
        String string2;
        String string3;
        String string4 = Misc.spaces(n);
        String string5 = "\n" + string4 + " ";
        String string6 = new String("(");
        string6 = string6 + ":name " + this.name + string5;
        string6 = string6 + ":is_conditional " + this.isConditionalNode + string5;
        if (!this.consumed.isEmpty()) {
            string3 = ":consumed_facts ";
            string2 = Misc.spaces(1 + n + string3.length());
            string6 = string6 + string3 + "(";
            enumeration = this.consumed.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector = (Vector)this.consumed.get(string);
                string6 = string6 + "(:group " + string + " (";
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    string6 = string6 + ((Fact)vector.elementAt(n2)).pprint(1 + string2.length()) + "\n" + string2 + " ";
                }
                string6 = string6.trim() + "\n" + string2 + "))" + string5;
            }
            string6 = string6.trim() + "\n" + string2 + ")" + string5;
        }
        if (!this.produced.isEmpty()) {
            string3 = ":produced_facts ";
            string2 = Misc.spaces(1 + n + string3.length());
            string6 = string6 + string3 + "(";
            enumeration = this.produced.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector = (Vector)this.produced.get(string);
                string6 = string6 + "(:group " + string + " (";
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    string6 = string6 + ((Fact)vector.elementAt(n2)).pprint(1 + string2.length()) + "\n" + string2 + " ";
                }
                string6 = string6.trim() + "\n" + string2 + "))" + string5;
            }
            string6 = string6.trim() + "\n" + string2 + ")" + string5;
        }
        return string6.trim() + "\n" + string4 + ")";
    }

    public TaskNode duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public TaskNode duplicate(DuplicationTable duplicationTable) {
        int n;
        Fact[] factArray;
        Vector vector;
        String string;
        TaskNode taskNode = new TaskNode(this.name);
        Enumeration enumeration = this.consumed.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector = (Vector)this.consumed.get(string);
            factArray = new Fact[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                factArray[n] = ((Fact)vector.elementAt(n)).duplicate(duplicationTable);
            }
            taskNode.setPreconditions(string, factArray);
        }
        enumeration = this.produced.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector = (Vector)this.produced.get(string);
            factArray = new Fact[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                factArray[n] = ((Fact)vector.elementAt(n)).duplicate(duplicationTable);
            }
            taskNode.setPostconditions(string, factArray);
        }
        return taskNode;
    }
}

