/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.concepts.AbstractTask;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.ResolutionContext;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ArithmeticFn;
import zeus.concepts.fn.ElseFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.PrimitiveNumericFn;
import zeus.concepts.fn.RealFn;
import zeus.concepts.fn.ValueFunction;
import zeus.ontology.service.InstanceRenderer;
import zeus.ontology.service.ProcessRenderer;
import zeus.ontology.service.ProfileRenderer;
import zeus.ontology.service.RangeRenderer;
import zeus.ontology.service.RendererFactory;
import zeus.ontology.service.UnknownRendererTypeException;
import zeus.util.Core;
import zeus.util.SystemProps;

public abstract class Task
extends AbstractTask {
    protected Vector constraints = new Vector();
    protected ValueFunction time = ZeusParser.Expression(SystemProps.getProperty("task.default.time"));
    protected ValueFunction cost = ZeusParser.Expression(SystemProps.getProperty("task.default.cost"));
    transient ResolutionContext resolution_context = null;

    public void setTimeFn(String string) {
        ValueFunction valueFunction = ZeusParser.Expression(string);
        if (valueFunction != null) {
            this.time = valueFunction;
        }
    }

    public void setTimeFn(ValueFunction valueFunction) {
        this.time = valueFunction;
    }

    public void setCostFn(String string) {
        ValueFunction valueFunction = ZeusParser.Expression(string);
        if (valueFunction != null) {
            this.cost = valueFunction;
        }
    }

    public void setCostFn(ValueFunction valueFunction) {
        this.cost = valueFunction;
    }

    public ValueFunction getTimeFn() {
        return this.time;
    }

    public ValueFunction getCostFn() {
        return this.cost;
    }

    public int getTime() {
        ValueFunction valueFunction;
        int n = SystemProps.getInt("task.default.time");
        if (this.time instanceof ElseFn) {
            this.time = valueFunction = this.time.evaluationFn();
        }
        if (this.time instanceof ArithmeticFn) {
            valueFunction = ((ArithmeticFn)this.time).evaluationFn();
            if (valueFunction instanceof IntFn) {
                n = ((IntFn)this.time).getValue();
            } else if (valueFunction instanceof RealFn) {
                double d = ((RealFn)this.time).getValue();
                Double d3 = new Double(d);
                n = d3.intValue();
            }
        }
        if (!this.time.isDeterminate() || !(this.time instanceof IntFn)) {
            Core.USER_ERROR("Task " + this.name + " is improperly defined.\nCannot evaluates its " + " duration given required effect.\nCurrent value: '" + this.time + "'\nSetting duration to " + n);
        } else {
            n = ((IntFn)this.time).getValue();
        }
        return n;
    }

    public double getCost() {
        double d = SystemProps.getDouble("task.default.cost");
        this.debug("cost= " + this.cost.toString());
        Fact[] factArray = this.getPostconditions();
        for (int i = 0; i < factArray.length; ++i) {
            this.debug("post  = " + factArray[i].toString());
        }
        if (this.cost instanceof ElseFn) {
            ValueFunction valueFunction = this.cost.evaluationFn();
            this.debug("elseed" + valueFunction.toString());
            this.cost = valueFunction;
        }
        if (this.cost instanceof ArithmeticFn) {
            ValueFunction valueFunction = ((ArithmeticFn)this.cost).evaluationFn();
            if (valueFunction instanceof IntFn) {
                d = ((IntFn)this.time).getValue();
                this.debug("arith then int");
                return d;
            }
            if (valueFunction instanceof RealFn) {
                d = ((RealFn)this.time).getValue();
                this.debug("arith then real");
                return d;
            }
        }
        if (!this.cost.isDeterminate() || !(this.cost instanceof PrimitiveNumericFn)) {
            Core.USER_ERROR("Task " + this.name + " is improperly defined.\nCannot evaluates its " + " cost given required effect.\nCurrent value: '" + this.cost + "'\nSetting cost to " + d);
        } else {
            d = ((PrimitiveNumericFn)((Object)this.cost)).doubleValue();
        }
        return d;
    }

    public abstract Fact[] getPostconditions();

    public abstract Fact[] getPreconditions();

    public abstract ResolutionContext getContext();

    public boolean applyConstraints(Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        ResolutionContext resolutionContext = this.getContext();
        for (int i = 0; i < this.constraints.size(); ++i) {
            LogicalFn logicalFn = (LogicalFn)this.constraints.elementAt(i);
            if ((logicalFn = (LogicalFn)logicalFn.resolve(resolutionContext, bindings2)) == null) {
                return false;
            }
            if (logicalFn.evaluate() == 0) continue;
            return false;
        }
        return bindings.add(bindings2);
    }

    public void setConstraints(Vector vector) {
        this.constraints.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.constraints.addElement((LogicalFn)vector.elementAt(i));
        }
    }

    public void setConstraints(LogicalFn[] logicalFnArray) {
        this.constraints.removeAllElements();
        for (int i = 0; i < logicalFnArray.length; ++i) {
            this.constraints.addElement(logicalFnArray[i]);
        }
    }

    public LogicalFn[] getConstraints() {
        LogicalFn[] logicalFnArray = new LogicalFn[this.constraints.size()];
        for (int i = 0; i < this.constraints.size(); ++i) {
            logicalFnArray[i] = (LogicalFn)this.constraints.elementAt(i);
        }
        return logicalFnArray;
    }

    public String getServiceDesc(AgentContext agentContext) {
        try {
            ProfileRenderer profileRenderer = RendererFactory.getProfileRenderer("DAML-S");
            return profileRenderer.renderProfile(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public String getInstanceDetails(AgentContext agentContext) {
        try {
            InstanceRenderer instanceRenderer = RendererFactory.getInstanceRenderer("DAML-S");
            return instanceRenderer.renderInstance(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public String getInstanceRange(AgentContext agentContext) {
        try {
            RangeRenderer rangeRenderer = RendererFactory.getRangeRenderer("XSD");
            return rangeRenderer.renderRange(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public String getProcessModel(AgentContext agentContext) {
        try {
            ProcessRenderer processRenderer = RendererFactory.getProcessRenderer("DAML-S");
            return processRenderer.renderProcess(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public void debug(String string) {
    }
}

