/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.ReservationEntry;
import zeus.util.Assert;
import zeus.util.GenSym;

public class SuppliedItem {
    public static final int UNCHANGED = 0;
    public static final int MODIFY = 1;
    public static final int DELETE = 2;
    protected Fact fact = null;
    protected String supplier = null;
    protected String id = null;
    protected String link = null;
    protected Hashtable reservations = new Hashtable();

    public SuppliedItem(String string, String string2, String string3, Fact fact) {
        Assert.notNull(string);
        Assert.notNull(string2);
        Assert.notNull(fact);
        Assert.notNull(string3);
        this.id = string;
        this.link = string2;
        this.fact = fact;
        this.supplier = string3;
    }

    public Fact getFact() {
        return this.fact;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public String getId() {
        return this.id;
    }

    public String getLink() {
        return this.link;
    }

    public boolean equals(SuppliedItem suppliedItem) {
        return this.id.equals(suppliedItem.getId());
    }

    public synchronized ReservationEntry[] getReservations() {
        ReservationEntry[] reservationEntryArray = new ReservationEntry[this.reservations.size()];
        Enumeration enumeration = this.reservations.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            reservationEntryArray[n] = (ReservationEntry)enumeration.nextElement();
            ++n;
        }
        return reservationEntryArray;
    }

    public synchronized ReservationEntry[] getReservations(String string) {
        Vector<ReservationEntry> vector = new Vector<ReservationEntry>();
        Enumeration enumeration = this.reservations.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
            if (reservationEntry.agent.equals(string)) {
                vector.addElement(reservationEntry);
            }
            ++n;
        }
        ReservationEntry[] reservationEntryArray = new ReservationEntry[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            reservationEntryArray[i] = (ReservationEntry)vector.elementAt(i);
        }
        return reservationEntryArray;
    }

    public synchronized boolean isReserved() {
        return !this.reservations.isEmpty();
    }

    public synchronized boolean reservationOK(int n, boolean bl, int n2) {
        return this.unreservedAmount(n, bl) >= n2;
    }

    public synchronized int unreservedAmount(int n, boolean bl) {
        return this.fact.getNumber() - this.reservedAmount(n, bl);
    }

    public synchronized int reservedAmount(int n, boolean bl) {
        Enumeration enumeration = this.reservations.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
            if (bl) {
                if (!reservationEntry.consumed && reservationEntry.start <= n) continue;
                n2 += reservationEntry.amount;
                continue;
            }
            if (!reservationEntry.consumed || reservationEntry.start > n) continue;
            n2 += reservationEntry.amount;
        }
        return n2;
    }

    public synchronized String[] getReservationId() {
        String[] stringArray = new String[this.reservations.size()];
        Enumeration enumeration = this.reservations.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
            stringArray[n] = reservationEntry.id;
            ++n;
        }
        return stringArray;
    }

    public synchronized int getEarliestReservationTime() {
        Enumeration enumeration = this.reservations.elements();
        int n = Integer.MAX_VALUE;
        while (enumeration.hasMoreElements()) {
            ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
            n = Math.min(n, reservationEntry.start);
        }
        return n;
    }

    public boolean containsReservationId(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry != null;
    }

    public int getReservationTime(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry.start;
    }

    public boolean isReservationConsumed(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry.consumed;
    }

    public int getReservedAmount(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry == null ? 0 : reservationEntry.amount;
    }

    public String getReservingAgent(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry == null ? null : reservationEntry.agent;
    }

    public String getReservationGoalId(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry == null ? null : reservationEntry.goalId;
    }

    public String getReservationCommsKey(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        return reservationEntry == null ? null : reservationEntry.comms_key;
    }

    public int getAmountReservedByAgent(String string) {
        Enumeration enumeration = this.reservations.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
            if (!reservationEntry.agent.equals(string)) continue;
            n += reservationEntry.amount;
        }
        return n;
    }

    public synchronized void changeReservedAmount(String string, int n) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        Assert.notNull(reservationEntry);
        Assert.notFalse(reservationEntry.amount >= n);
        reservationEntry.amount = n;
    }

    public synchronized boolean cancelReservation(String string) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.remove(string);
        return reservationEntry != null;
    }

    public synchronized boolean executeNow(String string, int n) {
        boolean bl = true;
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        if (!reservationEntry.consumed) {
            return true;
        }
        this.reservations.remove(string);
        boolean bl2 = this.reservationOK(n, reservationEntry.consumed, reservationEntry.amount);
        this.reservations.put(string, reservationEntry);
        return bl2;
    }

    public synchronized boolean newStartTime(String string, int n) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.remove(string);
        if (this.reserve(string, n, reservationEntry.consumed, reservationEntry.amount, reservationEntry.agent, reservationEntry.goalId, reservationEntry.comms_key)) {
            return true;
        }
        this.reservations.put(string, reservationEntry);
        return false;
    }

    public synchronized boolean reserve(ReservationEntry reservationEntry) {
        return this.reserve(reservationEntry.id, reservationEntry.start, reservationEntry.consumed, reservationEntry.amount, reservationEntry.agent, reservationEntry.goalId, reservationEntry.comms_key);
    }

    public synchronized boolean reserve(String string, int n, boolean bl, int n2, String string2, String string3, String string4) {
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.get(string);
        if (reservationEntry != null) {
            Assert.notFalse(reservationEntry.start == n && reservationEntry.consumed == bl && reservationEntry.amount == n2 && reservationEntry.agent.equals(string2) && reservationEntry.goalId.equals(string3) && reservationEntry.comms_key.equals(string4));
            return true;
        }
        if (!this.reservationOK(n, bl, n2)) {
            return false;
        }
        reservationEntry = new ReservationEntry(string, n, bl, n2, string2, string3, string4);
        ReservationEntry reservationEntry2 = this.reservations.put(string, reservationEntry);
        if (reservationEntry2 != null) {
            System.err.println("SuppliedItem reserve: multiple entries for same observer " + string);
            System.err.println("Previous = " + reservationEntry2);
            System.err.println("Current = " + reservationEntry);
        }
        return true;
    }

    public int consumed(String string) {
        int n = this.fact.getNumber();
        ReservationEntry reservationEntry = (ReservationEntry)this.reservations.remove(string);
        int n2 = !reservationEntry.consumed ? 0 : (reservationEntry.amount < n ? 1 : 2);
        if (n2 == 1) {
            this.fact.setNumber(n - reservationEntry.amount);
        }
        return n2;
    }

    public String toString() {
        String string = "(";
        string = string + ":id " + this.id + " " + ":link \"" + this.link + "\" " + ":fact " + this.fact + " " + ":supplier " + this.supplier;
        Enumeration enumeration = this.reservations.elements();
        if (enumeration.hasMoreElements()) {
            string = string + " :reservations (";
            while (enumeration.hasMoreElements()) {
                ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
                string = string + reservationEntry;
            }
            string = string + ")";
        }
        string = string + ")";
        return string;
    }

    public SuppliedItem duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public SuppliedItem duplicate(DuplicationTable duplicationTable) {
        Fact fact = this.fact.duplicate(duplicationTable);
        SuppliedItem suppliedItem = new SuppliedItem(this.id, this.link, this.supplier, fact);
        Enumeration enumeration = this.reservations.elements();
        while (enumeration.hasMoreElements()) {
            ReservationEntry reservationEntry = (ReservationEntry)enumeration.nextElement();
            suppliedItem.reserve(reservationEntry.id, reservationEntry.start, reservationEntry.consumed, reservationEntry.amount, reservationEntry.agent, reservationEntry.goalId, reservationEntry.comms_key);
        }
        return suppliedItem;
    }
}

