/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.AbstractTask;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.ResolutionContext;
import zeus.concepts.Task;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class SummaryTask
extends Task {
    protected Vector nodes = new Vector();
    protected Vector links = new Vector();
    protected boolean autorun = false;

    public SummaryTask() {
        this.type = 1;
        TaskNode taskNode = new TaskNode("begin");
        this.nodes.addElement(taskNode);
        taskNode = new TaskNode("end");
        this.nodes.addElement(taskNode);
    }

    public SummaryTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray, LogicalFn[] logicalFnArray) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setNodes(taskNodeArray);
        this.setLinks(taskLinkArray);
        this.setConstraints(logicalFnArray);
    }

    public SummaryTask(String string, String string2, String string3, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray, LogicalFn[] logicalFnArray) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(string2);
        this.setCostFn(string3);
        this.setNodes(taskNodeArray);
        this.setLinks(taskLinkArray);
        this.setConstraints(logicalFnArray);
    }

    public SummaryTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, Vector vector, Vector vector2, Vector vector3) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setNodes(vector);
        this.setLinks(vector2);
        this.setConstraints(vector3);
    }

    public SummaryTask(String string, String string2, String string3, Vector vector, Vector vector2, Vector vector3) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(string2);
        this.setCostFn(string3);
        this.setNodes(vector);
        this.setLinks(vector2);
        this.setConstraints(vector3);
    }

    public SummaryTask(SummaryTask summaryTask) {
        this.type = 1;
        this.name = summaryTask.getName();
        this.cost = summaryTask.getCostFn();
        this.time = summaryTask.getTimeFn();
        this.setNodes(summaryTask.getNodes());
        this.setLinks(summaryTask.getLinks());
        this.setConstraints(summaryTask.getConstraints());
    }

    public Vector links() {
        return this.links;
    }

    public Vector constraints() {
        return this.constraints;
    }

    public Fact[] getPostconditions() {
        TaskNode taskNode = this.getNode("end");
        return taskNode.getPreconditions();
    }

    public Fact[] getPreconditions() {
        TaskNode taskNode = this.getNode("begin");
        return taskNode.getPostconditions();
    }

    public TaskNode getNode(String string) {
        TaskNode taskNode = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            taskNode = (TaskNode)this.nodes.elementAt(i);
            if (!taskNode.getName().equals(string)) continue;
            return taskNode;
        }
        return null;
    }

    public Fact[] allFacts() {
        Fact[] factArray;
        int n;
        Vector<Fact> vector = new Vector<Fact>();
        for (n = 0; n < this.nodes.size(); ++n) {
            int n2;
            TaskNode taskNode = (TaskNode)this.nodes.elementAt(n);
            if (taskNode.getName().equals("begin") || taskNode.getName().equals("end")) continue;
            factArray = taskNode.getPreconditions();
            for (n2 = 0; n2 < factArray.length; ++n2) {
                vector.addElement(factArray[n2]);
            }
            if (taskNode.isConditionalNode()) continue;
            factArray = taskNode.getPostconditions();
            for (n2 = 0; n2 < factArray.length; ++n2) {
                vector.addElement(factArray[n2]);
            }
        }
        factArray = new Fact[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            factArray[n] = new Fact((Fact)vector.elementAt(n));
        }
        vector = null;
        return factArray;
    }

    public boolean applyConstraints(Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        if (!super.applyConstraints(bindings2)) {
            return false;
        }
        for (int i = 0; i < this.links.size(); ++i) {
            Fact fact;
            TaskLink taskLink = (TaskLink)this.links.elementAt(i);
            String string = taskLink.getLeftNode();
            String string2 = taskLink.getRightNode();
            if (string.equals("begin") || string2.equals("end")) continue;
            TaskNode taskNode = this.getNode(string);
            TaskNode taskNode2 = this.getNode(string2);
            Fact fact2 = taskNode.getPostcondition(taskLink.getLeftGroup(), taskLink.getLeftArg());
            if (fact2.unifiesWith(fact = taskNode2.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg()), bindings2)) continue;
            return false;
        }
        if (this.resolve(bindings2)) {
            bindings.set(bindings2);
            return true;
        }
        return false;
    }

    public ResolutionContext getContext() {
        if (this.resolution_context != null) {
            return this.resolution_context;
        }
        this.resolution_context = new ResolutionContext();
        for (int i = 0; i < this.nodes.size(); ++i) {
            TaskNode taskNode = (TaskNode)this.nodes.elementAt(i);
            this.resolution_context.add(taskNode.produced());
            this.resolution_context.add(taskNode.consumed());
        }
        return this.resolution_context;
    }

    public boolean resolve(Bindings bindings) {
        ResolutionContext resolutionContext = this.getContext();
        this.time = this.time.resolve(resolutionContext, bindings);
        if (this.time == null) {
            return false;
        }
        this.cost = this.cost.resolve(resolutionContext, bindings);
        if (this.cost == null) {
            return false;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            TaskNode taskNode = (TaskNode)this.nodes.elementAt(i);
            if (taskNode.resolve(resolutionContext, bindings)) continue;
            return false;
        }
        return true;
    }

    public TaskNode[] getNodes() {
        TaskNode[] taskNodeArray = new TaskNode[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            taskNodeArray[i] = new TaskNode((TaskNode)this.nodes.elementAt(i));
        }
        return taskNodeArray;
    }

    public void setNodes(Vector vector) {
        this.nodes.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.nodes.addElement(new TaskNode((TaskNode)vector.elementAt(i)));
        }
    }

    public void setNodes(TaskNode[] taskNodeArray) {
        this.nodes.removeAllElements();
        for (int i = 0; i < taskNodeArray.length; ++i) {
            this.nodes.addElement(new TaskNode(taskNodeArray[i]));
        }
    }

    public TaskLink[] getLinks() {
        TaskLink[] taskLinkArray = new TaskLink[this.links.size()];
        for (int i = 0; i < this.links.size(); ++i) {
            taskLinkArray[i] = new TaskLink((TaskLink)this.links.elementAt(i));
        }
        return taskLinkArray;
    }

    public void setLinks(Vector vector) {
        this.links.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.links.addElement(new TaskLink((TaskLink)vector.elementAt(i)));
        }
    }

    public void setLinks(TaskLink[] taskLinkArray) {
        this.links.removeAllElements();
        for (int i = 0; i < taskLinkArray.length; ++i) {
            this.links.addElement(new TaskLink(taskLinkArray[i]));
        }
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        int n;
        String string = "(:" + TaskTypes[this.type] + " " + this.name + " ";
        string = string + ":is_autorun " + this.autorun + " ";
        string = string + ":time (" + this.time + ") ";
        string = string + ":cost (" + this.cost + ") ";
        if (!this.nodes.isEmpty()) {
            string = string + ":nodes (";
            for (n = 0; n < this.nodes.size(); ++n) {
                string = string + this.nodes.elementAt(n);
            }
            string = string + ") ";
        }
        if (!this.links.isEmpty()) {
            string = string + ":links (";
            for (n = 0; n < this.links.size(); ++n) {
                string = string + this.links.elementAt(n);
            }
            string = string + ") ";
        }
        if (!this.constraints.isEmpty()) {
            string = string + ":constraints (";
            for (n = 0; n < this.constraints.size(); ++n) {
                string = string + "(" + this.constraints.elementAt(n) + ")";
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint(int n) {
        int n2;
        String string;
        String string2;
        String string3 = Misc.spaces(n);
        String string4 = "\n" + string3 + " ";
        String string5 = "(:" + TaskTypes[this.type] + " " + this.name + string4;
        string5 = string5 + ":is_autorun " + this.autorun + string4;
        string5 = string5 + ":time (" + this.time + ")" + string4;
        string5 = string5 + ":cost (" + this.cost + ")" + string4;
        if (!this.nodes.isEmpty()) {
            string2 = ":nodes ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.nodes.size(); ++n2) {
                string5 = string5 + ((TaskNode)this.nodes.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.links.isEmpty()) {
            string2 = ":links ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.links.size(); ++n2) {
                string5 = string5 + ((TaskLink)this.links.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.constraints.isEmpty()) {
            string2 = ":constraints ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(" + "\n" + string + " ";
            for (n2 = 0; n2 < this.constraints.size(); ++n2) {
                string5 = string5 + "(" + (LogicalFn)this.constraints.elementAt(n2) + ")" + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        return string3 + string5.trim() + "\n" + string3 + ")";
    }

    public AbstractTask duplicate(DuplicationTable duplicationTable) {
        int n;
        TaskNode[] taskNodeArray = new TaskNode[this.nodes.size()];
        TaskLink[] taskLinkArray = new TaskLink[this.links.size()];
        LogicalFn[] logicalFnArray = new LogicalFn[this.constraints.size()];
        ValueFunction valueFunction = this.time.duplicate(duplicationTable);
        ValueFunction valueFunction2 = this.cost.duplicate(duplicationTable);
        for (n = 0; n < this.nodes.size(); ++n) {
            taskNodeArray[n] = ((TaskNode)this.nodes.elementAt(n)).duplicate(duplicationTable);
        }
        for (n = 0; n < this.links.size(); ++n) {
            taskLinkArray[n] = ((TaskLink)this.links.elementAt(n)).duplicate(duplicationTable);
        }
        for (n = 0; n < this.constraints.size(); ++n) {
            logicalFnArray[n] = (LogicalFn)((LogicalFn)this.constraints.elementAt(n)).duplicate(duplicationTable);
        }
        return new SummaryTask(this.name, valueFunction, valueFunction2, taskNodeArray, taskLinkArray, logicalFnArray);
    }
}

