/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class StrategyInfo {
    public static final int USE = 0;
    public static final int NO_USE = 1;
    public static final String DEFAULT_INITIATOR_STRATEGY = SystemProps.getProperty("system.strategy.initiator.default", "NO_DEFAULT_STRATEGY_AVAILABLE");
    public static final String DEFAULT_RESPONDENT_STRATEGY = SystemProps.getProperty("system.strategy.respondent.default", "NO_DEFAULT_STRATEGY_AVAILABLE");
    protected Fact fact;
    protected String strategy = null;
    protected Vector agents = new Vector();
    protected Vector relations = new Vector();
    protected int type = 0;
    protected Hashtable parameters = new Hashtable();

    public StrategyInfo() {
    }

    public StrategyInfo(Fact fact) {
        this.fact = new Fact(fact);
        this.type = 1;
    }

    public StrategyInfo(Fact fact, String string) {
        this.fact = new Fact(fact);
        this.type = 0;
        this.strategy = string;
    }

    public StrategyInfo(Fact fact, String string, String[] stringArray, String[] stringArray2, Hashtable hashtable) {
        this.fact = new Fact(fact);
        this.type = 0;
        this.strategy = string;
        this.setAgents(stringArray);
        this.setRelations(stringArray2);
        this.setParameters(hashtable);
    }

    public StrategyInfo(Fact fact, String[] stringArray, String[] stringArray2) {
        this.fact = new Fact(fact);
        this.type = 1;
        this.setAgents(stringArray);
        this.setRelations(stringArray2);
    }

    public StrategyInfo(StrategyInfo strategyInfo) {
        this.fact = new Fact(strategyInfo.getFact());
        this.type = strategyInfo.getType();
        if (this.type == 0) {
            this.strategy = strategyInfo.getStrategy();
            this.setParameters(strategyInfo.getParameters());
        }
        this.setAgents(strategyInfo.getAgents());
        this.setRelations(strategyInfo.getRelations());
    }

    public StrategyInfo duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public StrategyInfo duplicate(DuplicationTable duplicationTable) {
        if (this.type == 0) {
            return new StrategyInfo(this.fact.duplicate(duplicationTable), this.strategy, this.getAgents(), this.getRelations(), this.getParameters());
        }
        return new StrategyInfo(this.fact.duplicate(duplicationTable), this.getAgents(), this.getRelations());
    }

    public void setType(int n) {
        Assert.notFalse(n == 0 || n == 1);
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public Fact getFact() {
        return this.fact;
    }

    public String getStrategy() {
        if (this.type == 1) {
            Core.USER_ERROR("Use/No_Use restriction error");
        }
        return this.strategy;
    }

    public Hashtable getParameters() {
        if (this.type == 1) {
            Core.USER_ERROR("Use/No_Use restriction error");
        }
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable.put(k, this.parameters.get(k));
        }
        return hashtable;
    }

    public String[] getAgents() {
        return Misc.stringArray(this.agents);
    }

    public String[] getRelations() {
        return Misc.stringArray(this.relations);
    }

    public void setStrategy(String string) {
        if (this.type == 1) {
            Core.USER_ERROR("Use/No_Use restriction error");
        }
        this.strategy = string;
    }

    public void setParameters(Hashtable hashtable) {
        if (this.type == 1) {
            Core.USER_ERROR("Use/No_Use restriction error");
        }
        this.parameters.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.parameters.put(k, hashtable.get(k));
        }
    }

    public void clearParameters() {
        if (this.type == 1) {
            Core.USER_ERROR("Use/No_Use restriction error");
        }
        this.parameters.clear();
    }

    public void setAgents(String[] stringArray) {
        this.agents = Misc.stringVector(stringArray);
    }

    public void setAgents(Vector vector) {
        this.agents = Misc.copyVector(vector);
    }

    public void setRelations(String[] stringArray) {
        this.relations = Misc.stringVector(stringArray);
    }

    public void setRelations(Vector vector) {
        this.relations = Misc.copyVector(vector);
    }

    public boolean resolve(Bindings bindings) {
        return this.fact.resolve(bindings);
    }

    public String toString() {
        String string = "(:fact " + this.fact + " " + ":type " + this.type + " ";
        if (this.type == 0) {
            string = string + ":strategy \"" + this.strategy + "\" ";
            if (!this.parameters.isEmpty()) {
                Enumeration enumeration = this.parameters.keys();
                string = string + ":parameters (";
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    string = string + "\"" + k + "\" \"" + this.parameters.get(k) + "\" ";
                }
                string = string.trim() + ")" + " ";
            }
        }
        if (!this.agents.isEmpty()) {
            string = string + ":agents (" + Misc.concat(this.agents) + ")" + " ";
        }
        if (!this.relations.isEmpty()) {
            string = string + ":relations (" + Misc.concat(this.relations) + ")";
        }
        return string.trim() + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:fact ";
        String string4 = string3 + this.fact.pprint(n + string3.length()) + string2 + ":type " + this.type + string2;
        if (this.type == 0) {
            string4 = string4 + ":strategy \"" + this.strategy + "\"" + string2;
            if (!this.parameters.isEmpty()) {
                Enumeration enumeration = this.parameters.keys();
                string4 = string4 + ":parameters (";
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    string4 = string4 + "\"" + k + "\" \"" + this.parameters.get(k) + "\" ";
                }
                string4 = string4.trim() + ")" + string2;
            }
        }
        if (!this.agents.isEmpty()) {
            string4 = string4 + ":agents (" + Misc.concat(this.agents) + ")" + string2;
        }
        if (!this.relations.isEmpty()) {
            string4 = string4 + ":relations (" + Misc.concat(this.relations) + ")" + string2;
        }
        return string4.trim() + "\n" + string + ")";
    }
}

