/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import zeus.concepts.Fact;
import zeus.util.Assert;
import zeus.util.Core;

public class ResourceItem
extends Observable {
    public static final String ALLOCATED = "Reserved";
    public static final String UNALLOCATED = "Free";
    public static final int UNCHANGED = 0;
    public static final int MODIFY = 1;
    public static final int DELETE = 2;
    protected Fact fact = null;
    protected Hashtable reservations = new Hashtable();

    public ResourceItem(Fact fact) {
        Assert.notNull(fact);
        this.fact = fact;
    }

    public Fact getFact() {
        return this.fact;
    }

    public synchronized boolean isReserved() {
        return !this.reservations.isEmpty();
    }

    public synchronized boolean reservationOK(int n, boolean bl, int n2) {
        return this.unreservedAmount(n, bl) >= n2;
    }

    public synchronized int unreservedAmount(int n, boolean bl) {
        return this.fact.getNumber() - this.reservedAmount(n, bl);
    }

    public synchronized int reservedAmount(int n, boolean bl) {
        Enumeration enumeration = this.reservations.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            if (bl) {
                if (!entry.consumed && entry.start <= n) continue;
                n2 += entry.amount;
                continue;
            }
            if (!entry.consumed || entry.start > n) continue;
            n2 += entry.amount;
        }
        return n2;
    }

    public int getReservedAmount(Observer observer) {
        Entry entry = (Entry)this.reservations.get(observer);
        return entry == null ? 0 : entry.amount;
    }

    public synchronized void changeReservedAmount(Observer observer, int n) {
        Entry entry = (Entry)this.reservations.get(observer);
        Assert.notNull(entry);
        Assert.notFalse(entry.amount >= n);
        entry.amount = n;
    }

    public synchronized void cancelReservation(Observer observer) {
        this.deleteObserver(observer);
        Entry entry = (Entry)this.reservations.remove(observer);
    }

    public synchronized boolean executeNow(Observer observer, int n) {
        boolean bl = true;
        Entry entry = (Entry)this.reservations.get(observer);
        if (!entry.consumed) {
            return true;
        }
        this.reservations.remove(observer);
        boolean bl2 = this.reservationOK(n, entry.consumed, entry.amount);
        this.reservations.put(observer, entry);
        return bl2;
    }

    public synchronized boolean newStartTime(Observer observer, int n) {
        Entry entry = (Entry)this.reservations.remove(observer);
        if (this.reserve(observer, n, entry.consumed, entry.amount)) {
            return true;
        }
        this.reservations.put(observer, entry);
        return false;
    }

    public synchronized boolean reserve(Observer observer, int n, boolean bl, int n2) {
        if (!this.reservationOK(n, bl, n2)) {
            return false;
        }
        Entry entry = new Entry(n, bl, n2);
        Entry entry2 = this.reservations.put(observer, entry);
        if (entry2 != null) {
            System.err.println("ResourceItem reserve: multiple entries for same observer " + observer);
            System.err.println("Previous = " + entry2);
            System.err.println("Current = " + entry);
        }
        this.addObserver(observer);
        return true;
    }

    public void deleted() {
        Core.DEBUG(3, "Notifying observers of deletion...\n" + this.fact.pprint());
        this.setChanged();
        this.notifyObservers("deleted");
    }

    public int consumed(Observer observer) {
        this.deleteObserver(observer);
        int n = this.fact.getNumber();
        Entry entry = (Entry)this.reservations.remove(observer);
        int n2 = !entry.consumed ? 0 : (entry.amount < n ? 1 : 2);
        if (n2 == 1) {
            this.fact.setNumber(n - entry.amount);
        }
        return n2;
    }

    protected class Entry {
        public int start;
        public boolean consumed;
        public int amount;

        public Entry(int n, boolean bl, int n2) {
            this.start = n;
            this.consumed = bl;
            this.amount = n2;
        }

        public String toString() {
            return "(:start " + this.start + " " + ":consumed " + this.consumed + " " + ":amount " + this.amount + ")";
        }
    }
}

