/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.Fact;
import zeus.util.Assert;
import zeus.util.Misc;

public class ReportRec {
    protected String name = null;
    protected String goal = null;
    protected String task = null;
    protected String agent = null;
    protected int state;
    protected String owner = null;
    protected String root_id = null;
    protected int start_time = 0;
    protected int end_time = 0;
    protected double cost = 0.0;
    protected String parent = null;
    protected Vector children = new Vector();
    protected Vector siblings = new Vector();
    protected Vector parents = new Vector();
    protected Vector consumed = new Vector();
    protected Vector produced = new Vector();

    ReportRec(String string, String string2) {
        Assert.notNull(string);
        Assert.notNull(string2);
        this.name = string;
        this.goal = string2;
    }

    public ReportRec(String string, String string2, String string3, String string4, int n, String string5, String string6, String string7, int n2, int n3, double d, Vector vector, Vector vector2, Vector vector3, Fact[] factArray, Fact[] factArray2) {
        this(string, string2);
        this.setTask(string3);
        this.setAgent(string4);
        this.setState(n);
        this.setOwner(string5);
        this.setRootId(string6);
        this.setStartTime(n2);
        this.setEndTime(n3);
        this.setCost(d);
        this.setParent(string7);
        this.setChildren(vector);
        this.setSiblings(vector2);
        this.setParents(vector3);
        this.setPreconditions(factArray);
        this.setPostconditions(factArray2);
    }

    public ReportRec(ReportRec reportRec) {
        this(reportRec.getName(), reportRec.getGoal());
        this.setTask(reportRec.getTask());
        this.setAgent(reportRec.getAgent());
        this.setState(reportRec.getState());
        this.setOwner(reportRec.getOwner());
        this.setStartTime(reportRec.getStartTime());
        this.setEndTime(reportRec.getEndTime());
        this.setCost(reportRec.getCost());
        this.setRootId(reportRec.getRootId());
        this.setParent(reportRec.getParent());
        this.setChildren(reportRec.getChildren());
        this.setSiblings(reportRec.getSiblings());
        this.setParents(reportRec.getParents());
        this.setPreconditions(reportRec.getPreconditions());
        this.setPostconditions(reportRec.getPostconditions());
    }

    public boolean hasNoParents() {
        return this.parents.isEmpty();
    }

    public boolean hasOneParentOnly(String string) {
        Assert.notNull(string);
        return this.parents.contains(string) && this.parents.size() == 1;
    }

    public void removeParent(String string) {
        Assert.notNull(string);
        this.parents.removeElement(string);
    }

    public void setTask(String string) {
        Assert.notNull(string);
        this.task = string;
    }

    public void setAgent(String string) {
        Assert.notNull(string);
        this.agent = string;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setOwner(String string) {
        Assert.notNull(string);
        this.owner = string;
    }

    public void setParent(String string) {
        String string2 = this.parent;
        this.parent = string;
        if (string2 != null) {
            this.parents.removeElement(string2);
        }
        if (string != null) {
            this.parents.addElement(string);
        }
    }

    public void setRootId(String string) {
        Assert.notNull(string);
        this.root_id = string;
    }

    public void setSiblings(Vector vector) {
        this.siblings.removeAllElements();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            this.siblings.addElement(vector.elementAt(i));
        }
    }

    public void setChildren(Vector vector) {
        this.children.removeAllElements();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            this.children.addElement(vector.elementAt(i));
        }
    }

    public void setParents(Vector vector) {
        this.parents.removeAllElements();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            this.parents.addElement(vector.elementAt(i));
        }
        if (this.parent != null && !this.parents.contains(this.parent)) {
            this.parents.addElement(this.parent);
        }
    }

    public void setSiblings(String[] stringArray) {
        this.siblings.removeAllElements();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.siblings.addElement(stringArray[i]);
        }
    }

    public void setChildren(String[] stringArray) {
        this.children.removeAllElements();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.children.addElement(stringArray[i]);
        }
    }

    public void setParents(String[] stringArray) {
        this.parents.removeAllElements();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.parents.addElement(stringArray[i]);
        }
        if (this.parent != null && !this.parents.contains(this.parent)) {
            this.parents.addElement(this.parent);
        }
    }

    public void setPostconditions(Vector vector) {
        this.produced.removeAllElements();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            this.produced.addElement((Fact)vector.elementAt(i));
        }
    }

    public void setPostconditions(Fact[] factArray) {
        this.produced.removeAllElements();
        for (int i = 0; factArray != null && i < factArray.length; ++i) {
            this.produced.addElement(factArray[i]);
        }
    }

    public void setPreconditions(Vector vector) {
        this.consumed.removeAllElements();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            this.consumed.addElement((Fact)vector.elementAt(i));
        }
    }

    public void setPreconditions(Fact[] factArray) {
        this.consumed.removeAllElements();
        for (int i = 0; factArray != null && i < factArray.length; ++i) {
            this.consumed.addElement(factArray[i]);
        }
    }

    public void addChild(String string) {
        if (!this.children.contains(string)) {
            this.children.addElement(string);
        }
    }

    public boolean hasChild(String string) {
        return this.children.contains(string);
    }

    public void addSibling(String string) {
        if (!this.siblings.contains(string)) {
            this.siblings.addElement(string);
        }
    }

    public boolean hasSibling(String string) {
        return this.siblings.contains(string);
    }

    public void addParent(String string) {
        if (!this.parents.contains(string)) {
            this.parents.addElement(string);
        }
    }

    public boolean hasParent(String string) {
        return this.parents.contains(string);
    }

    public void setEndTime(int n) {
        Assert.notFalse(n >= 0);
        this.end_time = n;
    }

    public void setStartTime(int n) {
        Assert.notFalse(n >= 0);
        this.start_time = n;
    }

    public void setCost(double d) {
        Assert.notFalse(d >= 0.0);
        this.cost = d;
    }

    public String getName() {
        return this.name;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getTask() {
        return this.task;
    }

    public String getAgent() {
        return this.agent;
    }

    public int getState() {
        return this.state;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getParent() {
        return this.parent;
    }

    public String getRootId() {
        return this.root_id;
    }

    public boolean isRoot() {
        return this.name.equals(this.root_id);
    }

    public int getStartTime() {
        return this.start_time;
    }

    public int getEndTime() {
        return this.end_time;
    }

    public double getCost() {
        return this.cost;
    }

    public String[] getChildren() {
        String[] stringArray = new String[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            stringArray[i] = (String)this.children.elementAt(i);
        }
        return stringArray;
    }

    public String[] getSiblings() {
        String[] stringArray = new String[this.siblings.size()];
        for (int i = 0; i < this.siblings.size(); ++i) {
            stringArray[i] = (String)this.siblings.elementAt(i);
        }
        return stringArray;
    }

    public String[] getParents() {
        String[] stringArray = new String[this.parents.size()];
        for (int i = 0; i < this.parents.size(); ++i) {
            stringArray[i] = (String)this.parents.elementAt(i);
        }
        return stringArray;
    }

    public Fact[] getPreconditions() {
        Fact[] factArray = new Fact[this.consumed.size()];
        for (int i = 0; i < this.consumed.size(); ++i) {
            factArray[i] = (Fact)this.consumed.elementAt(i);
        }
        return factArray;
    }

    public Fact[] getPostconditions() {
        Fact[] factArray = new Fact[this.produced.size()];
        for (int i = 0; i < this.produced.size(); ++i) {
            factArray[i] = (Fact)this.produced.elementAt(i);
        }
        return factArray;
    }

    public String toString() {
        int n;
        String string = new String("(");
        string = string + ":name " + this.name + " ";
        string = string + ":goal " + this.goal + " ";
        string = string + ":task " + this.task + " ";
        string = string + ":agent " + this.agent + " ";
        string = string + ":state " + this.state + " ";
        string = string + ":owner " + this.owner + " ";
        string = string + ":root_id " + this.root_id + " ";
        if (this.parent != null) {
            string = string + ":parent " + this.parent + " ";
        }
        string = string + ":start_time " + this.start_time + " ";
        string = string + ":end_time " + this.end_time + " ";
        string = string + ":cost " + this.cost + " ";
        if (!this.children.isEmpty()) {
            string = string + ":children (";
            for (n = 0; n < this.children.size(); ++n) {
                string = string + (String)this.children.elementAt(n) + " ";
            }
            string = string.trim() + ") ";
        }
        if (!this.siblings.isEmpty()) {
            string = string + ":siblings (";
            for (n = 0; n < this.siblings.size(); ++n) {
                string = string + (String)this.siblings.elementAt(n) + " ";
            }
            string = string.trim() + ") ";
        }
        if (!this.parents.isEmpty()) {
            string = string + ":parents (";
            for (n = 0; n < this.parents.size(); ++n) {
                string = string + (String)this.parents.elementAt(n) + " ";
            }
            string = string.trim() + ") ";
        }
        if (!this.consumed.isEmpty()) {
            string = string + ":consumed_facts (";
            for (n = 0; n < this.consumed.size(); ++n) {
                string = string + ((Fact)this.consumed.elementAt(n)).toString();
            }
            string = string + ") ";
        }
        if (!this.produced.isEmpty()) {
            string = string + ":produced_facts (";
            for (n = 0; n < this.produced.size(); ++n) {
                string = string + ((Fact)this.produced.elementAt(n)).toString();
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        int n2;
        String string;
        String string2;
        String string3 = Misc.spaces(n);
        String string4 = "\n" + string3 + " ";
        String string5 = new String("(");
        string5 = string5 + ":name " + this.name + string4;
        string5 = string5 + ":goal " + this.goal + string4;
        string5 = string5 + ":task " + this.task + string4;
        string5 = string5 + ":agent " + this.agent + string4;
        string5 = string5 + ":state " + this.state + string4;
        string5 = string5 + ":owner " + this.owner + string4;
        string5 = string5 + ":root_id " + this.root_id + string4;
        if (this.parent != null) {
            string5 = string5 + ":parent " + this.parent + string4;
        }
        string5 = string5 + ":start_time " + this.start_time + string4;
        string5 = string5 + ":end_time " + this.end_time + string4;
        string5 = string5 + ":cost " + this.cost + string4;
        if (!this.children.isEmpty()) {
            string2 = ":children ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.children.size(); ++n2) {
                string5 = string5 + (String)this.children.elementAt(n2) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.siblings.isEmpty()) {
            string2 = ":siblings ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.siblings.size(); ++n2) {
                string5 = string5 + (String)this.siblings.elementAt(n2) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.parents.isEmpty()) {
            string2 = ":parents ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.parents.size(); ++n2) {
                string5 = string5 + (String)this.parents.elementAt(n2) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.consumed.isEmpty()) {
            string2 = ":consumed_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.consumed.size(); ++n2) {
                string5 = string5 + ((Fact)this.consumed.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.produced.isEmpty()) {
            string2 = ":produced_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.produced.size(); ++n2) {
                string5 = string5 + ((Fact)this.produced.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        return string5.trim() + "\n" + string3 + ")";
    }
}

