/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.StrategyInfo;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Misc;

public class ProtocolInfo {
    public static final String INITIATOR = "Initiator";
    public static final String RESPONDENT = "Respondent";
    protected String name;
    protected String type;
    protected Vector constraints = new Vector();

    public ProtocolInfo() {
    }

    public ProtocolInfo(String string, String string2, Fact fact) {
        Assert.notNull(string);
        Assert.notFalse(string2.equals(INITIATOR) || string2.equals(RESPONDENT));
        this.name = string;
        this.type = string2;
        String string3 = string2.equals(RESPONDENT) ? StrategyInfo.DEFAULT_RESPONDENT_STRATEGY : StrategyInfo.DEFAULT_INITIATOR_STRATEGY;
        StrategyInfo strategyInfo = new StrategyInfo(fact, string3);
        this.constraints.addElement(strategyInfo);
    }

    public ProtocolInfo(String string, String string2, StrategyInfo[] strategyInfoArray) {
        Assert.notNull(string);
        Assert.notFalse(string2.equals(INITIATOR) || string2.equals(RESPONDENT));
        this.name = string;
        this.type = string2;
        this.setConstraints(strategyInfoArray);
    }

    public ProtocolInfo(String string, String string2, Vector vector) {
        Assert.notNull(string);
        Assert.notFalse(string2.equals(INITIATOR) || string2.equals(RESPONDENT));
        this.name = string;
        this.type = string2;
        this.setConstraints(vector);
    }

    public ProtocolInfo(ProtocolInfo protocolInfo) {
        this.name = protocolInfo.getName();
        this.type = protocolInfo.getType();
        this.setConstraints(protocolInfo.getConstraints());
    }

    public ProtocolInfo duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public ProtocolInfo duplicate(DuplicationTable duplicationTable) {
        Vector<StrategyInfo> vector = new Vector<StrategyInfo>();
        for (int i = 0; i < this.constraints.size(); ++i) {
            StrategyInfo strategyInfo = (StrategyInfo)this.constraints.elementAt(i);
            vector.addElement(strategyInfo.duplicate(duplicationTable));
        }
        return new ProtocolInfo(this.name, this.type, vector);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public StrategyInfo[] getConstraints() {
        StrategyInfo[] strategyInfoArray = new StrategyInfo[this.constraints.size()];
        for (int i = 0; i < this.constraints.size(); ++i) {
            strategyInfoArray[i] = new StrategyInfo((StrategyInfo)this.constraints.elementAt(i));
        }
        return strategyInfoArray;
    }

    public void setConstraints(StrategyInfo[] strategyInfoArray) {
        this.constraints.removeAllElements();
        if (strategyInfoArray == null) {
            return;
        }
        for (int i = 0; i < strategyInfoArray.length; ++i) {
            this.constraints.addElement(new StrategyInfo(strategyInfoArray[i]));
        }
    }

    public void setConstraints(Vector vector) {
        this.constraints.removeAllElements();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.constraints.addElement(new StrategyInfo((StrategyInfo)vector.elementAt(i)));
        }
    }

    public boolean resolve(Bindings bindings) {
        StrategyInfo strategyInfo;
        boolean bl = true;
        for (int i = 0; bl && i < this.constraints.size(); bl &= strategyInfo.resolve(bindings), ++i) {
            strategyInfo = (StrategyInfo)this.constraints.elementAt(i);
        }
        return bl;
    }

    public String toString() {
        String string = "(:name \"" + this.name + "\" :type " + this.type;
        string = string + " :constraints (" + Misc.concat(this.constraints) + ")";
        string = string + ")";
        return string;
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = string + "(:name \"" + this.name + "\"" + string2 + ":type " + this.type + string2;
        String string4 = ":constraints ";
        String string5 = Misc.spaces(1 + n + string4.length());
        string3 = string3 + string4 + "(";
        for (int i = 0; i < this.constraints.size(); ++i) {
            string3 = string3 + ((StrategyInfo)this.constraints.elementAt(i)).pprint(1 + string5.length()) + "\n" + string5 + " ";
        }
        string3 = string3.trim() + "\n" + string5 + ")" + string2;
        return string3.trim() + "\n" + string + ")";
    }
}

