/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.AbstractTask;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.Ordering;
import zeus.concepts.ResolutionContext;
import zeus.concepts.Task;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Assert;
import zeus.util.Misc;

public class PrimitiveTask
extends Task {
    protected Vector consumed = new Vector();
    protected Vector produced = new Vector();
    protected Vector ordering = new Vector();
    public transient Vector _produced = null;
    protected int active_effect = -1;
    protected String external = null;

    public PrimitiveTask() {
        this.type = 0;
    }

    public PrimitiveTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, Fact[] factArray, Fact[] factArray2, LogicalFn[] logicalFnArray, Ordering[] orderingArray) {
        this();
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setPostconditions(factArray);
        this.setPreconditions(factArray2);
        this.setConstraints(logicalFnArray);
        this.setOrdering(orderingArray);
    }

    public PrimitiveTask(String string, String string2, String string3, Fact[] factArray, Fact[] factArray2, LogicalFn[] logicalFnArray, Ordering[] orderingArray) {
        this();
        this.setName(string);
        this.setTimeFn(string2);
        this.setCostFn(string3);
        this.setPostconditions(factArray);
        this.setPreconditions(factArray2);
        this.setConstraints(logicalFnArray);
        this.setOrdering(orderingArray);
    }

    public PrimitiveTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this();
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setPostconditions(vector);
        this.setPreconditions(vector2);
        this.setConstraints(vector3);
        this.setOrdering(vector4);
    }

    public PrimitiveTask(PrimitiveTask primitiveTask) {
        this();
        this.name = primitiveTask.getName();
        this.cost = primitiveTask.getCostFn();
        this.time = primitiveTask.getTimeFn();
        this.setPostconditions(primitiveTask.getPostconditions());
        this.setPreconditions(primitiveTask.getPreconditions());
        this.setConstraints(primitiveTask.getConstraints());
        this.setOrdering(primitiveTask.getOrdering());
        this.setActiveEffect(primitiveTask.getActiveEffectPos());
    }

    public boolean hasExternal() {
        return this.external != null;
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String string) {
        this.external = string;
    }

    public void setPostconditions(Vector vector) {
        this.produced.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.produced.addElement(new Fact((Fact)vector.elementAt(i)));
        }
    }

    public void setPostconditions(Fact[] factArray) {
        this.produced.removeAllElements();
        for (int i = 0; i < factArray.length; ++i) {
            this.produced.addElement(new Fact(factArray[i]));
        }
    }

    public void setPreconditions(Vector vector) {
        this.consumed.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.consumed.addElement(new Fact((Fact)vector.elementAt(i)));
        }
    }

    public void setPreconditions(Fact[] factArray) {
        this.consumed.removeAllElements();
        for (int i = 0; i < factArray.length; ++i) {
            this.consumed.addElement(new Fact(factArray[i]));
        }
    }

    public Fact[] getPostconditions() {
        Fact[] factArray = new Fact[this.produced.size()];
        for (int i = 0; i < this.produced.size(); ++i) {
            factArray[i] = new Fact((Fact)this.produced.elementAt(i));
        }
        return factArray;
    }

    public Fact[] getOriginalPostconditions() {
        if (this._produced == null) {
            return this.getPostconditions();
        }
        Fact[] factArray = new Fact[this._produced.size()];
        for (int i = 0; i < this._produced.size(); ++i) {
            factArray[i] = new Fact((Fact)this._produced.elementAt(i));
        }
        return factArray;
    }

    public void preprocess() {
        Fact fact;
        int n;
        boolean bl = false;
        for (n = 0; !bl && n < this.consumed.size(); ++n) {
            fact = (Fact)this.consumed.elementAt(n);
            bl = fact.isReplaced();
        }
        if (!bl) {
            return;
        }
        this._produced = Misc.copyVector(this.produced);
        for (n = 0; n < this.consumed.size(); ++n) {
            fact = (Fact)this.consumed.elementAt(n);
            if (!fact.isReplaced()) continue;
            this.produced.addElement(fact);
        }
    }

    public int countPreconditions() {
        return this.consumed.size();
    }

    public int countPostconditions() {
        return this.produced.size();
    }

    public int[] numPreconditions() {
        int[] nArray = new int[this.consumed.size()];
        for (int i = 0; i < this.consumed.size(); ++i) {
            nArray[i] = ((Fact)this.consumed.elementAt(i)).getNumber();
        }
        return nArray;
    }

    public int[] numPostconditions() {
        int[] nArray = new int[this.produced.size()];
        for (int i = 0; i < this.produced.size(); ++i) {
            nArray[i] = ((Fact)this.produced.elementAt(i)).getNumber();
        }
        return nArray;
    }

    public Fact[] getPreconditions() {
        Fact[] factArray = new Fact[this.consumed.size()];
        for (int i = 0; i < this.consumed.size(); ++i) {
            factArray[i] = new Fact((Fact)this.consumed.elementAt(i));
        }
        return factArray;
    }

    public Fact getPrecondition(String string) {
        for (int i = 0; i < this.consumed.size(); ++i) {
            Fact fact = (Fact)this.consumed.elementAt(i);
            if (!string.equals(fact.getId())) continue;
            return fact;
        }
        return null;
    }

    public Fact getPostcondition(String string) {
        for (int i = 0; i < this.produced.size(); ++i) {
            Fact fact = (Fact)this.produced.elementAt(i);
            if (!string.equals(fact.getId())) continue;
            return fact;
        }
        return null;
    }

    public Fact getPrecondition(int n) {
        return (Fact)this.consumed.elementAt(n);
    }

    public Fact getPostcondition(int n) {
        return (Fact)this.produced.elementAt(n);
    }

    public int getConsumedPos(Fact fact) {
        String string = fact.getId();
        for (int i = 0; i < this.consumed.size(); ++i) {
            Fact fact2 = (Fact)this.consumed.elementAt(i);
            if (!string.equals(fact2.getId())) continue;
            return i;
        }
        Assert.notNull(null);
        return -1;
    }

    public int getProducedPos(Fact fact) {
        String string = fact.getId();
        for (int i = 0; i < this.produced.size(); ++i) {
            Fact fact2 = (Fact)this.produced.elementAt(i);
            if (!string.equals(fact2.getId())) continue;
            return i;
        }
        Assert.notNull(null);
        return -1;
    }

    public void relaxNumberFields() {
        ValueFunction valueFunction;
        Fact fact;
        int n;
        for (n = 0; n < this.consumed.size(); ++n) {
            fact = (Fact)this.consumed.elementAt(n);
            if (!fact.isa("Entity") || (valueFunction = fact.getFn("number")).getID() != 14) continue;
            fact.setValue("number", fact.newVar());
        }
        for (n = 0; n < this.produced.size(); ++n) {
            fact = (Fact)this.produced.elementAt(n);
            if (!fact.isa("Entity") || (valueFunction = fact.getFn("number")).getID() != 14) continue;
            fact.setValue("number", fact.newVar());
        }
    }

    public void setOrdering(Vector vector) {
        this.ordering.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.ordering.addElement(new Ordering((Ordering)vector.elementAt(i)));
        }
    }

    public void setOrdering(Ordering[] orderingArray) {
        this.ordering.removeAllElements();
        for (int i = 0; i < orderingArray.length; ++i) {
            this.ordering.addElement(new Ordering(orderingArray[i]));
        }
    }

    public Ordering[] getOrdering() {
        Ordering[] orderingArray = new Ordering[this.ordering.size()];
        for (int i = 0; i < this.ordering.size(); ++i) {
            orderingArray[i] = new Ordering((Ordering)this.ordering.elementAt(i));
        }
        return orderingArray;
    }

    public boolean resolve(Bindings bindings) {
        int n;
        boolean bl = true;
        ResolutionContext resolutionContext = this.getContext();
        this.time = this.time.resolve(resolutionContext, bindings);
        if (this.time == null) {
            return false;
        }
        this.cost = this.cost.resolve(resolutionContext, bindings);
        if (this.cost == null) {
            return false;
        }
        for (n = 0; bl && n < this.consumed.size(); bl &= ((Fact)this.consumed.elementAt(n)).resolve(resolutionContext, bindings), ++n) {
        }
        if (!bl) {
            return bl;
        }
        for (n = 0; bl && n < this.produced.size(); bl &= ((Fact)this.produced.elementAt(n)).resolve(resolutionContext, bindings), ++n) {
        }
        return bl;
    }

    public ResolutionContext getContext() {
        if (this.resolution_context != null) {
            return this.resolution_context;
        }
        this.resolution_context = new ResolutionContext();
        this.resolution_context.add(this.produced);
        this.resolution_context.add(this.consumed);
        return this.resolution_context;
    }

    public boolean applyConstraints(Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        if (!super.applyConstraints(bindings2)) {
            return false;
        }
        return this.resolve(bindings2) && bindings.add(bindings2);
    }

    public Fact[][] orderPreconditions() {
        int n;
        int n2;
        if (this.ordering.isEmpty()) {
            Fact[][] factArray = new Fact[1][this.consumed.size()];
            for (int i = 0; i < this.consumed.size(); ++i) {
                factArray[0][i] = (Fact)this.consumed.elementAt(i);
            }
            return factArray;
        }
        Vector<Vector> vector = new Vector<Vector>();
        Vector vector2 = new Vector();
        Vector<Fact> vector3 = new Vector<Fact>();
        Vector vector4 = new Vector();
        for (n2 = 0; n2 < this.consumed.size(); ++n2) {
            vector2.addElement(this.consumed.elementAt(n2));
        }
        for (n2 = 0; n2 < this.ordering.size(); ++n2) {
            vector4.addElement(this.ordering.elementAt(n2));
        }
        while (!vector4.isEmpty()) {
            Ordering ordering;
            String string;
            Fact fact;
            block4: for (n2 = 0; n2 < vector2.size(); ++n2) {
                fact = (Fact)vector2.elementAt(n2);
                string = fact.getId();
                for (n = 0; n < vector4.size(); ++n) {
                    ordering = (Ordering)vector4.elementAt(n);
                    if (!string.equals(ordering.getRHS())) continue;
                    vector3.addElement(fact);
                    vector2.removeElementAt(n2--);
                    continue block4;
                }
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                fact = (Fact)vector2.elementAt(n2);
                string = fact.getId();
                for (n = 0; n < vector4.size(); ++n) {
                    ordering = (Ordering)vector4.elementAt(n);
                    if (!string.equals(ordering.getLHS())) continue;
                    vector4.removeElementAt(n--);
                }
            }
            vector.addElement(vector2);
            vector2 = vector3;
            vector3 = new Vector();
        }
        if (!vector2.isEmpty()) {
            vector.addElement(vector2);
        }
        Fact[][] factArray = new Fact[vector.size()][];
        for (n = 0; n < vector.size(); ++n) {
            vector2 = (Vector)vector.elementAt(n);
            factArray[n] = new Fact[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                factArray[n][i] = (Fact)vector2.elementAt(i);
            }
        }
        return factArray;
    }

    public String toString() {
        int n;
        String string = "(:" + TaskTypes[this.type] + " " + this.name + " ";
        string = string + ":time (" + this.time + ") ";
        string = string + ":cost (" + this.cost + ") ";
        if (!this.consumed.isEmpty()) {
            string = string + ":consumed_facts (";
            for (n = 0; n < this.consumed.size(); ++n) {
                string = string + this.consumed.elementAt(n);
            }
            string = string + ") ";
        }
        if (!this.produced.isEmpty()) {
            string = string + ":produced_facts (";
            for (n = 0; n < this.produced.size(); ++n) {
                string = string + this.produced.elementAt(n);
            }
            string = string + ") ";
        }
        if (!this.constraints.isEmpty()) {
            string = string + ":constraints (";
            for (n = 0; n < this.constraints.size(); ++n) {
                string = string + "(" + this.constraints.elementAt(n) + ")";
            }
            string = string + ") ";
        }
        if (!this.ordering.isEmpty()) {
            string = string + ":ordering (";
            for (n = 0; n < this.ordering.size(); ++n) {
                string = string + this.ordering.elementAt(n);
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint(int n) {
        int n2;
        String string;
        String string2;
        String string3 = Misc.spaces(n);
        String string4 = "\n" + string3 + " ";
        String string5 = "(:" + TaskTypes[this.type] + " " + this.name + string4;
        string5 = string5 + ":time (" + this.time + ")" + string4;
        string5 = string5 + ":cost (" + this.cost + ")" + string4;
        if (!this.consumed.isEmpty()) {
            string2 = ":consumed_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.consumed.size(); ++n2) {
                string5 = string5 + ((Fact)this.consumed.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.produced.isEmpty()) {
            string2 = ":produced_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.produced.size(); ++n2) {
                string5 = string5 + ((Fact)this.produced.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.constraints.isEmpty()) {
            string2 = ":constraints ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(" + "\n" + string + " ";
            for (n2 = 0; n2 < this.constraints.size(); ++n2) {
                string5 = string5 + "(" + this.constraints.elementAt(n2) + ")" + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.ordering.isEmpty()) {
            string2 = ":ordering ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.ordering.size(); ++n2) {
                string5 = string5 + ((Ordering)this.ordering.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        return string3 + string5.trim() + "\n" + string3 + ")";
    }

    public boolean isValid() {
        return true;
    }

    public void setActiveEffect(int n) {
        Assert.notFalse(n >= -1 && n < this.produced.size());
        this.active_effect = n;
    }

    public Fact getActiveEffect() {
        return this.getPostcondition(this.active_effect);
    }

    public int getActiveEffectPos() {
        return this.active_effect;
    }

    public AbstractTask duplicate(DuplicationTable duplicationTable) {
        int n;
        Fact[] factArray = new Fact[this.consumed.size()];
        Fact[] factArray2 = new Fact[this.produced.size()];
        LogicalFn[] logicalFnArray = new LogicalFn[this.constraints.size()];
        Ordering[] orderingArray = new Ordering[this.ordering.size()];
        ValueFunction valueFunction = this.time.duplicate(duplicationTable);
        ValueFunction valueFunction2 = this.cost.duplicate(duplicationTable);
        for (n = 0; n < this.consumed.size(); ++n) {
            factArray[n] = ((Fact)this.consumed.elementAt(n)).duplicate(duplicationTable);
        }
        for (n = 0; n < this.produced.size(); ++n) {
            factArray2[n] = ((Fact)this.produced.elementAt(n)).duplicate(duplicationTable);
        }
        for (n = 0; n < this.constraints.size(); ++n) {
            logicalFnArray[n] = (LogicalFn)((LogicalFn)this.constraints.elementAt(n)).duplicate(duplicationTable);
        }
        for (n = 0; n < this.ordering.size(); ++n) {
            orderingArray[n] = ((Ordering)this.ordering.elementAt(n)).duplicate(duplicationTable);
        }
        PrimitiveTask primitiveTask = new PrimitiveTask(this.name, valueFunction, valueFunction2, factArray2, factArray, logicalFnArray, orderingArray);
        primitiveTask.setActiveEffect(this.active_effect);
        return primitiveTask;
    }
}

