/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.StringTokenizer;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Reference;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Misc;

public class Ordering
implements Reference {
    protected String lhs;
    protected String rhs;

    public Ordering() {
    }

    public Ordering(String string, String string2) {
        Assert.notNull(string);
        Assert.notNull(string2);
        this.lhs = string;
        this.rhs = string2;
    }

    public Ordering(Ordering ordering) {
        this.lhs = ordering.getLHS();
        this.rhs = ordering.getRHS();
    }

    public String getLHS() {
        return this.lhs;
    }

    public String getRHS() {
        return this.rhs;
    }

    public String getId() {
        return this.lhs + this.rhs;
    }

    public void setLHS(String string) {
        Assert.notNull(string);
        this.lhs = string;
    }

    public void setRHS(String string) {
        Assert.notNull(string);
        this.rhs = string;
    }

    public boolean equals(Ordering ordering) {
        return this.lhs.equals(ordering.getLHS()) && this.rhs.equals(ordering.getRHS());
    }

    public String toString() {
        return "(:lhs " + this.lhs + " " + ":rhs " + this.rhs + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:lhs " + this.lhs + string2 + ":rhs " + this.rhs + string2;
        return string3.trim() + "\n" + string + ")";
    }

    public boolean references(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.lhs, ".");
        String string2 = stringTokenizer.nextToken();
        return string2.equals(string);
    }

    public Ordering duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public Ordering duplicate(DuplicationTable duplicationTable) {
        VarFn varFn = new VarFn(this.lhs);
        VarFn varFn2 = new VarFn(this.rhs);
        String string = ((ValueFunction)varFn).duplicate(duplicationTable).toString();
        String string2 = ((ValueFunction)varFn2).duplicate(duplicationTable).toString();
        return new Ordering(string, string2);
    }
}

