/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.AttributeList;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.FactDescription;
import zeus.concepts.OntologyDbChangeEvent;
import zeus.concepts.OntologyParser;
import zeus.concepts.Performative;
import zeus.concepts.RestrictionParser;
import zeus.concepts.TokenMgrError;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.ontology.DAMLReader;
import zeus.ontology.DAMLWriter;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.OrderedHashtable;
import zeus.util.PrettyPrintWriter;
import zeus.util.SystemProps;
import zeus.util.Tree;
import zeus.util.TreeNode;

public class OntologyDb
extends Tree {
    public static final int RELOAD = 0;
    public static final int FACT_ADDED = 1;
    public static final int FACT_REMOVED = 2;
    public static final int FACT_RENAMED = 3;
    public static final int ATTRIBUTES_CHANGED = 4;
    public static final int RESTRICTION_ADDED = 5;
    public static final int RESTRICTION_REMOVED = 6;
    public static final int RESTRICTION_CHANGED = 7;
    public static final String ROOT = "ZeusFact";
    public static final String ABSTRACT = "Abstract";
    public static final String ENTITY = "Entity";
    public static final String MESSAGE = "Message";
    public static final String MONEY = "Money";
    public static final String AMOUNT = "amount";
    public static final String NUMBER = "number";
    public static final String COST = "unit_cost";
    public static final String GOAL_FACT = "fact";
    public static final int WARNING_MASK = 1;
    public static final int ERROR_MASK = 2;
    static final String BEGIN_ONTOLOGY = "BEGIN_ONTOLOGY";
    static final String BEGIN_PREAMBLE = "BEGIN_PREAMBLE";
    static final String BEGIN_RESTRICTIONS = "BEGIN_RESTRICTIONS";
    static final String BEGIN_RESTRICTION_ITEM = "BEGIN_RESTRICTION_ITEM";
    static final String BEGIN_FACTS = "BEGIN_FACTS";
    static final String BEGIN_FACT_ITEM = "BEGIN_FACT_ITEM";
    static final String BEGIN_ATTRIBUTE_LIST = "BEGIN_ATTRIBUTE_LIST";
    static final String BEGIN_ATTRIBUTE_ITEM = "BEGIN_ATTRIBUTE_ITEM";
    static final String END_PREAMBLE = "END_PREAMBLE";
    static final String END_RESTRICTION_ITEM = "END_RESTRICTION_ITEM";
    static final String END_RESTRICTIONS = "END_RESTRICTIONS";
    static final String END_ATTRIBUTE_ITEM = "END_ATTRIBUTE_ITEM";
    static final String END_ATTRIBUTE_LIST = "END_ATTRIBUTE_LIST";
    static final String END_FACT_ITEM = "END_FACT_ITEM";
    static final String END_FACTS = "END_FACTS";
    static final String END_ONTOLOGY = "END_ONTOLOGY";
    static final String SYSTEM_NAME = "ZEUS-Ontology-Editor";
    static final String SYSTEM = ":system";
    static final String VERSION = ":version";
    static final String NAME_TAG = ":name";
    static final String PARENT_TAG = ":parent";
    static final String TYPE_TAG = ":type";
    static final String VALUE_TAG = ":value";
    static final String REST_TAG = ":restriction";
    static final String DEFA_TAG = ":default";
    static final String QUOTE = "\"";
    static final int NAME = 0;
    static final int TYPE = 1;
    static final int RESTRICTION = 2;
    static final int DEFAULT = 3;
    protected static final String FACT_STR = "Fact";
    protected static final String NAME_STR = "name";
    protected static final String CSEP = "$";
    protected static final String TFILE = "oetf22";
    public static final String STRING = "String";
    public static final String INTEGER = "Integer";
    public static final String REAL = "Real";
    public static final String BOOLEAN = "Boolean";
    public static final String DATE = "Date";
    public static final String TIME = "Time";
    public static final String LIST = "List";
    public static final String OBJECT_TYPE = "JavaObject";
    public static final String[] BASIC_TYPES = new String[]{"String", "Integer", "Real", "Boolean", "Date", "Time", "List"};
    static final String[] PREDEFINED_FACTS = new String[]{"ZeusFact", "Money", "Abstract", "Message", "Entity"};
    public static final String[] GOAL_ATTRIBUTES = new String[]{"fact", "end_time", "cost", "confirm_time"};
    protected EventListenerList changeListeners = new EventListenerList();
    protected Hashtable factIndex;
    protected OrderedHashtable restrictions;
    protected int editableLimit;
    protected boolean save_needed = false;
    protected String error = null;
    protected String warning = null;
    protected String filename = null;
    protected String ontologyName = null;
    protected GenSym genSym = null;
    static final String HEADER = "<?xml version=\"1.0\">";
    static final String ELEMENT_TAG = "!ELEMENT";
    static final String ATTRIBUTE_TAG = "!ATTLIST";
    static final String LT = "<";
    static final String GT = ">";
    static final String SPACE = " ";
    static final String OPEN_BRACKET = "(";
    static final String CLOSE_BRACKET = ")";
    static final String COMMA = ",";
    static final String PCDATA = "#PCDATA";
    static final String CDATA = "CDATA";
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public OntologyDb() {
        super(new FactDescription(ROOT));
    }

    public OntologyDb(GenSym genSym) {
        super(new FactDescription(ROOT));
        Assert.notNull(genSym);
        this.genSym = genSym;
        this.factIndex = new Hashtable();
        this.restrictions = new OrderedHashtable();
        this.clear();
    }

    public GenSym GenSym() {
        return this.genSym;
    }

    public String getOntologyName() {
        return this.ontologyName;
    }

    public void clear() {
        this.factIndex.clear();
        this.restrictions.clear();
        this.root = new TreeNode(new FactDescription(ROOT));
        this.factIndex.put(ROOT, this.root);
        TreeNode treeNode = this.root.addChild(new FactDescription(ABSTRACT));
        this.factIndex.put(ABSTRACT, treeNode);
        TreeNode treeNode2 = treeNode.addChild(new FactDescription(MONEY));
        this.factIndex.put(MONEY, treeNode2);
        this.__addNewAttributeRow(MONEY, AMOUNT, REAL, "", "0");
        treeNode2 = treeNode.addChild(new FactDescription(MESSAGE));
        this.factIndex.put(MESSAGE, treeNode2);
        for (int i = 0; i < Performative.ATTRIBUTE_TYPES.length; ++i) {
            this.__addNewAttributeRow(MESSAGE, Performative.ATTRIBUTE_TYPES[i], STRING, "", "");
        }
        treeNode = this.root.addChild(new FactDescription(ENTITY));
        this.factIndex.put(ENTITY, treeNode);
        this.__addNewAttributeRow(ENTITY, NUMBER, INTEGER, "", "1");
        this.__addNewAttributeRow(ENTITY, COST, REAL, "", "0");
        this.editableLimit = 0;
        this.error = null;
        this.warning = null;
        this.filename = null;
        this.fireChanged(0, null);
        this.save_needed = false;
    }

    public boolean isSaveNeeded() {
        return this.save_needed;
    }

    public String getError() {
        return this.error;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getFilename() {
        return this.filename;
    }

    public void __setWarning(String string) {
        this.warning = this.warning == null ? string : this.warning + "\n" + string;
    }

    public int saveDAML(File file) {
        if (file == null) {
            return 2;
        }
        this.setFilename(file);
        String string = SystemProps.getProperty("daml.namespace") + file.getName() + "#";
        String string2 = "Created by ZEUS-Ontology-Editor " + SystemProps.getProperty("version.id");
        DAMLWriter dAMLWriter = new DAMLWriter(string, this.restrictions.elements(), this.nodes());
        return dAMLWriter.write(file, string2);
    }

    public int saveXML(File file) {
        Assert.notNull(file);
        int n = 0;
        int n2 = 0;
        this.error = null;
        try {
            String string = file.getParent();
            String string2 = string != null ? string + File.separator + TFILE : TFILE;
            File file2 = new File(string2);
            while (file2.exists()) {
                file2 = new File(string2 + n2++);
            }
            String string3 = file.getName();
            int n3 = string3.indexOf(46);
            String string4 = n3 == -1 ? string3 : string3.substring(0, n3);
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter(file2);
            prettyPrintWriter.pprint(0, HEADER);
            prettyPrintWriter.pprint(0, "<!DOCTYPE " + string4 + SPACE + "[");
            Enumeration enumeration = this.nodes();
            while (enumeration.hasMoreElements()) {
                int n4;
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                FactDescription factDescription = (FactDescription)treeNode.getValue();
                String string5 = factDescription.getName();
                if (Misc.member(string5, PREDEFINED_FACTS)) continue;
                String[][] stringArray = factDescription.getAttributes();
                String string6 = "<!ELEMENT " + string5 + SPACE + OPEN_BRACKET;
                Vector vector = this.getElementNodes(factDescription);
                if (!vector.isEmpty()) {
                    for (n4 = 0; n4 < vector.size(); ++n4) {
                        string6 = string6 + vector.elementAt(n4);
                        if (n4 >= vector.size() - 1) continue;
                        string6 = string6 + COMMA;
                    }
                } else {
                    string6 = string6 + PCDATA;
                }
                string6 = string6 + ")>";
                prettyPrintWriter.pprint(2, string6);
                if (this.hasBasicAttributes(factDescription)) {
                    prettyPrintWriter.pprint(2, "<!ATTLIST " + string5);
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (vector.contains(stringArray[n4][0])) continue;
                        String string7 = "";
                        String string8 = "";
                        if (stringArray[n4][2] != null) {
                            string8 = stringArray[n4][2].trim();
                        }
                        if (stringArray[n4][3] != null) {
                            string7 = stringArray[n4][3].trim();
                        }
                        string6 = string8.indexOf(124) == -1 || string8.indexOf(40) != -1 ? " CDATA" : " (" + string8 + CLOSE_BRACKET;
                        if (string7.length() > 0) {
                            string6 = string6 + " \"" + string7 + QUOTE;
                        }
                        prettyPrintWriter.pprint(4, stringArray[n4][0] + string6);
                    }
                    prettyPrintWriter.pprint(2, GT);
                }
                prettyPrintWriter.println();
            }
            prettyPrintWriter.pprint(0, "]>");
            prettyPrintWriter.flush();
            prettyPrintWriter.close();
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
        }
        catch (Exception exception) {
            this.error = exception.toString();
            n |= 2;
        }
        return n;
    }

    protected Vector getElementNodes(FactDescription factDescription) {
        String[][] stringArray = factDescription.getAttributes();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.factIndex.containsKey(stringArray[i][1])) continue;
            vector.addElement(stringArray[i][0]);
        }
        return vector;
    }

    protected boolean hasBasicAttributes(FactDescription factDescription) {
        String[][] stringArray = factDescription.getAttributes();
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Misc.member(stringArray[i][1], BASIC_TYPES)) continue;
            return true;
        }
        return false;
    }

    public int saveFile(File file) {
        Assert.notNull(file);
        int n = 0;
        this.error = null;
        this.warning = null;
        int n2 = 0;
        String string = file.getParent();
        String string2 = string != null ? string + File.separator + TFILE : TFILE;
        File file2 = new File(string2);
        while (file2.exists()) {
            file2 = new File(string2 + n2++);
        }
        try {
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter(file2);
            prettyPrintWriter.pprint(0, BEGIN_ONTOLOGY);
            prettyPrintWriter.pprint(1, BEGIN_PREAMBLE);
            prettyPrintWriter.pprint(2, ":system ZEUS-Ontology-Editor");
            prettyPrintWriter.pprint(2, ":version \"" + SystemProps.getProperty("version.id") + QUOTE);
            prettyPrintWriter.pprint(1, END_PREAMBLE);
            Enumeration enumeration = this.restrictions.elements();
            if (enumeration.hasMoreElements()) {
                prettyPrintWriter.pprint(1, BEGIN_RESTRICTIONS);
                while (enumeration.hasMoreElements()) {
                    prettyPrintWriter.pprint(2, BEGIN_RESTRICTION_ITEM);
                    String[] stringArray = (String[])enumeration.nextElement();
                    String string3 = stringArray[2] != null ? stringArray[2] : "";
                    prettyPrintWriter.pprint(3, ":name " + stringArray[0]);
                    prettyPrintWriter.pprint(3, ":type " + stringArray[1]);
                    prettyPrintWriter.pprint(3, ":value \"" + string3 + QUOTE);
                    prettyPrintWriter.pprint(2, END_RESTRICTION_ITEM);
                }
                prettyPrintWriter.pprint(1, END_RESTRICTIONS);
            }
            if ((enumeration = this.nodes()).hasMoreElements()) {
                prettyPrintWriter.pprint(1, BEGIN_FACTS);
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = (TreeNode)enumeration.nextElement();
                    FactDescription factDescription = (FactDescription)treeNode.getValue();
                    if (Misc.member(factDescription.getName(), PREDEFINED_FACTS)) continue;
                    prettyPrintWriter.pprint(2, BEGIN_FACT_ITEM);
                    prettyPrintWriter.pprint(3, ":name " + factDescription.getName());
                    TreeNode treeNode2 = treeNode.getParent();
                    FactDescription factDescription2 = (FactDescription)treeNode2.getValue();
                    prettyPrintWriter.pprint(3, ":parent " + factDescription2.getName());
                    String[][] stringArray = factDescription.getAttributes();
                    if (stringArray.length > 0) {
                        prettyPrintWriter.pprint(3, BEGIN_ATTRIBUTE_LIST);
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < stringArray[i].length; ++j) {
                                if (stringArray[i][j] != null) continue;
                                stringArray[i][j] = "";
                            }
                            stringArray[i][2] = QUOTE + stringArray[i][2] + QUOTE;
                            stringArray[i][3] = QUOTE + stringArray[i][3] + QUOTE;
                            prettyPrintWriter.pprint(4, BEGIN_ATTRIBUTE_ITEM);
                            prettyPrintWriter.pprint(5, ":name " + stringArray[i][0]);
                            prettyPrintWriter.pprint(5, ":type " + stringArray[i][1]);
                            prettyPrintWriter.pprint(5, ":restriction " + stringArray[i][2]);
                            prettyPrintWriter.pprint(5, ":default " + stringArray[i][3]);
                            prettyPrintWriter.pprint(4, END_ATTRIBUTE_ITEM);
                        }
                        prettyPrintWriter.pprint(3, END_ATTRIBUTE_LIST);
                    }
                    prettyPrintWriter.pprint(2, END_FACT_ITEM);
                }
                prettyPrintWriter.pprint(1, END_FACTS);
            }
            prettyPrintWriter.pprint(0, END_ONTOLOGY);
            prettyPrintWriter.flush();
            prettyPrintWriter.close();
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
            this.save_needed = false;
        }
        catch (Exception exception) {
            this.error = exception.toString();
            n |= 2;
        }
        this.setFilename(file);
        return n;
    }

    public int openFile(File file) {
        Assert.notNull(file);
        int n = 0;
        this.clear();
        try {
            OntologyParser ontologyParser = new OntologyParser(new FileInputStream(file));
            ontologyParser.parse(this);
        }
        catch (TokenMgrError tokenMgrError) {
            DAMLReader dAMLReader = new DAMLReader(this);
            dAMLReader.read(file);
        }
        catch (Exception exception) {
            this.clear();
            this.error = exception.toString();
            n |= 2;
        }
        if (this.warning != null) {
            n |= 1;
        }
        this.setFilename(file);
        this.fireChanged(0, file.getName());
        this.save_needed = false;
        return n;
    }

    private void setFilename(File file) {
        try {
            this.ontologyName = file.getName();
            this.filename = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.ontologyName = file.getName();
            this.filename = file.getAbsolutePath();
        }
    }

    public boolean isAncestorOf(String string, String string2) {
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            if (!factDescription.getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public Iterator allAncestors(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            arrayList.add(factDescription.getName());
        }
        return arrayList.iterator();
    }

    public TreeNode addChildFact(TreeNode treeNode) {
        String string = this.genSym.plainId(FACT_STR);
        while (this.factIndex.containsKey(string)) {
            string = this.genSym.plainId(FACT_STR);
        }
        TreeNode treeNode2 = treeNode.addChild(new FactDescription(string));
        this.factIndex.put(string, treeNode2);
        this.fireChanged(1, string);
        return treeNode2;
    }

    public boolean addNamedChildFact(TreeNode treeNode, String string) {
        if (this.factIndex.containsKey(string)) {
            return false;
        }
        TreeNode treeNode2 = treeNode.addChild(new FactDescription(string));
        this.factIndex.put(string, treeNode2);
        this.fireChanged(0, string);
        return true;
    }

    public void __addChildFact(String string, String string2) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        TreeNode treeNode2 = treeNode.addChild(new FactDescription(string2));
        this.factIndex.put(string2, treeNode2);
    }

    public Object renameFact(String string, String string2) {
        if (this.factIndex.containsKey(string2)) {
            return null;
        }
        if (Misc.member(string, PREDEFINED_FACTS)) {
            return null;
        }
        TreeNode treeNode = (TreeNode)this.factIndex.remove(string);
        Assert.notNull(treeNode);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        factDescription.setName(string2);
        this.factIndex.put(string2, treeNode);
        this.fireChanged(3, string2);
        return treeNode;
    }

    public boolean isFactEditable(String string) {
        return !Misc.member(string, PREDEFINED_FACTS);
    }

    public void removeFact(TreeNode treeNode) {
        FactDescription factDescription;
        TreeNode treeNode2 = treeNode.getParent();
        treeNode2.removeChild(treeNode);
        Enumeration enumeration = treeNode.values();
        while (enumeration.hasMoreElements()) {
            factDescription = (FactDescription)enumeration.nextElement();
            this.factIndex.remove(factDescription.getName());
        }
        factDescription = (FactDescription)treeNode.getValue();
        this.fireChanged(2, factDescription.getName());
    }

    public TreeNode copyFactTree(TreeNode treeNode) {
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        FactDescription factDescription2 = new FactDescription(factDescription);
        TreeNode treeNode2 = new TreeNode(factDescription2);
        this.copyFactTree1(treeNode2, treeNode);
        return treeNode2;
    }

    protected void copyFactTree1(TreeNode treeNode, TreeNode treeNode2) {
        Vector vector = treeNode2.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            TreeNode treeNode3 = (TreeNode)vector.elementAt(i);
            FactDescription factDescription = (FactDescription)treeNode3.getValue();
            FactDescription factDescription2 = new FactDescription(factDescription);
            TreeNode treeNode4 = new TreeNode(factDescription2);
            treeNode.addChild(treeNode4);
            this.copyFactTree1(treeNode4, treeNode3);
        }
    }

    public TreeNode pasteFactTree(TreeNode treeNode, TreeNode treeNode2) {
        FactDescription factDescription;
        TreeNode treeNode3 = this.copyFactTree(treeNode2);
        Enumeration enumeration = treeNode3.nodes();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode4 = (TreeNode)enumeration.nextElement();
            factDescription = (FactDescription)treeNode4.getValue();
            String string = factDescription.getName();
            while (this.factIndex.containsKey(string)) {
                string = this.genSym.plainId(factDescription.getName() + CSEP);
            }
            factDescription.setName(string);
            this.factIndex.put(string, treeNode4);
        }
        treeNode.addChild(treeNode3);
        factDescription = (FactDescription)treeNode3.getValue();
        this.fireChanged(1, factDescription.getName());
        return treeNode3;
    }

    public boolean hasFact(String string) {
        return this.factIndex.containsKey(string);
    }

    public Fact getFact(boolean bl, String string) {
        if (!this.factIndex.containsKey(string)) {
            Core.USER_ERROR("Fact type: " + string + " does not exist in current ontology");
            return null;
        }
        Fact fact = new Fact(bl, string, this, this.genSym);
        AttributeList attributeList = new AttributeList();
        String[][] stringArray = this.getNetAttributeEntriesFor(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][1];
            if (bl || string2 == null || string2.equals("")) {
                string2 = Fact.newVar(this.genSym);
            }
            ValueFunction valueFunction = ZeusParser.Expression(this, string2);
            attributeList.put(stringArray[i][0], valueFunction);
        }
        fact.setAttributeList(attributeList);
        return fact;
    }

    public String[][] getAttributeEntriesFor(String string) {
        if (string == null || string.equals("")) {
            return new String[0][4];
        }
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[][] stringArray = factDescription.getAttributes();
        this.editableLimit = Misc.member(string, PREDEFINED_FACTS) ? stringArray.length : 0;
        return stringArray;
    }

    public String[][] getAllAttributeEntriesFor(String string) {
        String[][] stringArray;
        if (string == null || string.equals("")) {
            return new String[0][4];
        }
        Vector<String[][]> vector = new Vector<String[][]>();
        int n = 0;
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            stringArray = factDescription.getAttributes();
            n += stringArray.length;
            vector.addElement(stringArray);
        }
        String[][] stringArray2 = new String[n][4];
        int n2 = 0;
        for (int i = vector.size() - 1; i >= 0; --i) {
            stringArray = (String[][])vector.elementAt(i);
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray2[n2++] = stringArray[j];
            }
        }
        this.editableLimit = Misc.member(string, PREDEFINED_FACTS) ? stringArray2.length : stringArray2.length - ((String[][])vector.elementAt(0)).length;
        return stringArray2;
    }

    public int getEditableLimit() {
        return this.editableLimit;
    }

    String[][] getNetAttributeEntriesFor(String string) {
        if (string == null || string.equals("")) {
            return new String[0][2];
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            String[][] stringArray = factDescription.getAttributes();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                if (stringArray[i][3] == null) {
                    stringArray[i][3] = "";
                }
                if ((string2 = (String)hashtable.get(stringArray[i][0])) == null || string2.equals("")) {
                    string2 = stringArray[i][3];
                }
                hashtable.put(stringArray[i][0], string2);
            }
        }
        String[][] stringArray = new String[hashtable.size()][2];
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n][0] = (String)enumeration.nextElement();
            stringArray[n][1] = (String)hashtable.get(stringArray[n][0]);
            ++n;
        }
        return stringArray;
    }

    String[] getNetAttributesOnlyFor(String string) {
        if (string == null || string.equals("")) {
            return new String[0];
        }
        HSet hSet = new HSet();
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            String[][] stringArray = factDescription.getAttributes();
            for (int i = 0; i < stringArray.length; ++i) {
                hSet.add(stringArray[i][0]);
            }
        }
        String[] stringArray = new String[hSet.size()];
        Enumeration enumeration = hSet.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String setAttribute(String string, String string2, int n, String string3) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[] stringArray = factDescription.removeAttributeEntry(string2);
        switch (n) {
            case 0: {
                String string4 = string3;
                while (factDescription.containsAttribute(string4)) {
                    string4 = this.genSym.plainId(string3 + CSEP);
                }
                stringArray[0] = string4;
                factDescription.setAttributeEntry(stringArray);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                stringArray[n] = string3;
                factDescription.setAttributeEntry(stringArray);
                break;
            }
            default: {
                Core.FAIL("Unknown type in OntologyDb.setAttribute()");
            }
        }
        this.fireChanged(4, string);
        return string3;
    }

    public void addNewAttributeRow(String string) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String string2 = this.genSym.plainId(NAME_STR);
        while (factDescription.containsAttribute(string2)) {
            string2 = this.genSym.plainId(NAME_STR);
        }
        String[] stringArray = new String[]{string2, STRING, "", ""};
        factDescription.setAttributeEntry(stringArray);
        this.fireChanged(4, string);
    }

    public void addNewAttribute(String string, String string2, String string3) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[] stringArray = new String[]{string2, string3, "", ""};
        factDescription.setAttributeEntry(stringArray);
    }

    public void __addNewAttributeRow(String string, String string2, String string3, String string4, String string5) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[] stringArray = new String[]{string2, string3, string4, string5};
        factDescription.setAttributeEntry(stringArray);
    }

    public void deleteAttributes(String string, String[] stringArray) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            factDescription.removeAttributeEntry(stringArray[i]);
        }
        this.fireChanged(4, string);
    }

    public void addAttributeRows(String string, String[][] stringArray) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            while (factDescription.containsAttribute(string2)) {
                string2 = this.genSym.plainId(stringArray[i][0] + CSEP);
            }
            stringArray[i][0] = string2;
            factDescription.setAttributeEntry(stringArray[i]);
        }
        this.fireChanged(4, string);
    }

    public TreeNode createAttributeTree(String string, String string2) {
        Core.ERROR(this.factIndex.containsKey(string), 1, (Object)this);
        TreeNode treeNode = new TreeNode(string2);
        this.createAttributeTreeNodes(string, treeNode);
        return treeNode;
    }

    protected void createAttributeTreeNodes(String string, TreeNode treeNode) {
        String[][] stringArray;
        Vector<String[][]> vector = new Vector<String[][]>();
        for (TreeNode treeNode2 = (TreeNode)this.factIndex.get(string); treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode2.getValue();
            stringArray = factDescription.getAttributes();
            vector.addElement(stringArray);
        }
        OrderedHashtable orderedHashtable = new OrderedHashtable();
        for (int i = 0; i < vector.size(); ++i) {
            stringArray = (String[][])vector.elementAt(i);
            for (int j = 0; j < stringArray.length; ++j) {
                orderedHashtable.put(stringArray[j][0], stringArray[j][1]);
            }
        }
        Enumeration enumeration = orderedHashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            TreeNode treeNode3 = treeNode.addChild(string2);
            String string3 = (String)orderedHashtable.get(string2);
            if (this.factIndex.containsKey(string3)) {
                this.createAttributeTreeNodes(string3, treeNode3);
            }
            ++n;
        }
    }

    public String[][] getAllRestrictions() {
        String[][] stringArray = new String[this.restrictions.size()][3];
        Enumeration enumeration = this.restrictions.elements();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String[])enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getAllRestrictionNames() {
        String[] stringArray = new String[this.restrictions.size()];
        Enumeration enumeration = this.restrictions.elements();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = (String[])enumeration.nextElement();
            stringArray[i] = stringArray2[0];
        }
        return stringArray;
    }

    public String setRestrictionData(String string, int n, Object object) {
        String[] stringArray = null;
        String string2 = (String)object;
        switch (n) {
            case 0: {
                while (this.restrictions.containsKey(string2)) {
                    string2 = this.genSym.plainId((String)object + CSEP);
                }
                stringArray = (String[])this.restrictions.get(string);
                String string3 = stringArray[0];
                stringArray[n] = string2;
                this.restrictions.reKey(string3, stringArray[0], stringArray);
                break;
            }
            case 1: 
            case 2: {
                stringArray = (String[])this.restrictions.get(string);
                stringArray[n] = string2;
            }
        }
        this.fireChanged(7, stringArray[0]);
        return stringArray[n];
    }

    public void addNewRestriction() {
        String string = this.genSym.plainId(NAME_STR);
        while (this.restrictions.containsKey(string)) {
            string = this.genSym.plainId(NAME_STR);
        }
        String[] stringArray = new String[]{string, STRING, ""};
        this.restrictions.put(stringArray[0], stringArray);
        this.fireChanged(5, string);
    }

    public void deleteRestrictions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.restrictions.remove(stringArray[i]);
            this.fireChanged(6, stringArray);
        }
    }

    public void addRestrictions(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            while (this.restrictions.containsKey(string)) {
                string = this.genSym.plainId(stringArray[i][0] + CSEP);
            }
            stringArray[i][0] = string;
            this.restrictions.put(stringArray[i][0], stringArray[i]);
            this.fireChanged(5, stringArray[i][0]);
        }
    }

    public void __addRestriction(String string, String string2, String string3) {
        String[] stringArray = new String[]{string, string2, string3};
        this.restrictions.put(stringArray[0], stringArray);
    }

    public boolean[] validateFact(Fact fact) {
        String[] stringArray = fact.listAttributes();
        ValueFunction[] valueFunctionArray = fact.listValues();
        boolean[] blArray = new boolean[valueFunctionArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.validate(fact.getType(), stringArray[i], valueFunctionArray[i]);
        }
        return blArray;
    }

    boolean validate(String string, String string2, ValueFunction valueFunction) {
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        if (treeNode == null) {
            return false;
        }
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        while (!factDescription.containsAttribute(string2) && treeNode != null && (treeNode = treeNode.getParent()) != null) {
            factDescription = (FactDescription)treeNode.getValue();
        }
        if (treeNode == null) {
            return false;
        }
        String[] stringArray = factDescription.getAttributeEntry(string2);
        String string3 = stringArray[1];
        String string4 = this.getBasicType(string3);
        ValueFunction valueFunction2 = null;
        String string5 = stringArray[2];
        if (Misc.member(string4, BASIC_TYPES)) {
            valueFunction2 = this.checkRestrictionEntry(string4, string5);
            if (valueFunction2 != null && !Misc.member(string3, BASIC_TYPES)) {
                valueFunction2 = this.checkRestriction(valueFunction2, string3);
            }
            if (valueFunction2 == null) {
                return false;
            }
        } else {
            if (!string5.equals("")) {
                return false;
            }
            valueFunction2 = new VarFn(Fact.newVar(this.genSym));
        }
        return (valueFunction = valueFunction.unifiesWith(valueFunction2, new Bindings())) != null;
    }

    public boolean[][] getAllRestrictionValidityInfo() {
        boolean[][] blArray = new boolean[this.restrictions.size()][3];
        Enumeration enumeration = this.restrictions.keys();
        for (int i = 0; i < blArray.length; ++i) {
            String string = (String)enumeration.nextElement();
            blArray[i] = this.isRestrictionValid(string);
        }
        return blArray;
    }

    public boolean[] isRestrictionValid(String string) {
        boolean[] blArray = new boolean[3];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        if (!this.restrictions.containsKey(string)) {
            return blArray;
        }
        blArray[2] = this.checkRestriction(null, string) != null;
        return blArray;
    }

    protected ValueFunction checkRestriction(ValueFunction valueFunction, String string) {
        String[] stringArray = (String[])this.restrictions.get(string);
        String string2 = this.getRestrictionBasicType(string);
        ValueFunction valueFunction2 = this.checkRestrictionEntry(string2, stringArray[2]);
        if (valueFunction2 != null && valueFunction != null) {
            valueFunction2 = valueFunction2.unifiesWith(valueFunction, new Bindings());
        }
        if (string2.equals(stringArray[1]) || valueFunction2 == null) {
            return valueFunction2;
        }
        return this.checkRestriction(valueFunction2, stringArray[1]);
    }

    protected ValueFunction checkDefaultValue(String string, String string2) {
        if ((string2 = string2.trim()).equals("")) {
            return new VarFn(Fact.newVar(this.genSym));
        }
        try {
            RestrictionParser restrictionParser = new RestrictionParser(new ByteArrayInputStream(string2.getBytes()));
            switch (Misc.whichPosition(string, BASIC_TYPES)) {
                case 0: {
                    return restrictionParser.StringLiteral();
                }
                case 1: {
                    return restrictionParser.IntegerExpression();
                }
                case 2: {
                    return restrictionParser.RealExpression();
                }
                case 3: {
                    return restrictionParser.BooleanLiteral();
                }
                case 4: {
                    return restrictionParser.DateLiteral();
                }
                case 5: {
                    return restrictionParser.TimeLiteral();
                }
                case 6: {
                    return restrictionParser.VectorLiteral();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected ValueFunction checkRestrictionEntry(String string, String string2) {
        if ((string2 = string2.trim()).equals("")) {
            return new VarFn(Fact.newVar(this.genSym));
        }
        try {
            RestrictionParser restrictionParser = new RestrictionParser(new ByteArrayInputStream(string2.getBytes()));
            switch (Misc.whichPosition(string, BASIC_TYPES)) {
                case 0: {
                    return restrictionParser.StringExpression();
                }
                case 1: {
                    return restrictionParser.IntegerExpression();
                }
                case 2: {
                    return restrictionParser.RealExpression();
                }
                case 3: {
                    return restrictionParser.BooleanLiteral();
                }
                case 4: {
                    return restrictionParser.DateExpression();
                }
                case 5: {
                    return restrictionParser.TimeExpression();
                }
                case 6: {
                    return restrictionParser.VectorLiteral();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getRestrictionBasicType(String string) {
        String[] stringArray = (String[])this.restrictions.get(string);
        String string2 = stringArray[1];
        if (Misc.member(string2, BASIC_TYPES)) {
            return string2;
        }
        return this.getRestrictionBasicType(string2);
    }

    protected String getBasicType(String string) {
        if (Misc.member(string, BASIC_TYPES)) {
            return string;
        }
        if (string.equals(OBJECT_TYPE)) {
            return string;
        }
        if (this.restrictions.containsKey(string)) {
            return this.getRestrictionBasicType(string);
        }
        return string;
    }

    public boolean[] isAttributeValid(String string, String string2) {
        boolean[] blArray = new boolean[4];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        if (string == null || string.equals("")) {
            return blArray;
        }
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[] stringArray = factDescription.getAttributeEntry(string2);
        String string3 = stringArray[1];
        String string4 = this.getInheritedTypeFor(string, string2);
        String string5 = this.getBasicType(string3);
        String string6 = this.getBasicType(string4);
        ValueFunction valueFunction = null;
        ValueFunction valueFunction2 = null;
        if (!(string5.equals(string6) || this.hasFact(string5) || this.isAncestorOf(string3, string6))) {
            blArray[1] = false;
        }
        String string7 = stringArray[2];
        if (Misc.member(string5, BASIC_TYPES)) {
            valueFunction = this.checkRestrictionEntry(string5, string7);
            if (valueFunction != null && !Misc.member(string3, BASIC_TYPES)) {
                valueFunction = this.checkRestriction(valueFunction, string3);
            }
            blArray[2] = valueFunction != null;
        } else {
            blArray[2] = string7.equals("");
        }
        String string8 = stringArray[3];
        if (Misc.member(string5, BASIC_TYPES)) {
            valueFunction2 = this.checkDefaultValue(string5, string8);
            if (valueFunction2 != null && valueFunction != null) {
                valueFunction2 = valueFunction2.unifiesWith(valueFunction, new Bindings());
            }
            blArray[3] = valueFunction2 != null;
        } else {
            blArray[3] = string8.equals("");
        }
        return blArray;
    }

    protected String getInheritedTypeFor(String string, String string2) {
        String string3 = null;
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            if (!factDescription.containsAttribute(string2)) {
                return string3;
            }
            String[] stringArray = factDescription.getAttributeEntry(string2);
            string3 = stringArray[1];
        }
        return string3;
    }

    public boolean[][] getValidityInfoFor(String string) {
        if (string == null || string.equals("")) {
            return new boolean[0][4];
        }
        TreeNode treeNode = (TreeNode)this.factIndex.get(string);
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[][] stringArray = factDescription.getAttributes();
        boolean[][] blArrayArray = new boolean[stringArray.length][];
        for (int i = 0; i < blArrayArray.length; ++i) {
            blArrayArray[i] = this.isAttributeValid(string, stringArray[i][0]);
        }
        return blArrayArray;
    }

    public boolean[][] getAllValidityInfoFor(String string) {
        boolean[][] blArray;
        if (string == null || string.equals("")) {
            return new boolean[0][4];
        }
        Vector<boolean[][]> vector = new Vector<boolean[][]>();
        int n = 0;
        for (TreeNode treeNode = (TreeNode)this.factIndex.get(string); treeNode != null; treeNode = treeNode.getParent()) {
            FactDescription factDescription = (FactDescription)treeNode.getValue();
            String string2 = factDescription.getName();
            blArray = this.getValidityInfoFor(string2);
            n += blArray.length;
            vector.addElement(blArray);
        }
        boolean[][] blArray2 = new boolean[n][4];
        int n2 = 0;
        for (int i = vector.size() - 1; i >= 0; --i) {
            blArray = (boolean[][])vector.elementAt(i);
            for (int j = 0; j < blArray.length; ++j) {
                blArray2[n2++] = blArray[j];
            }
        }
        return blArray2;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = OntologyDb.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = OntologyDb.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged(int n, Object object) {
        this.save_needed = true;
        OntologyDbChangeEvent ontologyDbChangeEvent = new OntologyDbChangeEvent(this, n, object);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? OntologyDb.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(ontologyDbChangeEvent);
        }
    }

    public static void main(String[] stringArray) {
        Object var1_1 = null;
        OntologyDb ontologyDb = new OntologyDb(new GenSym("sym"));
        String string = System.getProperty("user.dir") + System.getProperty("file.separator");
        ontologyDb.openFile(new File(string + stringArray[0]));
    }

    public Hashtable getFactIndex() {
        return this.factIndex;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

