/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Bindings;
import zeus.concepts.ConsumerRecord;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.ProducerRecord;
import zeus.concepts.ResolutionContext;
import zeus.concepts.SuppliedDb;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Time;

public class Goal {
    public static final boolean DISCRETE = true;
    public static final boolean CONTINUOUS = false;
    public static final int DEFAULT_PRIORITY = 1;
    public static final int MIN_PRIORITY = 1;
    public static final int MAX_PRIORITY = 10;
    protected Fact fact = null;
    protected int start_time = -1;
    protected int end_time = -1;
    protected double cost = 0.0;
    protected int invocations = 0;
    protected boolean type = true;
    protected int priority = 1;
    protected String id = null;
    protected String image = null;
    protected String desired_by;
    protected String root_id = null;
    protected String[] media = null;
    protected Time replyTime = null;
    protected Time confirmTime = null;
    protected String user_data_type = null;
    protected Object user_data = null;
    protected ResolutionContext context = null;
    protected SuppliedDb given = null;
    protected Vector producer_records = null;
    protected Vector consumer_records = null;

    public Goal(boolean bl, String string, Fact fact, String string2) {
        this.type = bl;
        this.id = string;
        this.fact = new Fact(fact);
        this.desired_by = string2;
    }

    public Goal(String string, Fact fact, int n, double d, String string2, double d3) {
        this.type = true;
        this.id = string;
        this.fact = new Fact(fact);
        this.end_time = n;
        this.cost = d;
        this.desired_by = string2;
        this.confirmTime = new Time(d3);
    }

    public Goal(String string, Fact fact, int n, double d, int n2, String string2, Time time, Time time2) {
        this.type = true;
        this.id = string;
        this.fact = new Fact(fact);
        this.end_time = n;
        this.cost = d;
        this.priority = n2;
        this.desired_by = string2;
        this.replyTime = time;
        this.confirmTime = time2;
    }

    public Goal(String string, Fact fact, int n, int n2, double d, int n3, int n4, String string2, Time time, Time time2) {
        this.type = false;
        this.id = string;
        this.fact = new Fact(fact);
        this.end_time = n2;
        this.start_time = n;
        this.cost = d;
        this.priority = n3;
        this.invocations = n4;
        this.desired_by = string2;
        this.replyTime = time;
        this.confirmTime = time2;
    }

    public Goal(Goal goal) {
        this.type = goal.getType().equals("discrete");
        this.id = goal.getId();
        this.fact = goal.getFact();
        this.end_time = goal.getEndTime();
        if (!this.type) {
            this.start_time = goal.getStartTime();
            this.invocations = goal.getInvocations();
        }
        this.cost = goal.getCost();
        this.priority = goal.getPriority();
        this.desired_by = goal.getDesiredBy();
        this.root_id = goal.getRootId();
        this.media = goal.getTargetMedia();
        this.replyTime = goal.getReplyTime();
        this.confirmTime = goal.getConfirmTime();
        this.image = goal.getImage();
        this.user_data_type = goal.getUserDataType();
        this.user_data = goal.getUserData();
        this.context = goal.getResolutionContext();
        this.given = goal.getSuppliedDb();
        this.producer_records = goal.getProducerRecords();
        this.consumer_records = goal.getConsumerRecords();
    }

    public Goal duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public Goal duplicate(DuplicationTable duplicationTable) {
        Goal goal = this.type ? new Goal(this.id, this.fact.duplicate(duplicationTable), this.end_time, this.cost, this.priority, this.desired_by, this.replyTime, this.confirmTime) : new Goal(this.id, this.fact.duplicate(duplicationTable), this.start_time, this.end_time, this.cost, this.priority, this.invocations, this.desired_by, this.replyTime, this.confirmTime);
        goal.setRootId(this.getRootId());
        goal.setImage(this.getImage());
        goal.setTargetMedia(this.getTargetMedia());
        goal.setUserDataType(this.getUserDataType());
        goal.setUserData(this.getUserData());
        goal.setProducerRecords(this.getProducerRecords());
        goal.setConsumerRecords(this.getConsumerRecords());
        if (this.context != null) {
            goal.setResolutionContext(this.context.duplicate(duplicationTable));
        }
        if (this.given != null) {
            goal.setSuppliedDb(this.given.duplicate(duplicationTable));
        }
        return goal;
    }

    public String getType() {
        if (this.type) {
            return "discrete";
        }
        return "continuous";
    }

    public boolean whichType() {
        return this.type;
    }

    public void setId(String string) {
        Assert.notNull(string);
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public String getImage() {
        return this.image;
    }

    public Fact getFact() {
        return new Fact(this.fact);
    }

    public String getFactType() {
        return this.fact.getType();
    }

    public String getFactId() {
        return this.fact.getId();
    }

    public int getEndTime() {
        return this.end_time;
    }

    public double getCost() {
        return this.cost;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getDesiredBy() {
        return this.desired_by;
    }

    public String getUserDataType() {
        return this.user_data_type;
    }

    public Object getUserData() {
        return this.user_data;
    }

    public boolean isDiscrete() {
        return this.type;
    }

    public boolean isContinuous() {
        return !this.type;
    }

    public void setProducerRecords(Vector vector) {
        this.producer_records = vector;
    }

    public void setConsumerRecords(Vector vector) {
        this.consumer_records = vector;
    }

    public void addProducer(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ProducerRecord producerRecord = new ProducerRecord(string, string2, string3, string4, string5, string6, string7);
        this.addProducer(producerRecord);
    }

    public void addProducer(ProducerRecord producerRecord) {
        if (this.producer_records == null) {
            this.producer_records = new Vector();
        }
        this.producer_records.addElement(producerRecord);
    }

    public void addConsumer(String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, boolean bl) {
        ConsumerRecord consumerRecord = new ConsumerRecord(string, string2, string3, string4, string5, string6, n, n2, bl);
        this.addConsumer(consumerRecord);
    }

    public void addConsumer(ConsumerRecord consumerRecord) {
        if (this.consumer_records == null) {
            this.consumer_records = new Vector();
        }
        this.consumer_records.addElement(consumerRecord);
    }

    public void setSuppliedDb(SuppliedDb suppliedDb) {
        this.given = suppliedDb;
    }

    public void setResolutionContext(ResolutionContext resolutionContext) {
        this.context = resolutionContext;
    }

    public void setUserDataType(String string) {
        this.user_data_type = string;
    }

    public void setUserData(Object object) {
        this.user_data = object;
    }

    public void setImage(String string) {
        this.image = string;
    }

    public void setFact(Fact fact) {
        Assert.notNull(fact);
        this.fact = fact;
    }

    public void setFactType(String string) {
        this.fact.setType(string);
    }

    public void setStartTime(int n) {
        this.start_time = n;
    }

    public void setInvocations(int n) {
        Assert.notFalse(!this.type);
        Assert.notFalse(n >= 0);
        this.invocations = n;
    }

    public void setEndTime(int n) {
        this.end_time = n;
    }

    public void setCost(double d) {
        Assert.notFalse(d >= 0.0);
        this.cost = d;
    }

    public void setPriority(int n) {
        Assert.notFalse(n >= 1 && n <= 10);
        this.priority = n;
    }

    public void setDesiredBy(String string) {
        Assert.notNull(string);
        this.desired_by = string;
    }

    public Vector getProducerRecords() {
        return this.producer_records;
    }

    public Vector getConsumerRecords() {
        return this.consumer_records;
    }

    public SuppliedDb getSuppliedDb() {
        return this.given;
    }

    public ResolutionContext getResolutionContext() {
        return this.context;
    }

    public int getStartTime() {
        return this.start_time;
    }

    public int getInvocations() {
        Assert.notFalse(!this.type);
        return this.invocations;
    }

    public String getRootId() {
        if (this.root_id == null) {
            return this.id;
        }
        return this.root_id;
    }

    public void setRootId(String string) {
        Assert.notNull(string);
        this.root_id = string;
    }

    public void setTargetMedia(String[] stringArray) {
        this.media = stringArray;
    }

    public void setReplyTime(Time time) {
        this.replyTime = new Time(time);
    }

    public void setConfirmTime(Time time) {
        this.confirmTime = new Time(time);
    }

    public void setReplyTime(double d) {
        this.replyTime = new Time(d);
    }

    public void setConfirmTime(double d) {
        this.confirmTime = new Time(d);
    }

    public Time getReplyTime() {
        return this.replyTime;
    }

    public Time getConfirmTime() {
        return this.confirmTime;
    }

    public String[] getTargetMedia() {
        return this.media;
    }

    public AbilitySpec getAbility() {
        return new AbilitySpec("goal_generated", this.fact, 0, 0.0);
    }

    public boolean constrain(Bindings bindings) {
        return this.fact.resolve(bindings);
    }

    public boolean equals(Goal goal) {
        return this.id.equals(goal.getId()) && this.fact.getId().equals(goal.getFact().getId()) && this.getType().equals(goal.getType());
    }

    public String toSL() {
        String string = new String();
        string = "I";
        String string2 = new String("( " + string + " " + this.desired_by + " (" + this.id + " " + this.fact.toSL());
        string2 = string2 + "(parameters :start_time " + this.start_time + " :end_time " + this.end_time;
        string2 = string2 + " :cost " + this.cost + " :priority " + this.priority;
        string2 = string2 + ")))";
        return string2.trim();
    }

    public String toString() {
        int n;
        System.out.println("Goal ==\n" + this.toSL());
        String string = new String("(");
        string = string + ":id " + this.id + " ";
        string = string + ":desired_by " + this.desired_by + " ";
        string = string + ":type " + this.type + " ";
        string = string + ":fact " + this.fact.toString() + " ";
        if (this.image != null) {
            string = string + ":image " + this.image + " ";
        }
        if (!this.type) {
            string = string + ":start_time " + this.start_time + " ";
        }
        string = string + ":end_time " + this.end_time + " ";
        string = string + ":cost " + this.cost + " ";
        string = string + ":priority " + this.priority + " ";
        if (!this.type) {
            string = string + ":invocations " + this.invocations + " ";
        }
        if (this.root_id != null) {
            string = string + ":root_id " + this.root_id + " ";
        }
        if (this.media != null) {
            string = string + ":media (";
            for (n = 0; n < this.media.length; ++n) {
                string = string + "\"" + this.media[n] + "\"" + " ";
            }
            string = string.trim() + ")";
        }
        if (this.replyTime != null) {
            string = string + ":reply_time " + this.replyTime + " ";
        }
        if (this.confirmTime != null) {
            string = string + ":confirm_time " + this.confirmTime + " ";
        }
        if (this.user_data_type != null) {
            string = string + ":user_data_type \"" + this.user_data_type + "\" ";
            if (this.user_data != null) {
                string = string + ":user_data #" + this.user_data + "#" + " ";
            }
        }
        if (this.context != null) {
            string = string + ":context (" + this.context + ") ";
        }
        if (this.given != null) {
            string = string + ":given (" + this.given + ") ";
        }
        if (this.producer_records != null && !this.producer_records.isEmpty()) {
            string = string + ":producer_records (";
            for (n = 0; n < this.producer_records.size(); ++n) {
                string = string + this.producer_records.elementAt(n);
            }
            string = string + ") ";
        }
        if (this.consumer_records != null && !this.consumer_records.isEmpty()) {
            string = string + ":consumer_records (";
            for (n = 0; n < this.consumer_records.size(); ++n) {
                string = string + this.consumer_records.elementAt(n);
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }
}

