/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import zeus.concepts.Fact;
import zeus.concepts.Summary;
import zeus.util.Assert;
import zeus.util.Misc;

public class FactSummary
extends Summary {
    public static final String ALLOCATED = "Reserved";
    public static final String UNALLOCATED = "Free";
    protected Fact fact;

    public FactSummary(Fact fact, String string) {
        this.setFact(fact);
        this.setStatus(string);
    }

    public FactSummary(FactSummary factSummary) {
        this.setFact(factSummary.getFact());
        this.setStatus(factSummary.getStatus());
    }

    public String getType() {
        return this.fact.getType();
    }

    public String getId() {
        return this.fact.getId();
    }

    public Fact getFact() {
        return this.fact;
    }

    public String[] summarize() {
        String[] stringArray = new String[]{this.fact.getId(), this.status};
        return stringArray;
    }

    public void setStatus(String string) {
        Assert.notNull(string);
        Assert.notFalse(string.equals(ALLOCATED) || string.equals(UNALLOCATED) || string.equals("UNKNOWN"));
        this.status = string;
    }

    public void setFact(Fact fact) {
        Assert.notNull(fact);
        this.fact = fact;
    }

    public boolean equals(FactSummary factSummary) {
        return this.fact.equals(factSummary.getFact()) && this.status.equals(factSummary.getStatus());
    }

    public String toString() {
        return "(:fact " + this.fact.toString() + " " + ":status " + this.status + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:fact ";
        String string4 = string3 + this.fact.pprint(n + string3.length()) + string2 + ":status " + this.status + string2;
        return string4.trim() + "\n" + string + ")";
    }
}

