/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import zeus.util.Assert;
import zeus.util.OrderedHashtable;

public class FactDescription {
    protected String name = null;
    protected OrderedHashtable attributes = null;

    public FactDescription(String string) {
        this.name = string;
        this.attributes = new OrderedHashtable();
    }

    public FactDescription(FactDescription factDescription) {
        this.name = factDescription.getName();
        this.attributes = new OrderedHashtable();
        String[][] stringArray = factDescription.getAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.setAttributeEntry(stringArray[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public int numAttributes() {
        return this.attributes.size();
    }

    public void setName(String string) {
        Assert.notNull(string);
        this.name = string;
    }

    public String[][] getAttributes() {
        String[][] stringArray = new String[this.attributes.size()][4];
        Enumeration enumeration = this.attributes.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String[] stringArray2 = (String[])enumeration.nextElement();
            stringArray[n][0] = stringArray2[0];
            stringArray[n][1] = stringArray2[1];
            stringArray[n][2] = stringArray2[2];
            stringArray[n][3] = stringArray2[3];
            ++n;
        }
        return stringArray;
    }

    public void add(String string, String string2, String string3, String string4) {
        Assert.notFalse(!this.attributes.containsKey(string));
        String[] stringArray = new String[]{string, string2, string2, string2};
        this.attributes.put(string, stringArray);
    }

    public String[] getAttributeEntry(String string) {
        String[] stringArray = new String[4];
        String[] stringArray2 = (String[])this.attributes.get(string);
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[i] = stringArray2[i];
        }
        return stringArray;
    }

    public String[] removeAttributeEntry(String string) {
        return (String[])this.attributes.remove(string);
    }

    public void setAttributeEntry(String[] stringArray) {
        this.attributes.put(stringArray[0], stringArray);
    }

    public boolean containsAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public String toString() {
        return this.name;
    }
}

