/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Vector;
import zeus.concepts.AttributeList;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.OntologyDb;
import zeus.concepts.ResolutionContext;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.PrimitiveNumericFn;
import zeus.concepts.fn.RealFn;
import zeus.concepts.fn.TypeFn;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;
import zeus.util.TreeNode;

public class Fact {
    public static final String NONVAR = "fact";
    public static final String VAR = "var";
    public static final String V_STR = "?";
    public static final char V_CHR = '?';
    public static final String F_STR = "@";
    public static final char F_CHR = '@';
    public static final String A_STR = ".";
    public static final char A_CHR = '.';
    public static final boolean FACT = false;
    public static final boolean VARIABLE = true;
    public static final String SELF_NAME = "self";
    public static final String THIS_NAME = "this";
    public static final String THIS = "?this";
    public static final String SELF = "?self";
    protected static final int IS_VARIABLE = 1;
    protected static final int IS_NEGATION = 2;
    protected static final int IS_READ_ONLY = 4;
    protected static final int IS_REPLACED = 8;
    protected static final int IS_LOCAL = 16;
    protected static final int IS_SIDE_EFFECT = 32;
    transient ValueFunction functor = null;
    transient String descp = null;
    protected String id;
    protected String type;
    protected int modifiers;
    protected AttributeList attr;
    protected OntologyDb ontology;

    public static final String newVar(GenSym genSym) {
        return genSym.plainId("?var");
    }

    protected static String name(boolean bl, GenSym genSym) {
        String string = bl ? VAR : NONVAR;
        return genSym.plainId(string);
    }

    public Fact() {
    }

    Fact(boolean bl, String string, OntologyDb ontologyDb, GenSym genSym) {
        this.id = Fact.name(bl, genSym);
        this.type = string;
        this.modifiers = bl ? 1 : 0;
        this.ontology = ontologyDb;
        this.setFunctor();
    }

    public Fact(Fact fact) {
        this.id = fact.ID();
        this.type = fact.getType();
        this.modifiers = fact.getModifiers();
        this.attr = new AttributeList(fact.getAttributeList());
        this.ontology = fact.getOntologyDb();
        this.setFunctor();
    }

    public Fact(boolean bl, Fact fact) {
        this(fact);
        this.setIsVariable(bl);
    }

    protected Fact(String string, String string2, int n, AttributeList attributeList, OntologyDb ontologyDb) {
        this.id = string2;
        this.type = string;
        this.modifiers = n;
        this.attr = attributeList;
        this.ontology = ontologyDb;
        this.setFunctor();
    }

    public OntologyDb getOntologyDb() {
        return this.ontology;
    }

    public TreeNode createAttributeTree(boolean bl) {
        String string = bl ? SELF : this.getId();
        return this.ontology.createAttributeTree(this.type, string);
    }

    public static boolean isVariable(int n) {
        return (n & 1) != 0;
    }

    public static boolean isNegative(int n) {
        return (n & 2) != 0;
    }

    public static boolean isReadOnly(int n) {
        return (n & 4) != 0;
    }

    public static boolean isLocal(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isReplaced(int n) {
        return (n & 8) != 0;
    }

    public static boolean isSideEffect(int n) {
        return (n & 0x20) != 0;
    }

    public boolean isVariable() {
        return Fact.isVariable(this.modifiers);
    }

    public boolean isNegative() {
        return Fact.isNegative(this.modifiers);
    }

    public boolean isReadOnly() {
        return Fact.isReadOnly(this.modifiers);
    }

    public boolean isLocal() {
        return Fact.isLocal(this.modifiers);
    }

    public boolean isReplaced() {
        return Fact.isReplaced(this.modifiers);
    }

    public boolean isSideEffect() {
        return Fact.isSideEffect(this.modifiers);
    }

    public String ID() {
        return this.id;
    }

    public String getId() {
        return this.descp;
    }

    public String getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setId(String string) {
        Assert.notNull(string);
        this.id = string;
        this.setFunctor();
    }

    public void setType(String string) {
        Assert.notNull(string);
        this.type = string;
        this.setFunctor();
    }

    public void setModifiers(int n) {
        this.modifiers = n;
        this.setFunctor();
    }

    public static int setIsVariable(int n, boolean bl) {
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        return n;
    }

    public static int setIsNegative(int n, boolean bl) {
        if (bl) {
            n &= 0xFFFFFFE3;
            n |= 2;
        } else {
            n &= 0xFFFFFFFD;
        }
        return n;
    }

    public static int setIsReadOnly(int n, boolean bl) {
        if (bl) {
            n &= 0xFFFFFFF5;
            n |= 4;
        } else {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public static int setIsLocal(int n, boolean bl) {
        if (bl) {
            n &= 0xFFFFFFFD;
            n |= 0x10;
        } else {
            n &= 0xFFFFFFEF;
        }
        return n;
    }

    public static int setIsReplaced(int n, boolean bl) {
        if (bl) {
            n &= 0xFFFFFFF9;
            n |= 8;
        } else {
            n &= 0xFFFFFFF7;
        }
        return n;
    }

    public static int setIsSideEffect(int n, boolean bl) {
        n = bl ? (n |= 0x20) : (n &= 0xFFFFFFDF);
        return n;
    }

    public void setIsVariable(boolean bl) {
        this.modifiers = Fact.setIsVariable(this.modifiers, bl);
        this.setFunctor();
    }

    public void setIsNegative(boolean bl) {
        this.modifiers = Fact.setIsNegative(this.modifiers, bl);
    }

    public void setIsReadOnly(boolean bl) {
        this.modifiers = Fact.setIsReadOnly(this.modifiers, bl);
    }

    public void setIsLocal(boolean bl) {
        this.modifiers = Fact.setIsLocal(this.modifiers, bl);
    }

    public void setIsReplaced(boolean bl) {
        this.modifiers = Fact.setIsReplaced(this.modifiers, bl);
    }

    public void setIsSideEffect(boolean bl) {
        this.modifiers = Fact.setIsSideEffect(this.modifiers, bl);
    }

    public String[] listAttributes() {
        return this.attr.listAttributes();
    }

    public ValueFunction[] listValues() {
        return this.attr.listValues();
    }

    public ValueFunction[] variables() {
        Vector vector = this.attr.variables();
        if (this.isVariable() && !vector.contains(this.functor())) {
            vector.addElement(this.functor());
        }
        ValueFunction[] valueFunctionArray = new ValueFunction[vector.size()];
        for (int i = 0; i < valueFunctionArray.length; ++i) {
            valueFunctionArray[i] = (ValueFunction)vector.elementAt(i);
        }
        return valueFunctionArray;
    }

    public AttributeList getAttributeList() {
        return this.attr;
    }

    public String getValue(String string) {
        String string2 = this.attr.getValue(string);
        if (string2 == null) {
            Core.USER_ERROR("Fact.getValue(): No attribute '" + string + "' found in fact '" + this + "'");
        }
        return string2;
    }

    public ValueFunction getFn(String string) {
        ValueFunction valueFunction = this.attr.getFn(string);
        if (valueFunction == null) {
            Core.USER_ERROR("Fact.getValue(): No attribute '" + string + "' found in fact '" + this + "'");
        }
        return valueFunction;
    }

    public int getInt(String string) {
        try {
            PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)this.attr.getFn(string));
            return primitiveNumericFn.intValue();
        }
        catch (ClassCastException classCastException) {
            Core.USER_ERROR("Fact.getInt('" + string + "') called for non-ground value '" + this + "'");
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            Core.USER_ERROR("Fact.getInt(): No attribute '" + string + "' found in fact '" + this + "'");
            return 0;
        }
    }

    public double getDouble(String string) {
        try {
            PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)this.attr.getFn(string));
            return primitiveNumericFn.doubleValue();
        }
        catch (ClassCastException classCastException) {
            Core.USER_ERROR("Fact.getDouble('" + string + "') called for non-ground value '" + this + "'");
            return 0.0;
        }
        catch (NullPointerException nullPointerException) {
            Core.USER_ERROR("Fact.getDouble(): No attribute '" + string + "' found in fact '" + this + "'");
            return 0.0;
        }
    }

    public long getLong(String string) {
        try {
            PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)this.attr.getFn(string));
            return primitiveNumericFn.longValue();
        }
        catch (ClassCastException classCastException) {
            Core.USER_ERROR("Fact.getLong('" + string + "') called for non-ground value '" + this + "'");
            return 0L;
        }
        catch (NullPointerException nullPointerException) {
            Core.USER_ERROR("Fact.getLong(): No attribute '" + string + "' found in fact '" + this + "'");
            return 0L;
        }
    }

    public int getNumber() {
        if (!this.isa("Entity")) {
            return 1;
        }
        try {
            PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)this.attr.getFn("number"));
            return primitiveNumericFn.intValue();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            Core.USER_ERROR("getNumber() called for non-ground value '" + this + "'");
            return 0;
        }
    }

    public void setNumber(int n) {
        if (this.isa("Entity")) {
            this.setValue("number", n);
        } else if (n != 1) {
            Core.USER_ERROR("setNumber() called for non-Entity object '" + this + "'");
        }
    }

    public void setNumber(VarFn varFn) {
        if (this.isa("Entity")) {
            this.setValue("number", varFn);
        } else {
            Core.USER_ERROR("setNumber() called for non-Entity object '" + this + "'");
        }
    }

    public double getNetCost() {
        if (this.isa("Entity") && !this.isDeterminate("unit_cost")) {
            return 0.0;
        }
        return (double)this.getNumber() * this.getUnitCost();
    }

    public double getUnitCost() {
        if (!this.isa("Entity")) {
            return 0.0;
        }
        try {
            PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)this.attr.getFn("unit_cost"));
            return primitiveNumericFn.doubleValue();
        }
        catch (ClassCastException classCastException) {
            Core.USER_ERROR("getUnitCost() called for non-ground value '" + this + "'");
            return 0.0;
        }
    }

    public void setUnitCost(double d) {
        if (this.isa("Entity")) {
            this.setValue("unit_cost", d);
        } else {
            Core.USER_ERROR("setUnitCost() called for non-Entity object '" + this + "'");
        }
    }

    public void setUnitCost(VarFn varFn) {
        if (this.isa("Entity")) {
            this.setValue("unit_cost", varFn);
        } else {
            Core.USER_ERROR("setUnitCost() called for non-Entity object '" + this + "'");
        }
    }

    public VarFn newVar() {
        return new VarFn(Fact.newVar(this.ontology.GenSym()));
    }

    public void setValue(String string, int n) {
        this.setValue(string, new IntFn(n));
    }

    public void setValue(String string, long l) {
        this.setValue(string, new IntFn(l));
    }

    public void setValue(String string, double d) {
        this.setValue(string, new RealFn(d));
    }

    public void setValue(String string, boolean bl) {
        this.setValue(string, BoolFn.newBoolFn(bl));
    }

    public void setValue(String string, String string2) {
        ValueFunction valueFunction = ZeusParser.Expression(this.ontology, string2);
        if (valueFunction == null) {
            Core.USER_ERROR("Cannot parse value '" + string2 + "' in Fact.setValue()");
        } else {
            this.setValue(string, valueFunction);
        }
    }

    public void setValue(String string, ValueFunction valueFunction) {
        if (!this.ontology.validate(this.type, string, valueFunction)) {
            Core.USER_ERROR("Setting value '" + valueFunction + "' for " + "attribute '" + string + "' in fact '" + this + "'");
        } else {
            this.attr.setValue(string, valueFunction);
        }
    }

    void setAttributeList(AttributeList attributeList) {
        Assert.notNull(attributeList);
        this.attr = attributeList;
    }

    public void setValues(String[] stringArray) {
        if (stringArray.length % 2 != 0) {
            Core.USER_ERROR("Fact.setValues():: improper input length \"{" + Misc.concat(stringArray) + "}\".");
            return;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            this.setValue(stringArray[i], stringArray[i + 1]);
        }
    }

    public boolean equals(Object object) {
        this.debug("normal equality " + this.toString());
        if (!(object instanceof Fact)) {
            return false;
        }
        Fact fact = (Fact)object;
        if (!this.type.equals(fact.getType())) {
            return false;
        }
        if (this.isVariable() || fact.isVariable()) {
            return this.attr.equals(fact.getAttributeList());
        }
        return this.descp.equals(fact.getId());
    }

    protected void setFunctor() {
        this.descp = this.isVariable() ? V_STR + this.id : F_STR + this.id;
        this.functor = this.isVariable() ? new VarFn(this.descp) : new TypeFn(this.descp);
    }

    public boolean isDeterminate() {
        return this.isVariable() ? false : this.attr.isDeterminate();
    }

    public boolean isDeterminate(String string) {
        return this.attr.isDeterminate(string);
    }

    public String[] objectAttributeNames() {
        String[] stringArray = this.attr.listAttributes();
        String string = this.getId();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string + A_STR + stringArray[i];
        }
        return stringArray;
    }

    public String toString() {
        String string = "(:type " + this.type + " " + ":id " + this.id + " " + ":modifiers " + this.modifiers;
        if (!this.attr.isEmpty()) {
            string = string + " :attributes " + this.attr.toString();
        }
        return string + ")";
    }

    public String toSL() {
        String string = "(" + this.type + " ";
        if (!this.attr.isEmpty()) {
            string = string + this.attr.toSL();
        }
        return string + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:type " + this.type + string2 + ":id " + this.id + string2 + ":modifiers " + this.modifiers + string2;
        if (!this.attr.isEmpty()) {
            String string4 = ":attributes ";
            String string5 = Misc.spaces(1 + n + string4.length());
            string3 = string3 + string4 + this.attr.pprint(string5.length());
        }
        return string3.trim() + "\n" + string + ")";
    }

    public String printDAML(String string, String string2) {
        String[] stringArray = this.attr.getNames();
        String string3 = new String();
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + string + "#" + this.type + ":" + stringArray[i] + "=" + this.attr.getValue(stringArray[i]) + "\\\"" + string2 + "\\n\";\n";
        }
        return string3;
    }

    public boolean unifiesWith(Fact fact, Bindings bindings) {
        if (this.type.equals(fact.getType())) {
            ValueFunction valueFunction;
            if (!(this.isVariable() || fact.isVariable() || this.descp.equals(fact.getId()))) {
                return false;
            }
            Bindings bindings2 = new Bindings(bindings);
            ValueFunction valueFunction2 = this.functor();
            if (valueFunction2.unifiesWith(valueFunction = fact.functor(), bindings2) == null || !this.attr.unifiesWith(fact.getAttributeList(), bindings2)) {
                return false;
            }
            bindings.set(bindings2);
            return true;
        }
        return false;
    }

    public boolean unifiesWithChild(Fact fact, Bindings bindings) {
        if (this.type.equals(fact.getType())) {
            return this.unifiesWith(fact, bindings);
        }
        if (this.ontology.isAncestorOf(fact.getType(), this.type)) {
            if (!this.isVariable() && !fact.isVariable()) {
                return false;
            }
            Bindings bindings2 = new Bindings(bindings);
            if (!this.attr.unifiesWith(fact.getAttributeList(), bindings2)) {
                return false;
            }
            bindings.set(bindings2);
            return true;
        }
        return false;
    }

    public boolean isa(String string) {
        return this.type.equals(string) || this.ontology.isAncestorOf(this.type, string);
    }

    public ValueFunction functor() {
        return this.functor;
    }

    public boolean resolve(Bindings bindings) {
        return this.resolve(new ResolutionContext(), bindings);
    }

    public boolean resolve(ResolutionContext resolutionContext, Bindings bindings) {
        Fact fact = resolutionContext.put(THIS, this);
        boolean bl = this.attr.resolve(resolutionContext, bindings);
        if (fact != null) {
            resolutionContext.put(THIS, fact);
        }
        return bl;
    }

    public boolean disjoin(Fact fact) {
        if (!this.type.equals(fact.getType())) {
            return false;
        }
        this.attr.disjoin(fact.getAttributeList());
        return true;
    }

    public Fact duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public Fact duplicate(DuplicationTable duplicationTable) {
        String string = duplicationTable.getRef(this.id);
        AttributeList attributeList = this.attr.duplicate(duplicationTable);
        Fact fact = new Fact(this.type, string, this.modifiers, attributeList, this.ontology);
        return fact;
    }

    public synchronized String[] buildMap(Fact fact) {
        this.debug(this.type);
        String[] stringArray = new String[this.attr.size()];
        Enumeration enumeration = this.attr.keys();
        AttributeList attributeList = fact.getAttributeList();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = attributeList.keys();
            String string = (String)enumeration.nextElement();
            String string2 = this.attr.getValue(string);
            int n2 = 0;
            boolean bl = false;
            while (enumeration2.hasMoreElements() && !bl) {
                String string3 = (String)enumeration2.nextElement();
                String string4 = attributeList.getValue(string3);
                ValueFunction valueFunction = attributeList.getFn(string3);
                this.debug("mVf = " + valueFunction.toString() + " " + valueFunction.getClass());
                ValueFunction valueFunction2 = this.attr.getFn(string);
                this.debug("vf = " + valueFunction2.toString());
                if (valueFunction.equals(valueFunction2)) {
                    this.debug("mVf == vf");
                } else {
                    this.debug("mVf != vf");
                }
                this.debug("in buildMap mkey = " + string3 + " mval = " + string4 + " val = " + string2);
                if (string4.equals(string2) && string2.startsWith(V_STR)) {
                    this.debug("mapping:" + string4 + " = " + string2);
                    stringArray[n] = string3;
                    bl = true;
                } else if (string2.startsWith(fact.getId())) {
                    this.debug("ID's match!!");
                    String string5 = string2.substring(fact.getId().length() + 1, string2.length());
                    this.debug("attrVal == " + string5);
                    if (!string3.equals(string5)) {
                        this.debug(string3 + " != " + string5);
                        stringArray[n] = null;
                    } else {
                        this.debug(string3 + " == " + string5);
                        stringArray[n] = string3;
                        bl = true;
                    }
                } else {
                    stringArray[n] = null;
                }
                ++n2;
            }
            ++n;
        }
        return stringArray;
    }

    public synchronized void doMap(Fact fact, String[] stringArray) {
        Core.DEBUG(1, "in doMap in Fact\n");
        AttributeList attributeList = fact.getAttributeList();
        this.debug("attr == " + this.attr.toString());
        this.debug("mapperAttr = " + attributeList.toString());
        AttributeList attributeList2 = this.attr.duplicate("newAttr", new GenSym("temp"));
        this.debug("newAttr == " + attributeList2.toString());
        Enumeration enumeration = this.attr.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.debug("int doMap key = " + string);
            ValueFunction valueFunction = this.attr.getFn(string);
            if (stringArray[n] != null) {
                this.debug("altering value");
                attributeList2.remove(string);
                this.debug("tmap = " + stringArray[n]);
                this.debug("count = " + String.valueOf(n));
                this.debug("mapper.getFn(tmap[count]) = " + fact.getFn(stringArray[n]));
                attributeList2.put(string, fact.getFn(stringArray[n]));
            } else {
                attributeList2.put(string, valueFunction);
            }
            ++n;
        }
        this.attr = attributeList2;
    }

    public synchronized ValueFunction getVal(int n) {
        Enumeration enumeration = this.attr.keys();
        int n2 = 0;
        if (n < this.attr.size()) {
            String string = null;
            for (n2 = 0; n2 <= n; ++n2) {
                string = (String)enumeration.nextElement();
            }
            this.debug("key = " + string);
            return this.attr.getFn(string);
        }
        this.debug(String.valueOf(this.attr.size()));
        return null;
    }

    public void map(Fact fact) {
        String[] stringArray = this.buildMap(fact);
        this.doMap(fact, stringArray);
    }

    private void debug(String string) {
    }

    public static void main(String[] stringArray) {
    }
}

